/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace.nodes;

import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.ReferenceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldState
extends ReferenceState
implements Comparable<FieldState> {
    private final FieldInfo field;
    private int definitionID;
    private Value currentValue = null;
    private long valueID = 0L;

    public FieldState(Trace trace, long objectID, FieldInfo field) {
        super(trace, objectID);
        this.field = field;
    }

    public FieldInfo getField() {
        return this.field;
    }

    @Override
    public String toString() {
        String name = this.field.getDisplayName(true, -1);
        if (!this.isInstantiated()) {
            return "<html><strike>" + name + "</strike>";
        }
        String value = this.isUpdated() ? (this.currentValue == null ? "<b>" + this.field.getDefaultValue() + "</b>" : "<b>" + this.currentValue.getDisplayName(true) + "</b>") : "...";
        return "<html>" + name + " = " + value;
    }

    @Override
    public int compareTo(FieldState o) {
        return this.field.getName().compareTo(o.field.getName());
    }

    @Override
    public boolean isLeaf() {
        return this.isUpdated() ? this.getValueID() <= 0L : true;
    }

    private long getValueID() {
        this.update();
        return this.valueID;
    }

    @Override
    public long getObjectIDForChildren() {
        return this.getValueID();
    }

    @Override
    protected boolean performUpdate() {
        EventKind kind;
        long oldValueID = this.valueID;
        this.currentValue = null;
        this.valueID = -1L;
        this.definitionID = this.trace.findFieldAssignmentBefore(this.field, this.objectID, this.currentEventID);
        if (this.definitionID > 0 && (kind = this.trace.getKind(this.definitionID)) == EventKind.PUTFIELD) {
            this.currentValue = this.trace.getDefinitionValueSet(this.definitionID);
            if (this.currentValue.isObject()) {
                this.valueID = this.currentValue.getLong();
            }
        }
        if (this.valueID != oldValueID) {
            this.resetChildren();
        }
        return true;
    }

    @Override
    public int getAssociatedEventID() {
        this.update();
        return this.definitionID;
    }

    @Override
    public String getAssociatedEventIDDescription() {
        return "value";
    }
}

