/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InvocationHistory
implements Saveable {
    private final Trace trace;
    private final TIntObjectHashMap<Map<MethodInfo, IntegerVector>> startIDsByThreadByMethod;
    private final Map<Invoke, IntegerVector> invocationIDsByInvocation;

    public InvocationHistory(Trace trace) {
        this.trace = trace;
        this.startIDsByThreadByMethod = new TIntObjectHashMap(trace.getNumberOfThreads());
        this.invocationIDsByInvocation = new HashMap<Invoke, IntegerVector>(trace.getNumberOfMethods());
    }

    public void addInvocationID(int invocationID) {
        Invoke invoke = (Invoke)this.trace.getInstruction(invocationID);
        IntegerVector invocations = this.invocationIDsByInvocation.get(invoke);
        if (invocations == null) {
            invocations = new IntegerVector(10);
            this.invocationIDsByInvocation.put(invoke, invocations);
        }
        invocations.append(invocationID);
    }

    public void addStartID(int startID, int threadID) {
        IntegerVector startIDs;
        MethodInfo method = this.trace.getInstruction(startID).getMethod();
        Map<MethodInfo, IntegerVector> startIDsByMethod = this.startIDsByThreadByMethod.get(threadID);
        if (startIDsByMethod == null) {
            startIDsByMethod = new HashMap<MethodInfo, IntegerVector>(this.trace.getNumberOfMethods() / 2);
            this.startIDsByThreadByMethod.put(threadID, startIDsByMethod);
        }
        if ((startIDs = startIDsByMethod.get(method)) == null) {
            startIDs = new IntegerVector(2);
            startIDsByMethod.put(method, startIDs);
        }
        startIDs.append(startID);
    }

    public int determineStartMethodIDOf(int eventID) {
        if (eventID < 0) {
            return -1;
        }
        MethodInfo method = this.trace.getInstruction(eventID).getMethod();
        int threadID = this.trace.getThreadID(eventID);
        Map<MethodInfo, IntegerVector> byMethod = this.startIDsByThreadByMethod.get(threadID);
        IntegerVector startIDs = byMethod.get(method);
        int indexOfMostRecentStartID = startIDs.getIndexOfLargestValueLessThanOrEqualTo(eventID);
        if (indexOfMostRecentStartID < 0) {
            Whyline.debug("Must be an old trace, because the given event occurs before the startID representing its methods call. I've since fixed this bug, but this trace is out of date.");
            indexOfMostRecentStartID = 0;
        }
        int startID = startIDs.get(indexOfMostRecentStartID);
        int correspondingReturnID = this.trace.getStartIDsReturnOrCatchID(startID);
        while (correspondingReturnID != -1 && correspondingReturnID < eventID) {
            if (--indexOfMostRecentStartID < 0) break;
            startID = startIDs.get(indexOfMostRecentStartID);
            correspondingReturnID = this.trace.getStartIDsReturnOrCatchID(startID);
        }
        return startID;
    }

    public IntegerVector findInvocationsOfPublicStateAffectingMethodsWithParametersOnObjectIDBefore(long objectID, int beforeID) {
        IntegerVector results = new IntegerVector(10);
        int initID = this.trace.getInitializationOfObjectID(objectID);
        IntegerVector invocationsToCheck = new IntegerVector(100);
        Classfile classfile = this.trace.getClassfileOfObjectID(objectID);
        if (classfile != null) {
            for (MethodInfo method : classfile.getPublicInstanceMethods()) {
                if (!method.isStateAffecting() || method.getNumberOfArguments() <= 0) continue;
                block1: for (Invoke invoke : method.getPotentialCallers()) {
                    int indexJustBeforeEventID;
                    IntegerVector invocations = this.invocationIDsByInvocation.get(invoke);
                    if (invocations == null) continue;
                    int i = indexJustBeforeEventID = invocations.getIndexOfLargestValueLessThanOrEqualTo(beforeID);
                    while (i >= 0) {
                        int invocationID = invocations.get(i);
                        if (initID > 0 && invocationID < initID) continue block1;
                        if (invocationID != beforeID) {
                            invocationsToCheck.append(invocationID);
                        }
                        --i;
                    }
                }
            }
        }
        invocationsToCheck.sortInAscendingOrder();
        int i = 0;
        while (i < invocationsToCheck.size()) {
            int invocationID = invocationsToCheck.get(i);
            if (this.trace.getInvocationInstanceID(invocationID) == objectID) {
                results.append(invocationID);
            }
            ++i;
        }
        return results;
    }

    public IntegerVector findInvocationsOnObjectIDAfterEventID(Invoke invoke, long objectID, int eventIDAfter) {
        IntegerVector results = new IntegerVector(10);
        IntegerVector invocations = this.invocationIDsByInvocation.get(invoke);
        if (invocations != null) {
            int indexJustBeforeEventID = invocations.getIndexOfLargestValueLessThanOrEqualTo(eventIDAfter);
            if (indexJustBeforeEventID < 0) {
                indexJustBeforeEventID = 0;
            }
            int i = indexJustBeforeEventID;
            while (i < invocations.size()) {
                int invocationID = invocations.get(i);
                if (invocationID >= eventIDAfter && (objectID == 0L || this.trace.getInvocationInstanceID(invocationID) == objectID)) {
                    results.append(invocationID);
                }
                ++i;
            }
        }
        return results;
    }

    public IntegerVector getStartIDsAfterEventID(MethodInfo method, int eventIDAfter) {
        return this.getStartIDsOnObjectIDAfterEventID(method, -1L, eventIDAfter);
    }

    public IntegerVector getStartIDsOnObjectIDAfterEventID(MethodInfo method, long objectID, int eventIDAfter) {
        IntegerVector results = new IntegerVector(10);
        int[] nArray = this.startIDsByThreadByMethod.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int threadID = nArray[n2];
            Map<MethodInfo, IntegerVector> startIDsByMethod = this.startIDsByThreadByMethod.get(threadID);
            IntegerVector starts = startIDsByMethod.get(method);
            if (starts != null) {
                int indexJustBeforeEventID = starts.getIndexOfLargestValueLessThanOrEqualTo(eventIDAfter);
                if (indexJustBeforeEventID < 0) {
                    indexJustBeforeEventID = 0;
                }
                int i = indexJustBeforeEventID;
                while (i < starts.size()) {
                    int startID = starts.get(i);
                    if (startID >= eventIDAfter) {
                        if (objectID <= 0L) {
                            results.append(startID);
                        } else {
                            int invocationID = this.trace.getStartIDsInvocationID(startID);
                            if (invocationID >= 0 && this.trace.getInvocationInstanceID(invocationID) == objectID) {
                                results.append(startID);
                            }
                        }
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return results;
    }

    public void trimToSize() {
        for (IntegerVector ids : this.invocationIDsByInvocation.values()) {
            ids.trimToSize();
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.startIDsByThreadByMethod.size());
        int[] nArray = this.startIDsByThreadByMethod.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int threadID = nArray[n2];
            out.writeInt(threadID);
            Map<MethodInfo, IntegerVector> startIDsByMethod = this.startIDsByThreadByMethod.get(threadID);
            out.writeInt(startIDsByMethod.size());
            for (MethodInfo method : startIDsByMethod.keySet()) {
                out.writeUTF(method.getClassfile().getInternalName().getText());
                out.writeUTF(method.getMethodNameAndDescriptor());
                startIDsByMethod.get(method).write(out);
            }
            ++n2;
        }
        out.writeInt(this.invocationIDsByInvocation.size());
        for (Invoke invoke : this.invocationIDsByInvocation.keySet()) {
            out.writeInt(this.trace.getInstructionIDFor(invoke));
            this.invocationIDsByInvocation.get(invoke).write(out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int byThreadSize = in.readInt();
        int i = 0;
        while (i < byThreadSize) {
            int threadID = in.readInt();
            int byMethodSize = in.readInt();
            HashMap<MethodInfo, IntegerVector> startIDsByMethod = new HashMap<MethodInfo, IntegerVector>(byMethodSize);
            int j = 0;
            while (j < byMethodSize) {
                Classfile classfile = this.trace.getClassfileByName(QualifiedClassName.get(in.readUTF()));
                MethodInfo method = classfile.getDeclaredMethodByNameAndDescriptor(in.readUTF());
                startIDsByMethod.put(method, new IntegerVector(in));
                ++j;
            }
            this.startIDsByThreadByMethod.put(threadID, startIDsByMethod);
            ++i;
        }
        int byInvocationSize = in.readInt();
        int i2 = 0;
        while (i2 < byInvocationSize) {
            this.invocationIDsByInvocation.put((Invoke)this.trace.getInstructionWithID(in.readInt()), new IntegerVector(in));
            ++i2;
        }
    }
}

