/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TLongObjectHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ArrayHistory
implements Saveable {
    private final Trace trace;
    private final TLongObjectHashMap<IntegerVector> eventsByArrayID = new TLongObjectHashMap();

    public ArrayHistory(Trace trace) {
        this.trace = trace;
    }

    private void storeArrayEventID(long arrayID, int eventID) {
        IntegerVector assignmentIDs = this.eventsByArrayID.get(arrayID);
        if (assignmentIDs == null) {
            assignmentIDs = new IntegerVector(10);
            this.eventsByArrayID.put(arrayID, assignmentIDs);
        }
        assignmentIDs.append(eventID);
    }

    public void addArrayAssignmentID(int eventID) {
        long arrayID = this.trace.getSetArrayArraySet(eventID).getLong();
        if (arrayID > 0L) {
            this.storeArrayEventID(arrayID, eventID);
        }
    }

    public void addToCharArrayID(int eventID) {
        long arrayID = this.trace.getObjectIDProduced(eventID);
        if (arrayID > 0L) {
            this.storeArrayEventID(arrayID, eventID);
        }
    }

    public void addArrayCopyID(int eventID) {
        long arrayID = this.trace.getOperandStackValue(eventID, 2).getLong();
        if (arrayID > 0L) {
            this.storeArrayEventID(arrayID, eventID);
        }
    }

    public Object getValueOfIndexAtTime(long arrayID, int index, int time) {
        return this.getSomethingAtIndexAtTime(arrayID, index, time, true);
    }

    public int getIndexAssignmentBefore(long arrayID, int index, int time) {
        return (Integer)this.getSomethingAtIndexAtTime(arrayID, index, time, false);
    }

    /*
     * Unable to fully structure code
     */
    private Object getSomethingAtIndexAtTime(long arrayID, int index, int time, boolean returnValue) {
        block12: {
            arrayEvents = this.eventsByArrayID.get(arrayID);
            if (arrayEvents == null) break block12;
            i = arrayEvents.size() - 1;
            while (i >= 0) {
                block10: {
                    block11: {
                        arrayEventID = arrayEvents.get(i);
                        kind = this.trace.getKind(arrayEventID);
                        if (kind == EventKind.SETARRAY) {
                            if (this.trace.getSetArrayIndexSet(arrayEventID).getInteger() == index) {
                                if (returnValue) {
                                    return this.trace.getSetArrayValueSet(arrayEventID).getValue();
                                }
                                return arrayEventID;
                            }
                            break block10;
                        }
                        if (!kind.isInvocation) ** GOTO lbl32
                        method = ((Invoke)this.trace.getInstruction(arrayEventID)).getMethodInvoked().getMethodName();
                        if (!method.equals("arraycopy")) ** GOTO lbl27
                        destPos = this.trace.getOperandStackValue(arrayEventID, 3).getInteger();
                        length = this.trace.getOperandStackValue(arrayEventID, 4).getInteger();
                        if (destPos > index || destPos + length - 1 < index) break block10;
                        sourceID = this.trace.getOperandStackValue(arrayEventID, 0).getLong();
                        if (sourceID >= 0L) break block11;
                        return -1;
                    }
                    try {
                        sourcePos = this.trace.getOperandStackValue(arrayEventID, 1).getInteger();
                        return this.getSomethingAtIndexAtTime(sourceID, sourcePos + (index - destPos), time, returnValue);
lbl27:
                        // 1 sources

                        if (method.equals("toCharArray")) {
                            if (returnValue) {
                                return Character.valueOf(this.getCharFromToCharArrayEvent(arrayEventID, index));
                            }
                            return arrayEventID;
                        }
                        break block10;
lbl32:
                        // 1 sources

                        if (!ArrayHistory.$assertionsDisabled) {
                            throw new AssertionError((Object)("We looked up " + i + " in " + arrayEvents + ", which pointed to event " + arrayEvents.get(i) + " and got " + arrayEventID + " instead of a SetArrayValueEvent. Here's the rest of the history:\n\n" + this.trace.getContextAroundEventAtIndex(arrayEventID, 30)));
                        }
                    }
                    catch (NoValueException var10_10) {
                        // empty catch block
                    }
                }
                --i;
            }
        }
        return returnValue != false ? null : Integer.valueOf(-1);
    }

    private char getCharFromToCharArrayEvent(int arrayEventID, int index) {
        long stringID = this.trace.getOperandStackValue(arrayEventID, 0).getLong();
        if (stringID > 0L) {
            String text = (String)this.trace.getImmutableObject(stringID);
            char c = text.charAt(index);
            return c;
        }
        return '?';
    }

    public void trimToSize() {
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.eventsByArrayID.size());
        long[] lArray = this.eventsByArrayID.keys();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long objectID = lArray[n2];
            out.writeLong(objectID);
            this.eventsByArrayID.get(objectID).write(out);
            ++n2;
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        this.eventsByArrayID.ensureCapacity(size);
        int i = 0;
        while (i < size) {
            this.eventsByArrayID.put(in.readLong(), new IntegerVector(in));
            ++i;
        }
        this.eventsByArrayID.trimToSize();
    }
}

