/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenRange
implements Iterable<Token> {
    public final Token first;
    public final Token last;

    public TokenRange(Token first, Token last) {
        this.first = first;
        this.last = last;
        assert (first != null) : "First token was null";
        assert (last != null) : "Second token was null";
    }

    public FileInterface getFile() {
        return this.first.getFile();
    }

    @Override
    public Iterator<Token> iterator() {
        return new Iterator<Token>(){
            private Token token;
            {
                this.token = TokenRange.this.first;
            }

            @Override
            public boolean hasNext() {
                return this.token != null;
            }

            @Override
            public Token next() {
                Token tokenToReturn = this.token;
                this.token = this.token == TokenRange.this.last || TokenRange.this.last == null ? null : this.token.getNext();
                return tokenToReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Token ranges are immutable.");
            }
        };
    }

    public boolean onSingleLine() {
        Line two;
        Line one = this.first.getLine();
        return one == (two = this.last.getLine());
    }

    public String toString() {
        return String.valueOf(this.first == null ? "?" : "\"" + this.first.getText() + "\"") + " to " + (this.last == null ? "?" : "\"" + this.last.getText() + "\"");
    }
}

