/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.source.FileInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineNumber
implements Comparable<LineNumber> {
    private final FileInterface file;
    private final int number;

    public LineNumber(FileInterface file, int number) {
        assert (number > 0) : "Line numbers must be greater than 0";
        this.file = file;
        this.number = number;
    }

    public boolean equal(Object o) {
        if (!(o instanceof LineNumber)) {
            return false;
        }
        return ((LineNumber)o).number == this.number;
    }

    public boolean isAfter(LineNumber line) {
        assert (this.file == line.file);
        return this.number > line.number;
    }

    public boolean isBefore(LineNumber line) {
        assert (this.file == line.file);
        return this.number < line.number;
    }

    public boolean isBetweenInclusive(LineNumber before, LineNumber after) {
        return this.number >= before.number && this.number <= after.number;
    }

    public boolean is(LineNumber line) {
        assert (this.file == line.file) : "These lines are in different files: " + this.file + " and " + line.file;
        return this.number == line.number;
    }

    public int getNumber() {
        return this.number;
    }

    public FileInterface getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getShortFileName() + ":" + this.number;
    }

    @Override
    public int compareTo(LineNumber o) {
        if (this.file == o.file) {
            return this.number - o.number;
        }
        return this.file.compareTo(o.file);
    }
}

