/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.source.BlockElement;
import edu.cmu.hcii.whyline.source.ClassElement;
import edu.cmu.hcii.whyline.source.Decompiler;
import edu.cmu.hcii.whyline.source.JavaElement;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.ParametersElement;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import java.util.List;

public class ClassBodyElement
extends JavaElement {
    private boolean isMethod;
    private Token name;
    private Token tokenAfterHeader;
    private ParametersElement parameters;
    private BlockElement block;
    private MethodInfo method;
    private FieldInfo field;
    private String simpleReturnType;
    private TokenRange returnTypeRange;

    public ClassBodyElement(JavaElement parent, Token first, Token last) {
        super(parent, first, last);
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    protected void parse(JavaParser.TokenIterator tokens) throws ParseException {
        Classfile classfile;
        this.optionalModifiers(tokens);
        this.typeArguments(tokens);
        Token lastTypeToken = null;
        if (tokens.peek().isIdentifier() && tokens.peekNext().kind == 79) {
            this.simpleReturnType = "V";
        } else if (tokens.nextKindIs(62)) {
            Token returnType = tokens.getNext();
            this.simpleReturnType = "V";
            this.returnTypeRange = new TokenRange(returnType, returnType);
        } else {
            Token firstReturnTypeToken = tokens.peek();
            this.simpleReturnType = this.type(tokens);
            this.simpleReturnType = NameAndTypeInfo.sourceTypeToDescriptorType(this.simpleReturnType);
            lastTypeToken = tokens.peek().getPreviousCodeToken();
            this.returnTypeRange = new TokenRange(firstReturnTypeToken, lastTypeToken);
        }
        this.name = tokens.getNext();
        this.isMethod = false;
        if (tokens.nextKindIs(79)) {
            this.isMethod = true;
            this.parameters = this.parameters(tokens);
            classfile = this.getEnclosingClassfile();
            if (classfile != null) {
                String desc = this.getSimpleDescriptor();
                for (MethodInfo methodInfo : classfile.getDeclaredMethods()) {
                    if (!methodInfo.getJavaName().equals(this.name.getText()) || !methodInfo.getSimpleDescriptor().equals(desc)) continue;
                    this.method = methodInfo;
                    break;
                }
            }
            if (this.method != null) {
                this.parameters.associateTokens(this.method);
            } else {
                System.err.println("Failed to resolve " + this.name + this.getSimpleDescriptor() + " in class " + classfile);
                if (classfile == null) {
                    System.err.println("\tNo class passed to this method");
                } else {
                    for (MethodInfo m : classfile.getDeclaredMethods()) {
                        System.err.println("\t" + m.getJavaName() + m.getSimpleDescriptor());
                    }
                }
            }
            if (tokens.nextKindIs(58)) {
                while (tokens.hasNext() && !tokens.nextKindIs(81) && !tokens.nextKindIs(85)) {
                    tokens.getNext();
                }
            }
            if (tokens.nextKindIs(81)) {
                Decompiler code = this.method == null || this.method.getCode() == null ? null : new Decompiler(this.getSource(), this.method.getCode());
                Token.PairedToken pairedToken = (Token.PairedToken)tokens.getNext(81);
                tokens.jumpPast(pairedToken.getAssociatedToken());
                this.block = new BlockElement(this.method, this, pairedToken, pairedToken.getAssociatedToken(), code);
                this.tokenAfterHeader = pairedToken;
            } else {
                this.tokenAfterHeader = tokens.getNext(85);
            }
        } else {
            classfile = this.getEnclosingClassfile();
            if (classfile != null) {
                for (FieldInfo f : classfile.getDeclaredFields()) {
                    if (!f.getName().equals(this.name.getText())) continue;
                    this.field = f;
                    break;
                }
            }
            if (this.field != null && lastTypeToken != null) {
                this.getSource().linkTokenWithClassname(lastTypeToken, this.field.getTypeName());
            }
            List<Token.PairedToken> openBraces = this.passAnonymousInnerClassesUntilSemiColon(tokens);
            Token token = tokens.getNext(85);
            for (Token.PairedToken brace : openBraces) {
                this.getEnclosingClass().addInnerClass(new ClassElement(this, brace, brace.getAssociatedToken(), true));
            }
            tokens.jumpPastNext(85);
        }
    }

    public Classfile getEnclosingClassfile() {
        ClassElement enclosing = this.parent.getEnclosingClass();
        return enclosing == null ? null : enclosing.getClassfile();
    }

    public void parseBlock() {
        if (this.block != null) {
            this.block.parse();
        }
    }

    public Token getNameToken() {
        this.parse();
        return this.name;
    }

    public String getJavaDoc() {
        return null;
    }

    public Token getParameterNameToken(int number) {
        return this.parameters == null ? null : this.parameters.getIdentifierOfParameter(number);
    }

    public Token getTokenAfterHeader() {
        return this.tokenAfterHeader;
    }

    public TokenRange getTokenRangeForParameter(int parameter) {
        this.parse();
        if (parameter == 0) {
            return new TokenRange(this.name, this.name);
        }
        Token name = this.parameters.getIdentifierOfParameter(parameter);
        return new TokenRange(name, name);
    }

    public TokenRange getTokenRangeOfHeader() {
        this.parse();
        return new TokenRange(this.firstToken, this.tokenAfterHeader);
    }

    public TokenRange getTokenRangeForReturnType() {
        return this.returnTypeRange;
    }

    protected ParametersElement parameters(JavaParser.TokenIterator tokens) throws ParseException {
        Token.PairedToken open = (Token.PairedToken)tokens.getNext();
        tokens.jumpPast(open.getAssociatedToken());
        return new ParametersElement(this, (Token)open, (Token)open.getAssociatedToken());
    }

    public boolean isInnerClassConstructor() {
        Classfile classfile = this.getEnclosingClassfile();
        return classfile != null && classfile.isInnerClass() && !classfile.isStatic() && this.name != null && classfile.getSimpleName().equals(this.name.getText());
    }

    public String getSimpleDescriptor() {
        this.parse();
        if (this.parameters != null) {
            String descriptor = this.parameters.getSimpleDescriptor();
            if (this.isInnerClassConstructor()) {
                Classfile classfile = this.getEnclosingClassfile();
                QualifiedClassName outerClassName = classfile.getInternalName().getOuterClassName();
                StringBuilder newDescriptor = new StringBuilder();
                newDescriptor.append("(");
                newDescriptor.append("L");
                newDescriptor.append(outerClassName.getText());
                newDescriptor.append(";");
                newDescriptor.append(descriptor.substring(1));
                descriptor = newDescriptor.toString();
            }
            return descriptor;
        }
        return this.simpleReturnType;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public String toString() {
        return "MethodOrField " + this.getNameToken();
    }
}

