/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.DefaultValueAnswer;
import edu.cmu.hcii.whyline.qa.MessageAnswer;
import edu.cmu.hcii.whyline.qa.WhyDidQuestion;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhyDidFieldHaveValue
extends WhyDidQuestion<FieldInfo> {
    private final ObjectState object;
    private final FieldInfo field;

    public WhyDidFieldHaveValue(Asker asker, ObjectState object, FieldInfo field, String event) {
        super(asker, field, event);
        this.object = object;
        this.field = field;
    }

    @Override
    protected Answer answer() throws AnalysisException {
        EventKind kind;
        int assignmentID = this.trace.findFieldAssignmentBefore(this.field, this.object.getObjectID(), this.asker.getCurrentScope().getInputEventID());
        Answer answer = assignmentID < 0 ? new MessageAnswer(this, "Couldn't find an assignment to this field. Either the Whyline didn't record the assignment, or the value was a default value assigned when the object was instantiated.") : ((kind = this.trace.getKind(assignmentID)) == EventKind.PUTFIELD ? this.trace.getDefinitionValueSet(assignmentID).getAnswer(this) : (kind == EventKind.NEW_OBJECT ? new DefaultValueAnswer(this, this.object, this.field, assignmentID) : new MessageAnswer(this, "OOPS! Looked for an assignment to this field, but found a " + (Object)((Object)kind) + "!")));
        return answer;
    }

    @Override
    public String getQuestionExplanation() {
        return "explain why <b>" + this.getDescriptionOfSubject() + "</b> " + this.getDescriptionOfEvent();
    }
}

