/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.WhyDidEventOccur;
import edu.cmu.hcii.whyline.qa.WhyDidntInstructionExecute;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextMenuFactory {
    public static QuestionMenu getTextualOutputMenu(Asker asker, TextualOutputEvent event) {
        QuestionMenu questions = new QuestionMenu(asker, "Questions about text", "");
        QuestionMenu whyDidntMenu = new QuestionMenu(asker, "Questions about text that <i>didn't</i> print", "why didn't");
        if (event != null) {
            questions.addQuestion(new WhyDidEventOccur(asker, event.getEventID(), "<em>" + event.getStringPrinted() + "</em> print"));
        }
        Collection<Instruction> outputByFinalConsumer = asker.getTrace().getTextualOutputInvokingInstructions();
        TreeMap<MethodInfo, TreeSet<Instruction>> textOutputByMethods = new TreeMap<MethodInfo, TreeSet<Instruction>>();
        for (Instruction textOutput : outputByFinalConsumer) {
            if (!asker.getTrace().classIsReferencedInFamiliarSourceFile(textOutput.getClassfile().getInternalName())) continue;
            TreeSet<Instruction> outputInMethod = (TreeSet<Instruction>)textOutputByMethods.get(textOutput.getMethod());
            if (outputInMethod == null) {
                outputInMethod = new TreeSet<Instruction>();
                textOutputByMethods.put(textOutput.getMethod(), outputInMethod);
            }
            outputInMethod.add(textOutput);
        }
        TreeMap<Classfile, QuestionMenu> classMenus = new TreeMap<Classfile, QuestionMenu>();
        for (MethodInfo method : textOutputByMethods.keySet()) {
            QuestionMenu methodMenu = new QuestionMenu(asker, "Questions about text that % didn't print.", "%", method);
            SortedSet outputInMethod = (SortedSet)textOutputByMethods.get(method);
            for (Instruction textOutput : outputInMethod) {
                String string = "this string";
                string = textOutput instanceof PushConstant ? "\"" + ((PushConstant)textOutput).getConstant() + "\"" : TextMenuFactory.concatenateConstantStringsFromToString(textOutput, "");
                methodMenu.addQuestion(new WhyDidntInstructionExecute(asker, textOutput, "print " + string));
            }
            QuestionMenu classMenu = (QuestionMenu)classMenus.get(method.getClassfile());
            if (classMenu == null) {
                classMenu = new QuestionMenu(asker, "Questions about text that % didn't print", "%", method.getClassfile());
                classMenus.put(method.getClassfile(), classMenu);
            }
            classMenu.addMenu(methodMenu);
        }
        for (QuestionMenu classMenu : classMenus.values()) {
            whyDidntMenu.addMenu(classMenu);
        }
        questions.addMenu(whyDidntMenu);
        return questions;
    }

    private static String concatenateConstantStringsFromToString(Instruction inst, String text) {
        int arg = 0;
        while (arg < inst.getNumberOfArgumentProducers()) {
            text = String.valueOf(text) + TextMenuFactory.concatenateConstantStringsFromToString(inst.getProducersOfArgument(arg).getFirstProducer(), text);
            ++arg;
        }
        if (inst instanceof PushConstant) {
            text = String.valueOf(text) + ((PushConstant)inst).getConstant();
        } else if (inst instanceof GetLocal) {
            text = String.valueOf(text) + ((GetLocal)inst).getLocalIDName();
        }
        return text;
    }
}

