/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.io.IOEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Named;

public final class Scope
implements Named {
    private final Trace trace;
    private final int inputEventID;
    private final int outputEventID;

    public Scope(Trace trace, int inputID, int outputID) {
        this.trace = trace;
        this.inputEventID = inputID;
        this.outputEventID = outputID;
    }

    public IOEvent getInputEvent() {
        return this.trace.getIOHistory().getEventAtTime(this.inputEventID);
    }

    public IOEvent getOutputEvent() {
        return this.trace.getIOHistory().getEventAtTime(this.outputEventID);
    }

    public int getInputEventID() {
        return this.inputEventID;
    }

    public int getOutputEventID() {
        return this.outputEventID;
    }

    public String getDescription() {
        IOEvent eventAtInputTime = this.getInputEvent();
        return this.inputEventID == 0 ? "the program started..." : (eventAtInputTime == null ? "event " + this.inputEventID : eventAtInputTime.getHTMLDescription()) + "...";
    }

    public String getDisplayName(boolean html, int lengthLimit) {
        return this.getDescription();
    }

    public boolean isEndOfProgram() {
        return this.inputEventID == this.trace.getNumberOfEvents() - 1;
    }

    public boolean includesInclusive(int eventID) {
        return this.inputEventID <= eventID && this.outputEventID >= eventID;
    }

    public boolean includesExclusive(int eventID) {
        return this.inputEventID < eventID && this.outputEventID > eventID;
    }
}

