/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.io.GraphicalEventAppearance;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.SetCompositeEvent;
import edu.cmu.hcii.whyline.io.SetFontEvent;
import edu.cmu.hcii.whyline.io.SetPaintEvent;
import edu.cmu.hcii.whyline.io.SetStrokeEvent;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.ObjectQuestions;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.QuestionMenu;
import edu.cmu.hcii.whyline.qa.QuestionMenuMaker;
import edu.cmu.hcii.whyline.qa.WhyDidArgumentHaveValue;
import edu.cmu.hcii.whyline.qa.WhyDidFieldHaveValue;
import edu.cmu.hcii.whyline.qa.WhyDidObjectGetCreated;
import edu.cmu.hcii.whyline.qa.WhyDidntFieldChange;
import edu.cmu.hcii.whyline.qa.WhyDidntMethodExecute;
import edu.cmu.hcii.whyline.qa.WhyDidntWindowAppear;
import edu.cmu.hcii.whyline.trace.CallStack;
import edu.cmu.hcii.whyline.trace.CallStackEntry;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.TraceValue;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicsMenuFactory {
    private final Asker asker;
    private final Trace trace;
    private final SortedSet<GraphicalEventAppearance> renderEvents;

    public GraphicsMenuFactory(Asker asker, SortedSet<GraphicalEventAppearance> renderEvents) {
        this.asker = asker;
        this.trace = asker.getTrace();
        this.renderEvents = renderEvents;
    }

    public static QuestionMenu getQuestionMenu(Asker asker, SortedSet<GraphicalEventAppearance> renderEvents) {
        return new GraphicsMenuFactory(asker, renderEvents).getQuestionMenu();
    }

    private long[] findControlEntities() {
        ArrayList<EntityRender> entityRenders = new ArrayList<EntityRender>();
        for (GraphicalEventAppearance render : this.renderEvents) {
            CallStack stack = render.renderer.getCallStack();
            int distance = stack.getDepth();
            for (CallStackEntry entry : stack) {
                MethodInfo method = entry.getMethod();
                int invocationID = entry.getInvocationID();
                if (invocationID >= 0) {
                    QualifiedClassName classOfInstanceCalled = this.trace.getInvocationClassInvokedOn(invocationID);
                    boolean classIsReferenced = this.trace.classIsReferencedInFamiliarSourceFile(classOfInstanceCalled);
                    long entityID = this.trace.getInvocationInstanceID(invocationID);
                    if (entityID > 0L && classIsReferenced) {
                        EntityRender entityRender = null;
                        for (EntityRender temp : entityRenders) {
                            if (temp.entityID != entityID) continue;
                            entityRender = temp;
                        }
                        if (entityRender == null) {
                            entityRender = new EntityRender(entityID, render, distance);
                            entityRenders.add(entityRender);
                        }
                        if (entityRender.event.renderer.getEventID() < render.renderer.getEventID()) {
                            entityRender.event = render;
                            entityRender.distance = distance;
                        }
                    }
                }
                --distance;
            }
        }
        Collections.sort(entityRenders, new Comparator<EntityRender>(){

            @Override
            public int compare(EntityRender one, EntityRender two) {
                if (one.event.renderer.getEventID() != two.event.renderer.getEventID()) {
                    return -one.event.compareTo(two.event);
                }
                return one.distance - two.distance;
            }
        });
        long[] entityIDs = new long[entityRenders.size()];
        int index = 0;
        for (EntityRender pair : entityRenders) {
            entityIDs[index++] = pair.entityID;
        }
        return entityIDs;
    }

    private List<FieldUse> findUpstreamOutputAffectingFields() {
        if (this.renderEvents.isEmpty()) {
            return new ArrayList<FieldUse>(0);
        }
        DataEntitySearchState state = new DataEntitySearchState();
        return state.fieldUses;
    }

    public QuestionMenu getQuestionMenu() {
        ObjectState obj;
        Object object;
        List<FieldUse> fieldUses;
        RenderEvent primitive;
        this.asker.processing(true);
        RenderEvent renderEvent = primitive = this.renderEvents.isEmpty() ? null : this.renderEvents.last().event;
        if (primitive == null) {
            return null;
        }
        String name = primitive.getDisplayName(false, -1);
        QuestionMenu questions = new QuestionMenu(this.asker, "Questions paint under the mouse.", "why did");
        if (primitive != null) {
            questions.addMenu(this.getWhyDidQuestionsAboutPrimitive(primitive));
        }
        if ((fieldUses = this.findUpstreamOutputAffectingFields()).size() > 0) {
            QuestionMenu dataDependencies = new QuestionMenu(this.asker, "Questions about object fields that affected the appearance of this <b>" + name + "</b>", "<b>fields</b> affecting this");
            TreeMap<String, ArrayList<FieldUse>> fieldsByType = new TreeMap<String, ArrayList<FieldUse>>();
            for (FieldUse use : fieldUses) {
                String type = use.field.getTypeName().getSimpleName();
                ArrayList<FieldUse> list = (ArrayList<FieldUse>)fieldsByType.get(type);
                if (list == null) {
                    list = new ArrayList<FieldUse>();
                    fieldsByType.put(type, list);
                }
                list.add(use);
            }
            for (String type : fieldsByType.keySet()) {
                QuestionMenu group = new QuestionMenu(this.asker, "Fields of type " + type, "<i>" + type + "s</i>");
                object = ((List)fieldsByType.get(type)).iterator();
                while (object.hasNext()) {
                    FieldUse use = (FieldUse)object.next();
                    obj = this.trace.getObjectNode(use.objectID);
                    QuestionMenu menu = this.getQuestionsAboutField(this.asker, obj, use.field, primitive.getEventID());
                    group.addMenu(menu);
                    menu.setLabel("<i>" + obj.getDisplayName(false, -1) + "</i>'s <b>" + use.field.getDisplayName(true, -1) + "</b>...");
                }
                dataDependencies.addMenu(group);
            }
            if (dataDependencies.getNumberOfItems() > 0) {
                questions.addMenu(dataDependencies);
            }
        }
        QuestionMenu controlDependencyQuestions = new QuestionMenu(this.asker, "Questions about objects that were responsible for drawing this <b>%</b>", "<b>objects</b> rendering this", primitive);
        long[] entityIDs = this.findControlEntities();
        object = entityIDs;
        int n = entityIDs.length;
        int n2 = 0;
        while (n2 < n) {
            long entityID = object[n2];
            obj = this.trace.getObjectNode(entityID);
            controlDependencyQuestions.addMenu(this.getWhyDidQuestionsAboutObject(obj));
            ++n2;
        }
        if (controlDependencyQuestions.getNumberOfItems() > 0) {
            questions.addMenu(controlDependencyQuestions);
        }
        QuestionMenu whydidnt = new QuestionMenu(this.asker, "Why didn't questions about input and windows", "<b>windows</b>");
        QuestionMenu windows = GraphicsMenuFactory.getWindowQuestions(this.asker);
        if (windows.getNumberOfItems() > 0) {
            whydidnt.addItemsOf(windows);
        }
        if (whydidnt.getNumberOfItems() > 0) {
            questions.addSeparator();
            questions.addMenu(whydidnt);
        }
        this.asker.processing(false);
        return questions;
    }

    public static QuestionMenu getWindowQuestions(Asker asker) {
        QuestionMenu questions = new QuestionMenu(asker, "Questions about windows that didn't appear.", "<b>windows</b> that didn't appear...");
        SortedSet<Classfile> windowClasses = asker.getTrace().getConcreteWindowClasses();
        if (windowClasses.size() > 0) {
            for (Classfile c : windowClasses) {
                questions.addQuestion(new WhyDidntWindowAppear(asker, c, "appear"));
            }
        }
        return questions;
    }

    private String pair(String argument, String value) {
        return "<b>" + argument + "</b> = " + value;
    }

    private QuestionMenu getWhyDidQuestionsAboutPrimitive(RenderEvent renderEvent) {
        SetCompositeEvent composite;
        SetStrokeEvent stroke;
        SetFontEvent font;
        QuestionMenu questions = new QuestionMenu(this.asker, "Questions about arguments used by this %", "<b>properties</b> of this <b>%</b>", renderEvent);
        int argumentIndex = 1;
        while (argumentIndex < renderEvent.getNumberOfArgumentProducers()) {
            Value value = renderEvent.getArgument(argumentIndex);
            questions.addItemsOf(GraphicsMenuFactory.makeArgumentMenu(this.asker, renderEvent.getArgumentName(argumentIndex), value, value.getDisplayName(true)));
            ++argumentIndex;
        }
        SetPaintEvent paint = renderEvent.getGraphicsState().getLatestPaintChange();
        if (paint != null) {
            questions.addItemsOf(GraphicsMenuFactory.makeArgumentMenu(this.asker, "color", paint.getPaintProducedEvent(), Util.format(paint.getPaint(), true)));
        }
        if ((font = renderEvent.getGraphicsState().getLatestFontChange()) != null) {
            questions.addItemsOf(GraphicsMenuFactory.makeArgumentMenu(this.asker, "font", font.getFontProducedEvent(), Util.format(font.getFont(), true)));
        }
        if ((stroke = renderEvent.getGraphicsState().getLatestStrokeChange()) != null) {
            questions.addItemsOf(GraphicsMenuFactory.makeArgumentMenu(this.asker, "stroke", stroke.getStrokeProducedEvent(), Util.format(stroke.getStroke(), true)));
        }
        if ((composite = renderEvent.getGraphicsState().getLatestCompositeChange()) != null) {
            questions.addItemsOf(GraphicsMenuFactory.makeArgumentMenu(this.asker, "composite", composite.getCompositeProducedEvent(), Util.format(composite.getComposite(), true)));
        }
        return questions;
    }

    private static QuestionMenu makeArgumentMenu(Asker asker, String argument, Value value, String valueDescription) {
        QuestionMenu questions = new QuestionMenu(asker, "Questions about this " + argument, argument, value);
        questions.addQuestion(new WhyDidArgumentHaveValue(asker, value, argument, " = <b>" + valueDescription + "</b>"));
        return questions;
    }

    private QuestionMenu getWhyDidQuestionsAboutObject(final ObjectState object) {
        Trace trace = this.asker.getTrace();
        Classfile classfile = trace.getClassfileByName(trace.getClassnameOfObjectID(object.getObjectID()));
        ObjectQuestions questions = new ObjectQuestions(object, new QuestionMenu(this.asker, "Questions about <b>%</b>", "%", object));
        SortedSet<FieldInfo> publiclyModifiableOutputAffectingFields = trace.getPublicOutputAffectingFieldsOf(classfile);
        for (final FieldInfo field : publiclyModifiableOutputAffectingFields) {
            QuestionMenuMaker maker = new QuestionMenuMaker(this.asker){

                public String getMenuLabel() {
                    return "<b>" + field.getDisplayName(true, -1) + "</b>";
                }

                public Named getSubject() {
                    return field;
                }

                public QuestionMenu make() {
                    return GraphicsMenuFactory.this.getQuestionsAboutField(GraphicsMenuFactory.this.asker, object, field, GraphicsMenuFactory.this.asker.getCurrentScope().getInputEventID());
                }
            };
            questions.addFieldQuestions(maker, field, true);
        }
        QuestionMenu menu = questions.createMenu();
        if (menu.getNumberOfItems() > 0) {
            menu.insertSeparator();
        }
        menu.insertQuestion(new WhyDidObjectGetCreated(this.asker, object, "<b>get created</b>"));
        if (classfile != null) {
            ArrayList<WhyDidntMethodExecute> methodQuestions = new ArrayList<WhyDidntMethodExecute>();
            SortedSet<MethodInfo> methods = trace.getPublicOutputInvokingMethodsOf(classfile);
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isVirtual() || methodInfo.isInstanceInitializer() || !trace.classIsReferencedInFamiliarSourceFile(classfile.getInternalName())) continue;
                methodQuestions.add(new WhyDidntMethodExecute(this.asker, methodInfo, object.getObjectID(), "execute"));
            }
            if (methodQuestions.size() > 0) {
                menu.addSeparator();
                if (methodQuestions.size() > 10) {
                    QuestionMenu questionMenu = new QuestionMenu(this.asker, "Questions about output invoking methods", "methods...");
                    for (Question question : methodQuestions) {
                        questionMenu.addQuestion(question);
                    }
                    menu.addMenu(questionMenu);
                } else {
                    for (Question question : methodQuestions) {
                        menu.addQuestion(question);
                    }
                }
            }
        }
        return menu;
    }

    private QuestionMenu getQuestionsAboutField(Asker asker, ObjectState object, FieldInfo field, int beforeID) {
        Trace trace = object.getTrace();
        QuestionMenu menu = new QuestionMenu(asker, "Questions about the field  <b>%</b>", "%", field);
        int assignmentID = trace.findFieldAssignmentBefore(field, object.getObjectID(), beforeID);
        String valueString = "unknown";
        Value value = null;
        if (assignmentID >= 0) {
            Instruction assignment = trace.getInstruction(assignmentID);
            if (assignment instanceof PUTFIELD) {
                value = trace.getDefinitionValueSet(assignmentID);
                if (value instanceof TraceValue) {
                    assignmentID = ((TraceValue)value).getEventID();
                }
                valueString = value.getDisplayName(true);
            } else if (assignment instanceof NEW) {
                Object defaultValue = field.getDefaultValue();
                valueString = "" + defaultValue;
            } else assert (false) : "What do I do with " + assignment + "?";
        }
        menu.addQuestion(new WhyDidFieldHaveValue(asker, object, field, " = " + valueString));
        menu.addQuestion(new WhyDidntFieldChange(asker, object, field, value, "change"));
        if (value != null && value.isObject() && value.getLong() > 0L) {
            menu.addSeparator();
            menu.addMenu(this.getWhyDidQuestionsAboutObject(trace.getObjectNode(value.getLong())));
        }
        return menu;
    }

    private class DataEntitySearchState {
        ArrayList<FieldUse> fieldUses = new ArrayList();
        TIntHashSet dependencies = new TIntHashSet();
        TIntHashSet newDependencies = new TIntHashSet();
        TIntHashSet visited = new TIntHashSet();

        public DataEntitySearchState() {
            GraphicalEventAppearance render = (GraphicalEventAppearance)GraphicsMenuFactory.this.renderEvents.last();
            int arg = 1;
            while (arg < render.event.getNumberOfArgumentProducers()) {
                Value value;
                String name = render.event.getArgumentName(arg);
                Invoke invoke = (Invoke)GraphicsMenuFactory.this.trace.getInstruction(render.event.getEventID());
                QualifiedClassName argumentType = invoke.getMethodInvoked().getParsedDescriptor().getTypeOfArgumentNumber(arg - 1);
                if (argumentType != QualifiedClassName.INT && (value = GraphicsMenuFactory.this.trace.getOperandStackValue(render.event.getEventID(), arg)).hasEventID()) {
                    this.dependencies.add(value.getEventID());
                    while (this.dependencies.size() > 0) {
                        TIntIterator iterator = this.dependencies.iterator();
                        while (iterator.hasNext()) {
                            IntegerVector objectDependencies;
                            int heapDependencyID;
                            boolean isProjectClass;
                            int eventID = iterator.next();
                            Instruction inst = GraphicsMenuFactory.this.trace.getInstruction(eventID);
                            this.visited.add(eventID);
                            boolean isFieldUse = inst instanceof GETFIELD;
                            QualifiedClassName fieldClassname = isFieldUse ? ((GETFIELD)inst).getFieldref().getClassname() : null;
                            boolean bl = isProjectClass = fieldClassname != null && !fieldClassname.getText().startsWith("java") && !fieldClassname.getText().startsWith("sun");
                            if (!isFieldUse || isProjectClass) {
                                for (Value vp : GraphicsMenuFactory.this.trace.getOperandStackDependencies(eventID)) {
                                    if (vp == null || vp.getEventID() < 0) continue;
                                    this.handleDependency(vp.getEventID());
                                }
                            }
                            if ((heapDependencyID = GraphicsMenuFactory.this.trace.getHeapDependency(eventID)) >= 0 && !this.visited.contains(heapDependencyID)) {
                                this.handleDependency(heapDependencyID);
                            }
                            if ((objectDependencies = GraphicsMenuFactory.this.trace.getUnrecordedInvocationDependencyIDs(eventID)) == null) continue;
                            int i = 0;
                            while (i < objectDependencies.size()) {
                                this.handleDependency(objectDependencies.get(i));
                                ++i;
                            }
                        }
                        TIntHashSet temp = this.newDependencies;
                        this.dependencies.clear();
                        this.newDependencies = this.dependencies;
                        this.dependencies = temp;
                    }
                }
                ++arg;
            }
        }

        public void handleDependency(int eventID) {
            FieldInfo field;
            if (this.visited.contains(eventID)) {
                return;
            }
            this.visited.add(eventID);
            Instruction inst = GraphicsMenuFactory.this.trace.getInstruction(eventID);
            if (inst instanceof GETFIELD && (field = GraphicsMenuFactory.this.trace.resolveFieldReference(((FieldrefContainer)((Object)inst)).getFieldref())) != null) {
                boolean isPublic;
                boolean referenced = GraphicsMenuFactory.this.trace.classIsReferencedInFamiliarSourceFile(inst.getClassfile().getInternalName());
                boolean bl = isPublic = field.isPublic() || !field.getSetters().isEmpty();
                if (referenced && isPublic) {
                    long objectID = GraphicsMenuFactory.this.trace.getOperandStackValue(eventID, 0).getLong();
                    int existingUse = -1;
                    int i = 0;
                    while (i < this.fieldUses.size()) {
                        FieldUse use = this.fieldUses.get(i);
                        if (use.objectID == objectID && use.field == field) {
                            existingUse = i;
                            break;
                        }
                        ++i;
                    }
                    FieldUse use = new FieldUse(eventID, objectID, field);
                    if (existingUse >= 0) {
                        if (this.fieldUses.get((int)existingUse).useID < eventID) {
                            this.fieldUses.set(existingUse, use);
                        }
                    } else {
                        this.fieldUses.add(use);
                    }
                }
            }
            this.newDependencies.add(eventID);
        }
    }

    private static class EntityRender {
        final long entityID;
        GraphicalEventAppearance event;
        int distance;

        public EntityRender(long entityID, GraphicalEventAppearance event, int distance) {
            this.entityID = entityID;
            this.event = event;
            this.distance = distance;
        }
    }

    private static class FieldUse {
        int useID;
        long objectID;
        FieldInfo field;

        public FieldUse(int useID, long objectID, FieldInfo field) {
            this.useID = useID;
            this.objectID = objectID;
            this.field = field;
        }
    }
}

