/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.TraceValue;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Explanation
implements Comparable<Explanation> {
    protected final Answer answer;
    protected final int eventID;
    protected ExplanationBlock owner;
    private boolean isExplaining = false;
    private boolean isExplained = false;
    protected Explanation[] causes;
    private Map<Explanation, Instruction> producersByExplanation = new HashMap<Explanation, Instruction>(2);

    protected Explanation(Answer answer, int eventID) {
        this.answer = answer;
        this.eventID = eventID;
        this.owner = answer.getBlockRepresentingControlDependencyOf(this);
        if (this.owner != null) {
            this.owner.addExplanation(this);
        }
    }

    public final Answer getAnswer() {
        return this.answer;
    }

    public final Trace getTrace() {
        return this.answer.getTrace();
    }

    public final int getEventID() {
        return this.eventID;
    }

    public final Instruction getInstruction() {
        return this.answer.getTrace().getInstruction(this.eventID);
    }

    public final boolean isExplained() {
        return this.isExplained;
    }

    public final ExplanationBlock getBlock() {
        return this.owner;
    }

    public final int getBlockDepth() {
        return this.owner == null ? 0 : 1 + this.owner.getBlockDepth();
    }

    public MethodInfo getMethod() {
        int startID = this.getTrace().getStartID(this.getEventID());
        if (startID >= 0) {
            return this.getTrace().getInstruction(startID).getMethod();
        }
        return null;
    }

    public final Explanation[] getCauses() {
        this.explain();
        return this.causes;
    }

    public boolean isCauseless() {
        return this.getCauses() == null || this.getCauses().length == 0;
    }

    public final void explain() {
        if (this.isExplained || this.isExplaining) {
            return;
        }
        this.isExplaining = true;
        Trace trace = this.answer.trace;
        if (this.eventID >= 0) {
            IntegerVector objectDependencies;
            Explanation memoryDependency;
            this.answer.getQuestion().getAsker().processing(true);
            ArrayList<Explanation> temporaryCauses = new ArrayList<Explanation>(5);
            for (Value value : trace.getOperandStackDependencies(this.eventID)) {
                Explanation explanation;
                if (value == null || value.getEventID() < 0 || trace.getKind(value.getEventID()) == EventKind.NEW_OBJECT || (explanation = this.answer.getExplanationFor(value.getEventID())) == this) continue;
                temporaryCauses.add(explanation);
                if (explanation == null) continue;
                explanation.explain();
                if (!(value instanceof TraceValue)) continue;
                this.producersByExplanation.put(explanation, ((TraceValue)value).getProducer());
            }
            int heapDependency = trace.getHeapDependency(this.eventID);
            if (heapDependency >= 0 && (memoryDependency = this.answer.getExplanationFor(heapDependency)) != this) {
                temporaryCauses.add(memoryDependency);
            }
            if ((objectDependencies = trace.getUnrecordedInvocationDependencyIDs(this.eventID)) != null) {
                int i = 0;
                while (i < objectDependencies.size()) {
                    int callID = objectDependencies.get(i);
                    Invoke call = (Invoke)trace.getInstruction(callID);
                    int arg = 0;
                    while (arg < call.getNumberOfArgumentProducers()) {
                        Value value = trace.getOperandStackValue(callID, arg);
                        if (value.hasEventID()) {
                            temporaryCauses.add(this.answer.getExplanationFor(value.getEventID()));
                        }
                        ++arg;
                    }
                    ++i;
                }
            }
            this.causes = new Explanation[temporaryCauses.size()];
            temporaryCauses.toArray(this.causes);
            this.answer.getQuestion().getAsker().processing(false);
        } else {
            this.causes = new Explanation[0];
        }
        this.isExplaining = false;
        this.isExplained = true;
    }

    public final boolean needsToBeExplained() {
        if (this.isExplained) {
            return false;
        }
        List<Value> sd = this.answer.trace.getOperandStackDependencies(this.eventID);
        int md = this.answer.trace.getHeapDependency(this.eventID);
        if (md >= 0 && !this.answer.hasExplanationFor(md)) {
            return true;
        }
        for (Value vp : sd) {
            int vpID;
            if (vp == null || (vpID = vp.getEventID()) < 0 || vpID == this.eventID || !this.answer.getExplanationFor(vpID).needsToBeExplained()) continue;
            return true;
        }
        return false;
    }

    public boolean isTerminalDataDependency() {
        EventKind kind = this.getTrace().getKind(this.getEventID());
        return kind.isDefinition || kind.isArgument || kind.isInvocation || kind == EventKind.RETURN || kind.isInstantiation;
    }

    public Instruction getProducerFor(Explanation e) {
        return this.producersByExplanation.get(e);
    }

    @Override
    public int compareTo(Explanation ee) {
        return this.eventID - ee.eventID;
    }

    public String toString() {
        return "explanation" + System.identityHashCode(this) + "(" + this.getTrace().eventToString(this.getEventID()) + ")";
    }
}

