/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import gnu.trove.TLongHashSet;

public class ExpectedObject {
    private final TLongHashSet objectIDs;
    private final long objectID;
    private final int expectedArgument;

    public ExpectedObject(long objectID) {
        this.objectID = objectID;
        this.objectIDs = null;
        this.expectedArgument = -1;
    }

    public ExpectedObject(long objectID, int arg) {
        this.objectID = objectID;
        this.objectIDs = null;
        this.expectedArgument = arg;
    }

    public ExpectedObject(TLongHashSet objectIDs) {
        this.objectID = -1L;
        this.expectedArgument = -1;
        this.objectIDs = objectIDs;
    }

    public long getExpectedObjectID() {
        return this.objectID;
    }

    public boolean expectsObjectID(long id) {
        return this.objectIDs.contains(id);
    }

    public int getExpectedArgument() {
        return this.expectedArgument;
    }

    public boolean expectsSpecificArgument() {
        return this.expectedArgument >= 0;
    }

    public boolean expectsSpecificObjectID() {
        return this.objectID >= 0L;
    }

    public boolean expectsOneOfManyObjectIDs() {
        return this.objectIDs != null;
    }

    public String toString() {
        return "expects id = " + this.objectID + " in " + (this.expectsSpecificArgument() ? "arg " + this.expectedArgument : " any arg ") + " of instruction.";
    }
}

