/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.io.CreateGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.io.GetGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.GraphicalOutputEvent;
import edu.cmu.hcii.whyline.io.IOHistory;
import edu.cmu.hcii.whyline.io.WindowState;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class WindowParser {
    private final Trace trace;
    private boolean parsed = false;
    private Thread parser = null;
    private TLongObjectHashMap<WindowState> windowsByWindowID = new TLongObjectHashMap(3);
    private TLongObjectHashMap<WindowState> windowsByGraphicsID = new TLongObjectHashMap(10000);
    private TLongLongHashMap imageIDsByImageContextIDs = new TLongLongHashMap(1000);
    private TLongObjectHashMap<List<GraphicalOutputEvent>> unclaimedImageOutputEventsByImageID = new TLongObjectHashMap(50);
    private int lastEventIDParsed = -1;

    public WindowParser(Trace trace) {
        this.trace = trace;
    }

    public int getLastEventIDParsed() {
        return this.lastEventIDParsed;
    }

    private void addUnclaimedImageEvent(long imageID, GraphicalOutputEvent event) {
        List<GraphicalOutputEvent> imageEvents = this.unclaimedImageOutputEventsByImageID.get(imageID);
        if (imageEvents == null) {
            imageEvents = new ArrayList<GraphicalOutputEvent>(20);
            this.unclaimedImageOutputEventsByImageID.put(imageID, imageEvents);
        }
        imageEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Util.ProgressListener progressListener) {
        int repaint = 0;
        IOHistory<GraphicalOutputEvent> output = this.trace.getGraphicsHistory();
        int count = output.getNumberOfEvents();
        int i = 0;
        while (i < count) {
            long imageID;
            GraphicalOutputEvent event = output.getEventAtIndex(i);
            if (event instanceof GetGraphicsOutputEvent) {
                GetGraphicsOutputEvent getGraphics = (GetGraphicsOutputEvent)event;
                long objectID = getGraphics.getObjectID();
                if (getGraphics.representsWindow()) {
                    long windowID = getGraphics.getObjectID();
                    WindowState window = this.windowsByWindowID.get(windowID);
                    if (window == null) {
                        window = new WindowState(this, (GetGraphicsOutputEvent)event);
                        this.windowsByWindowID.put(windowID, window);
                        this.trace.addWindow(window);
                    } else {
                        WindowState windowState = window;
                        synchronized (windowState) {
                            window.addRepaint((GetGraphicsOutputEvent)event);
                        }
                        if (++repaint == 24) {
                            repaint = 0;
                            progressListener.notice("Parsing I/O events (" + Util.commas(count - i) + " remaining)");
                            progressListener.progress((double)i / (double)count);
                        }
                    }
                    long graphicsID = ((GetGraphicsOutputEvent)event).getGraphicsID();
                    this.windowsByGraphicsID.put(graphicsID, window);
                } else {
                    imageID = getGraphics.getObjectID();
                    this.imageIDsByImageContextIDs.put(getGraphics.getGraphicsID(), imageID);
                    this.addUnclaimedImageEvent(imageID, getGraphics);
                }
            } else if (event instanceof CreateGraphicsOutputEvent) {
                long sourceID = ((CreateGraphicsOutputEvent)event).getSourceID();
                long copyID = ((CreateGraphicsOutputEvent)event).getCopyID();
                WindowState windowForCopy = this.windowsByGraphicsID.get(sourceID);
                if (windowForCopy != null) {
                    this.windowsByGraphicsID.put(copyID, windowForCopy);
                    windowForCopy.addEvent(event);
                } else if (this.imageIDsByImageContextIDs.containsKey(sourceID)) {
                    long imageID2 = this.imageIDsByImageContextIDs.get(sourceID);
                    this.imageIDsByImageContextIDs.put(copyID, imageID2);
                    this.addUnclaimedImageEvent(imageID2, event);
                } else {
                    Whyline.debug("Couldn't find a window or image for graphics ID " + sourceID + " which was used to create graphics ID " + copyID + " in " + event.getInstruction().getMethod().getQualifiedNameAndDescriptor());
                }
            } else {
                List<GraphicalOutputEvent> unclaimedEvents;
                long graphicsID = event.getGraphicsID();
                WindowState window = this.windowsByGraphicsID.get(graphicsID);
                if (window != null) {
                    window.addEvent(event);
                } else if (this.imageIDsByImageContextIDs.containsKey(graphicsID)) {
                    imageID = this.imageIDsByImageContextIDs.get(graphicsID);
                    this.addUnclaimedImageEvent(imageID, event);
                } else {
                    Whyline.debug("Couldn't find a window or image to claim " + event + " with graphicsID " + graphicsID);
                }
                if (event instanceof DrawImageEvent && (unclaimedEvents = this.unclaimedImageOutputEventsByImageID.get(imageID = ((DrawImageEvent)event).getImageID())) != null) {
                    if (window != null) {
                        for (GraphicalOutputEvent goe : unclaimedEvents) {
                            window.addEvent(goe);
                        }
                        this.unclaimedImageOutputEventsByImageID.remove(imageID);
                    } else if (this.imageIDsByImageContextIDs.containsKey(graphicsID)) {
                        long subImageID = this.imageIDsByImageContextIDs.get(graphicsID);
                        for (GraphicalOutputEvent goe : unclaimedEvents) {
                            this.addUnclaimedImageEvent(subImageID, goe);
                        }
                        this.unclaimedImageOutputEventsByImageID.remove(imageID);
                    } else {
                        Whyline.debug("Couldn't find a window to draw these unclaimed image output events onto: " + unclaimedEvents);
                    }
                }
            }
            this.lastEventIDParsed = event.getEventID();
            ++i;
        }
        this.parser = null;
        this.parsed = true;
    }
}

