/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.Duplication;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.io.TextualOutputEvent;
import edu.cmu.hcii.whyline.trace.ExecutionEventParser;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.tracing.ClassIDs;

public class TextualOutputParser
extends ExecutionEventParser {
    public TextualOutputParser(Trace trace) {
        super(trace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean handles(ClassIDs classIDs, Instruction output) {
        StackDependencies.Consumers consumers = output.getConsumers();
        if (consumers.getNumberOfConsumers() == 0) {
            return false;
        }
        Instruction consumer = consumers.getFirstConsumer();
        if (!(consumer instanceof Invoke)) {
            return false;
        }
        Invoke invocation = (Invoke)consumer;
        MethodrefInfo methodInvoked = invocation.getMethodInvoked();
        QualifiedClassName classInvokedOn = methodInvoked.getClassName();
        if (!classIDs.isOrIsSubclassOfTextualOutputProducer(classInvokedOn)) {
            return false;
        }
        StackDependencies.Producers producers = invocation.getInstanceProducers();
        int i = 0;
        while (i < producers.getNumberOfProducers()) {
            if (producers.getProducer(i) == output) {
                return false;
            }
            ++i;
        }
        if (methodInvoked.matchesClassAndName(QualifiedClassName.STRING_BUILDER, "<init>")) {
            if (!(invocation.getInstanceProducers().getFirstProducer() instanceof Duplication)) return false;
            Duplication dup = (Duplication)invocation.getInstanceProducers().getFirstProducer();
            consumer = dup.getProducersOfArgument(0).getFirstProducer();
        } else {
            consumer = output;
        }
        while (consumer != null) {
            StackDependencies.Consumers consumersConsumers;
            MethodrefInfo method;
            MethodrefInfo methodrefInfo = method = consumer instanceof Invoke ? ((Invoke)consumer).getMethodInvoked() : null;
            if (method != null) {
                if (classIDs.isOrIsSubclassOf(method.getClassName(), QualifiedClassName.WRITER)) {
                    if (method.getMethodName().equals("write")) return true;
                    if (method.getMethodName().equals("append")) return true;
                    if (method.getMethodName().startsWith("print")) {
                        return true;
                    }
                }
                if (classIDs.isOrIsSubclassOf(method.getClassName(), QualifiedClassName.PRINT_STREAM) && method.getMethodName().startsWith("print")) {
                    return true;
                }
            }
            if ((consumersConsumers = consumer.getConsumers()).getNumberOfConsumers() <= 0) return false;
            Instruction instruction = consumersConsumers.getFirstConsumer();
            consumer = instruction;
        }
        return false;
    }

    public boolean handle(int eventID) {
        if (!this.trace.getKind((int)eventID).isValueProduced) {
            return false;
        }
        if (!TextualOutputParser.handles(this.trace.getClassIDs(), this.trace.getInstruction(eventID))) {
            return false;
        }
        this.trace.getPrintHistory().add(new TextualOutputEvent(this.trace, eventID));
        return true;
    }
}

