/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.trace.ImageData;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public final class DrawImageWithLocationAndObserverEvent
extends DrawImageEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "image", "x", "y", "observer"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawImageWithLocationAndObserverEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paintWithImage(Graphics2D g, Image image) {
        if (image == null) {
            ImageData data = this.getTrace().getImageData(this.getImageID());
            if (data != null) {
                this.drawPlaceholder(g, "image " + this.getImageID(), this.getX(), this.getY(), data.getWidth(this.eventID), data.getHeight(this.eventID), null);
            }
        } else {
            g.drawImage(image, this.getX(), this.getY(), null);
        }
    }

    protected Shape makeShape() {
        Image image = this.getGraphicsState().getWindowState().getImage(this.getImageID());
        ImageData data = this.getTrace().getImageData(this.getImageID());
        int width = data == null ? 25 : data.getWidth(this.eventID);
        int height = data == null ? 25 : data.getHeight(this.eventID);
        return new Rectangle(this.paintState.getOriginX() + this.getX(), this.paintState.getOriginY() + this.getY(), width, height);
    }

    public void transformContextToDrawPrimitive(Graphics2D g) {
        g.translate(this.paintState.getOriginX() + this.getX(), this.paintState.getOriginY() + this.getY());
    }

    public int getWindowX() {
        return this.paintState.getOriginX() + this.getX();
    }

    public int getWindowY() {
        return this.paintState.getOriginY() + this.getY();
    }

    public int getX() {
        return this.getInteger(2);
    }

    public int getY() {
        return this.getInteger(3);
    }

    public long getObserver() {
        return this.getLong(4);
    }

    public String getHumanReadableName() {
        return "image";
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\tdrawImageWithLocationAndObserver " + this.getImage() + " " + this.getX() + " " + this.getY();
    }
}

