/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.UI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;

public abstract class DrawImageEvent
extends RenderEvent {
    private Image buffer;

    public DrawImageEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        this.paintWithImage(g, this.getImage());
    }

    public abstract void paintWithImage(Graphics2D var1, Image var2);

    protected void drawPlaceholder(Graphics2D g, String label, int x, int y, int width, int height, Color color) {
        g = (Graphics2D)g.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color lineBorderColor = UI.getControlFrontColor();
        g.clipRect(x, y, width + 1, height + 1);
        g.setColor(color == null ? UI.getControlCenterColor() : color);
        g.fillRect(x, y, width, height);
        g.setColor(Color.gray);
        int bottom = y + height;
        int max = x + width;
        int inc = UI.getCrosshatchSpacing();
        int left = x - width;
        while (left < max) {
            g.drawLine(left, bottom, left + height, y);
            left += inc;
        }
        g.setColor(lineBorderColor);
        g.drawRect(x, y, width, height);
    }

    public void paintByMemory() {
        Image image = this.buffer == null ? this.getImage() : this.buffer;
        this.paintWithImage(this.paintState.getGraphics(), image);
    }

    public void rememberOffscreenBuffer(Image image) {
        this.buffer = image;
    }

    public abstract int getWindowX();

    public abstract int getWindowY();

    public abstract void transformContextToDrawPrimitive(Graphics2D var1);

    public final boolean canOcclude() {
        return true;
    }

    public long getImageID() {
        return this.getLong(1);
    }

    public Image getImage() {
        try {
            return (Image)this.trace.getOperandStackValue(this.eventID, 1).getImmutable();
        }
        catch (NoValueException e) {
            return null;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "gID=" + this.getGraphicsID() + " imageID=" + this.getImageID();
    }
}

