/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public final class CopyAreaEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "x", "y", "width", "height", "dx", "dy"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public CopyAreaEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        g.copyArea(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getDX(), this.getDY());
    }

    protected Shape makeShape() {
        return new Rectangle(this.getX() + this.paintState.getOriginX() + this.getDX(), this.getY() + this.paintState.getOriginY() + this.getDY(), this.getWidth(), this.getHeight());
    }

    public int getX() {
        return this.getInteger(1);
    }

    public int getY() {
        return this.getInteger(2);
    }

    public int getWidth() {
        return this.getInteger(3);
    }

    public int getHeight() {
        return this.getInteger(4);
    }

    public int getDX() {
        return this.getInteger(5);
    }

    public int getDY() {
        return this.getInteger(6);
    }

    public boolean canOcclude() {
        return true;
    }

    public String getHumanReadableName() {
        return "copied area";
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tcopyArea " + this.getX() + " " + this.getY() + " " + this.getWidth() + " " + this.getHeight() + " " + this.getDX() + " " + this.getDY();
    }
}

