/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.TableBranch;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TABLESWITCH
extends TableBranch {
    private int def;
    private int low;
    private int high;
    private List<Integer> offsets;
    private Instruction defaultTarget;
    private List<Instruction> targets;

    public TABLESWITCH(CodeAttribute method, int def, int low, int high, List<Integer> offsets) {
        super(method);
        this.def = def;
        this.low = low;
        this.high = high;
        this.offsets = offsets;
    }

    @Override
    public final int getOpcode() {
        return 170;
    }

    @Override
    public int getNumberOfOperandsConsumed() {
        return 1;
    }

    @Override
    public int getNumberOfOperandsProduced() {
        return 0;
    }

    @Override
    public int getNumberOfOperandsPeekedAt() {
        return 0;
    }

    @Override
    public int byteLength() {
        return 1 + this.numberOfPaddedBytes() + 4 + 4 + 4 + (this.high - this.low + 1) * 4;
    }

    @Override
    public void toBytes(DataOutputStream code) throws IOException {
        code.write(this.getOpcode());
        int numberOfZeroedBytesToWrite = this.numberOfPaddedBytes();
        int i = 0;
        while (i < numberOfZeroedBytesToWrite) {
            code.writeByte(0);
            ++i;
        }
        code.writeInt(this.defaultTarget.getByteIndex() - this.getByteIndex());
        code.writeInt(this.low);
        code.writeInt(this.high);
        for (Instruction i2 : this.targets) {
            code.writeInt(i2.getByteIndex() - this.getByteIndex());
        }
    }

    @Override
    public SortedSet<Instruction> createSuccessorsCache() {
        TreeSet<Instruction> successors = new TreeSet<Instruction>();
        successors.addAll(this.targets);
        successors.add(this.defaultTarget);
        return successors;
    }

    @Override
    public void resolveTargets(Instruction[] instructionsByByteIndex) throws AnalysisException {
        this.defaultTarget = instructionsByByteIndex[this.getByteIndex() + this.def];
        this.code.addIncomingBranchToInstruction(this, this.defaultTarget);
        this.targets = new Vector<Instruction>();
        for (Integer offset : this.offsets) {
            Instruction target = instructionsByByteIndex[this.getByteIndex() + offset];
            this.code.addIncomingBranchToInstruction(this, target);
            this.targets.add(target);
        }
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        if (oldTarget == this.defaultTarget) {
            this.defaultTarget = newTarget;
        }
        int i = 0;
        while (i < this.targets.size()) {
            if (this.targets.get(i) == oldTarget) {
                this.targets.set(i, newTarget);
            }
            ++i;
        }
    }

    private int numberOfPaddedBytes() {
        int bytesOff = (this.getByteIndex() + 1) % 4;
        return bytesOff == 0 ? 0 : 4 - bytesOff;
    }

    @Override
    public Iterable<Instruction> getNonDefaultTargets() {
        return this.targets;
    }

    @Override
    public Instruction getTarget() {
        return this.defaultTarget;
    }

    @Override
    public int getNumberOfNonDefaultTargets() {
        return this.targets.size();
    }

    @Override
    public EventKind getTypeProduced() {
        return null;
    }

    @Override
    public String toString() {
        String prefix = super.toString();
        String postfix = "low = " + this.low + ", high = " + this.high + ": default => " + this.defaultTarget.getIndex() + ", ";
        int i = 0;
        while (i < this.offsets.size()) {
            postfix = String.valueOf(postfix) + i + " => " + this.targets.get(i).getIndex() + ", ";
            ++i;
        }
        return String.valueOf(prefix) + postfix;
    }

    @Override
    public String getReadableDescription() {
        return "switch";
    }

    @Override
    public String getKeyword() {
        return "switch";
    }
}

