/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StringInfo
extends ConstantPoolInfo {
    public static final int tag = 8;
    private int stringIndex;
    private UTF8Info string;

    public StringInfo(ConstantPool pool, DataInputStream in) throws IOException {
        super(pool);
        this.stringIndex = in.readUnsignedShort();
    }

    public StringInfo(ConstantPool pool, UTF8Info string) {
        super(pool);
        this.stringIndex = -1;
        this.string = string;
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeByte(8);
        bytes.writeShort(this.string.getIndexInConstantPool());
    }

    public void resolveDependencies() {
        if (this.stringIndex >= 0) {
            this.string = (UTF8Info)this.pool.get(this.stringIndex);
        }
    }

    public String getString() {
        return this.string.toString();
    }

    public String toString() {
        return "\"" + this.getString() + "\"";
    }
}

