/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Dup2lication;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.TableBranch;
import edu.cmu.hcii.whyline.trace.EventKind;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;

public class StackDependencies {
    private final CodeAttribute code;
    private final TIntObjectHashMap<InstructionProducers> producersByInstructionIndex;
    private final TIntObjectHashMap<Instruction> consumersByInstructionIndex;
    private TIntObjectHashMap<Instruction> additionalConsumers;
    private boolean analyzed = false;

    public StackDependencies(CodeAttribute code) throws AnalysisException {
        this.code = code;
        this.producersByInstructionIndex = new TIntObjectHashMap((int)((double)code.getNumberOfInstructions() * 0.48));
        this.consumersByInstructionIndex = new TIntObjectHashMap((int)((double)code.getNumberOfInstructions() * 0.68));
    }

    public Consumers getConsumersOf(Instruction inst) {
        int index = inst.getIndex();
        return new Consumers(this.consumersByInstructionIndex.get(index), this.additionalConsumers == null ? null : this.additionalConsumers.get(index));
    }

    public Producers getProducersOfArgument(Instruction inst, int argument) {
        InstructionProducers producers = this.producersByInstructionIndex.get(inst.getIndex());
        if (producers == null) {
            return new Producers();
        }
        return producers.getArgumentProducers(argument);
    }

    private void addArgumentProducer(Instruction inst, int argument, int producerIndex) {
        boolean wasNew;
        Instruction producer = this.code.getInstruction(producerIndex);
        InstructionProducers argumentProducers = this.producersByInstructionIndex.get(inst.getIndex());
        if (argumentProducers == null) {
            argumentProducers = new InstructionProducers(inst);
            this.producersByInstructionIndex.put(inst.getIndex(), argumentProducers);
        }
        if (!(wasNew = argumentProducers.add(argument, producer))) {
            return;
        }
        if (producer != null && inst.getNumberOfOperandsConsumed() > 0) {
            this.addConsumer(producerIndex, inst);
        }
    }

    private void addConsumer(int producerIndex, Instruction consumer) {
        if (!this.consumersByInstructionIndex.containsKey(producerIndex)) {
            this.consumersByInstructionIndex.put(producerIndex, consumer);
        } else {
            Instruction existingConsumer = this.consumersByInstructionIndex.get(producerIndex);
            if (existingConsumer != consumer) {
                if (this.additionalConsumers == null) {
                    this.additionalConsumers = new TIntObjectHashMap(1);
                }
                assert (!this.additionalConsumers.containsKey(producerIndex)) : "No java bytecodes have more than two consumers, because none produce more than two values, and yet we're adding a third consumer for the value produced by instruction " + producerIndex;
                this.additionalConsumers.put(producerIndex, consumer);
            }
        }
    }

    public void analyze() throws AnalysisException {
        if (this.analyzed) {
            return;
        }
        this.analyzeOperandProductionAndConsumption();
        this.analyzed = true;
    }

    private void analyzeOperandProductionAndConsumption() throws AnalysisException {
        TIntArrayList unconsumedinstructions = new TIntArrayList(10);
        BranchStack branchTargets = new BranchStack();
        TIntHashSet exceptionHandlerIndices = new TIntHashSet(3);
        unconsumedinstructions.add(-1);
        for (ExceptionHandler exceptionHandler : this.code.getExceptionTable()) {
            Instruction handler = exceptionHandler.getHandlerPC();
            if (handler == null) {
                throw new AnalysisException("This entry in the exception table doesn't point to a valid handler instruction.");
            }
            branchTargets.push(handler, 1, unconsumedinstructions);
            exceptionHandlerIndices.add(handler.getIndex());
        }
        unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
        int currentStackDepth = 0;
        int maxStackDepth = 0;
        Instruction instruction = this.code.getFirstInstruction();
        while (instruction != null) {
            int instructionIndex = instruction.getIndex();
            int opcode = instruction.getOpcode();
            int operandsProduced = instruction.getNumberOfOperandsProduced();
            int operandsConsumed = instruction.getNumberOfOperandsConsumed();
            assert (operandsProduced <= 2) : "I thought that bytecode instructions only produced 0, 1, or 2 operands, but it's apparently not true. " + instruction + " produces " + operandsProduced;
            if (operandsConsumed > 0 && operandsConsumed != -1 && !exceptionHandlerIndices.contains(instructionIndex)) {
                int operandsLeftToConsume = operandsConsumed;
                int argumentNumber = operandsLeftToConsume - 1;
                while (operandsLeftToConsume > 0) {
                    if (unconsumedinstructions.isEmpty()) {
                        throw new AnalysisException(instruction + " still needs " + operandsLeftToConsume + ", but the stack of producers is empty.\n" + this.code.toString());
                    }
                    int producerIndex = unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                    --operandsLeftToConsume;
                    this.addArgumentProducer(instruction, argumentNumber, producerIndex);
                    --argumentNumber;
                }
            }
            block0 : switch (opcode) {
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    int indexOfInstructionWithUnconsumedOperand = unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1);
                    Instruction instructionWithUnconsumedOperand = this.code.getInstruction(indexOfInstructionWithUnconsumedOperand);
                    if (instructionWithUnconsumedOperand == null) break;
                    EventKind typeProducedByTopOfStack = instructionWithUnconsumedOperand.getTypeProduced();
                    if (instructionWithUnconsumedOperand instanceof Dup2lication && instructionWithUnconsumedOperand.getConsumers().getNumberOfConsumers() > 0) {
                        typeProducedByTopOfStack = ((Dup2lication)instructionWithUnconsumedOperand).getSecondTypeProduced();
                    }
                    switch (opcode) {
                        case 89: {
                            this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                            unconsumedinstructions.add(instructionIndex);
                            break block0;
                        }
                        case 90: {
                            this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 2, instructionIndex);
                            break block0;
                        }
                        case 91: {
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                                unconsumedinstructions.insert(unconsumedinstructions.size() - 2, instructionIndex);
                                break block0;
                            }
                            this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                            break block0;
                        }
                        case 92: {
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                                unconsumedinstructions.add(instructionIndex);
                                break block0;
                            }
                            this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                            this.addArgumentProducer(instruction, 1, indexOfInstructionWithUnconsumedOperand);
                            unconsumedinstructions.add(instructionIndex);
                            unconsumedinstructions.add(instructionIndex);
                            break block0;
                        }
                        case 93: {
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                                unconsumedinstructions.insert(unconsumedinstructions.size() - 2, instructionIndex);
                                break block0;
                            }
                            this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                            this.addArgumentProducer(instruction, 1, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1));
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                            break block0;
                        }
                        case 94: {
                            EventKind typeProducedOfThirdFromTop;
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                EventKind typeProducedOfSecondFromTop;
                                Instruction secondFromTop = this.code.getInstruction(unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                                EventKind eventKind = typeProducedOfSecondFromTop = secondFromTop instanceof Dup2lication && secondFromTop.getConsumers().getNumberOfConsumers() > 0 ? ((Dup2lication)secondFromTop).getSecondTypeProduced() : secondFromTop.getTypeProduced();
                                if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                    this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                                    unconsumedinstructions.insert(unconsumedinstructions.size() - 2, instructionIndex);
                                    break block0;
                                }
                                this.addArgumentProducer(instruction, 0, indexOfInstructionWithUnconsumedOperand);
                                unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                                break block0;
                            }
                            Instruction thirdFromTop = this.code.getInstruction(unconsumedinstructions.getQuick(unconsumedinstructions.size() - 3));
                            EventKind eventKind = typeProducedOfThirdFromTop = thirdFromTop instanceof Dup2lication && thirdFromTop.getConsumers().getNumberOfConsumers() > 0 ? ((Dup2lication)thirdFromTop).getSecondTypeProduced() : thirdFromTop.getTypeProduced();
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                                this.addArgumentProducer(instruction, 1, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1));
                                unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                                unconsumedinstructions.insert(unconsumedinstructions.size() - 3, instructionIndex);
                                break block0;
                            }
                            this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                            this.addArgumentProducer(instruction, 1, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1));
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 4, instructionIndex);
                            unconsumedinstructions.insert(unconsumedinstructions.size() - 4, instructionIndex);
                            break block0;
                        }
                        case 95: {
                            this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 2));
                            this.addArgumentProducer(instruction, 1, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1));
                            int top = unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                            int below = unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                            unconsumedinstructions.add(top);
                            unconsumedinstructions.add(below);
                            break block0;
                        }
                        case 87: {
                            unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                            break block0;
                        }
                        case 88: {
                            if (typeProducedByTopOfStack.isDoubleOrLong()) {
                                unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                                break block0;
                            }
                            unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                            unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                            break block0;
                        }
                    }
                    assert (false) : "Did I miss " + instruction.getClass() + " when doing stack depth analysis?";
                    break;
                }
                case 192: {
                    this.addArgumentProducer(instruction, 0, unconsumedinstructions.getQuick(unconsumedinstructions.size() - 1));
                    break;
                }
                default: {
                    if (operandsProduced <= 0) break;
                    unconsumedinstructions.add(instructionIndex);
                }
            }
            if ((currentStackDepth += operandsProduced - operandsConsumed) > maxStackDepth) {
                maxStackDepth = currentStackDepth;
            }
            if (instruction instanceof Branch) {
                Branch branch = (Branch)instruction;
                boolean jsr = false;
                switch (opcode) {
                    case 170: 
                    case 171: {
                        TableBranch select = (TableBranch)instruction;
                        for (Instruction target : select.getNonDefaultTargets()) {
                            branchTargets.push(target, currentStackDepth, unconsumedinstructions);
                        }
                        instruction = null;
                        break;
                    }
                    case 167: 
                    case 200: {
                        instruction = null;
                        break;
                    }
                    case 168: 
                    case 201: {
                        jsr = true;
                    }
                }
                branchTargets.push(branch.getTarget(), currentStackDepth, unconsumedinstructions);
                if (jsr) {
                    unconsumedinstructions.remove(unconsumedinstructions.size() - 1);
                    branchTargets.push(branch.getNext(), currentStackDepth - 1, unconsumedinstructions);
                    instruction = null;
                }
            } else {
                switch (opcode) {
                    case 169: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 191: {
                        instruction = null;
                    }
                }
            }
            if (instruction == null) {
                BranchTarget nextTargetToExplore = branchTargets.pop();
                if (nextTargetToExplore == null) continue;
                instruction = nextTargetToExplore.target;
                currentStackDepth = nextTargetToExplore.stackDepthBeforeReachingTarget;
                unconsumedinstructions = new TIntArrayList(nextTargetToExplore.indicesOfUnconsumedInstructions.toNativeArray());
                continue;
            }
            instruction = instruction.getNext();
        }
    }

    static final class BranchStack {
        ArrayList<BranchTarget> branchTargets = new ArrayList(3);
        TIntObjectHashMap<BranchTarget> visitedTargets = new TIntObjectHashMap(10);

        BranchStack() {
        }

        public void push(Instruction target, int stackDepth, TIntArrayList instructionsWithUnconsumedOperands) {
            TIntArrayList alreadyVisitedStack;
            BranchTarget alreadyVisitedTarget = this.visitedTargets.get(target.getIndex());
            if (alreadyVisitedTarget != null && (alreadyVisitedStack = alreadyVisitedTarget.indicesOfUnconsumedInstructions).size() == instructionsWithUnconsumedOperands.size()) {
                boolean equal = true;
                int i = 0;
                while (i < alreadyVisitedStack.size()) {
                    if (alreadyVisitedStack.getQuick(i) != instructionsWithUnconsumedOperands.getQuick(i)) {
                        equal = false;
                        break;
                    }
                    ++i;
                }
                if (equal) {
                    return;
                }
            }
            this.branchTargets.add(this.visit(target, stackDepth, instructionsWithUnconsumedOperands));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.isEmpty()) {
                BranchTarget bt = this.branchTargets.remove(this.branchTargets.size() - 1);
                return bt;
            }
            return null;
        }

        private final BranchTarget visit(Instruction target, int stackDepth, TIntArrayList instructionsWithUnconsumedOperands) {
            BranchTarget bt = new BranchTarget(target, stackDepth, instructionsWithUnconsumedOperands);
            this.visitedTargets.put(target.getIndex(), bt);
            return bt;
        }
    }

    private static final class BranchTarget {
        private final Instruction target;
        private final int stackDepthBeforeReachingTarget;
        private final TIntArrayList indicesOfUnconsumedInstructions;

        public BranchTarget(Instruction target, int stackDepth, TIntArrayList instructionsWithUnconsumedOperands) {
            this.target = target;
            this.stackDepthBeforeReachingTarget = stackDepth;
            this.indicesOfUnconsumedInstructions = new TIntArrayList(instructionsWithUnconsumedOperands.toNativeArray());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Consumers
    implements Iterable<Instruction> {
        private final Instruction first;
        private final Instruction second;

        public Consumers(Instruction first, Instruction second) {
            this.first = first;
            this.second = second;
            if (first != null) assert (first != second) : "Passed two consumers, but they're both " + first;
        }

        public int getNumberOfConsumers() {
            return (this.first != null ? 1 : 0) + (this.second != null ? 1 : 0);
        }

        public Instruction getFirstConsumer() {
            return this.first;
        }

        public Instruction getSecondConsumer() {
            return this.second;
        }

        @Override
        public Iterator<Instruction> iterator() {
            return new Iterator<Instruction>(){
                boolean onFirst = true;

                @Override
                public boolean hasNext() {
                    return this.onFirst && Consumers.this.first != null || Consumers.this.second != null;
                }

                @Override
                public Instruction next() {
                    if (this.onFirst) {
                        this.onFirst = false;
                        return Consumers.this.first;
                    }
                    return Consumers.this.second;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Can't remove a consumer from an instruction.");
                }
            };
        }

        public boolean contains(Instruction instruction) {
            return this.first == instruction || this.second == instruction;
        }
    }

    private static class InstructionProducers {
        private final Producers[] argumentProducers;

        public InstructionProducers(Instruction inst) {
            this.argumentProducers = new Producers[Math.max(inst.getNumberOfOperandsConsumed(), inst.getNumberOfOperandsPeekedAt())];
        }

        public Producers getArgumentProducers(int argument) {
            Producers producers = this.argumentProducers[argument];
            if (producers == null) {
                return new Producers();
            }
            return producers;
        }

        public boolean add(int argument, Instruction producer) {
            Producers producers = this.argumentProducers[argument];
            if (producers == null) {
                this.argumentProducers[argument] = producers = new Producers();
            }
            return producers.add(producer);
        }
    }

    public static class Producers {
        private Instruction[] producers;

        public Instruction[] getProducers() {
            return this.producers;
        }

        public boolean add(Instruction producer) {
            Instruction[] newProducers = new Instruction[this.producers == null ? 1 : this.producers.length + 1];
            if (this.producers != null) {
                int i = 0;
                while (i < this.producers.length) {
                    if (this.producers[i] == producer) {
                        return false;
                    }
                    newProducers[i] = this.producers[i];
                    ++i;
                }
            }
            this.producers = newProducers;
            this.producers[newProducers.length - 1] = producer;
            return true;
        }

        public int getNumberOfProducers() {
            return this.producers == null ? 0 : this.producers.length;
        }

        public Instruction getFirstProducer() {
            return this.producers == null ? null : this.producers[0];
        }

        public Instruction getSecondProducer() {
            return this.producers == null ? null : (this.producers.length >= 2 ? this.producers[1] : null);
        }

        public Instruction getProducer(int index) {
            return this.producers[index];
        }

        public boolean includes(Instruction inst) {
            Instruction[] instructionArray = this.producers;
            int n = this.producers.length;
            int n2 = 0;
            while (n2 < n) {
                Instruction producer = instructionArray[n2];
                if (producer == inst) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

