/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SourceFileAttribute
extends Attribute {
    private UTF8Info attributeName;
    private UTF8Info sourceFileNameInfo;
    private String sourceFileName;
    private ConstantPool pool;

    public SourceFileAttribute(UTF8Info name, ConstantPool pool, DataInputStream data, int length) throws IOException {
        this.attributeName = name;
        this.pool = pool;
        this.sourceFileNameInfo = (UTF8Info)pool.get(data.readUnsignedShort());
        this.sourceFileName = this.sourceFileNameInfo.toString();
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeShort(this.attributeName.getIndexInConstantPool());
        bytes.writeInt(2);
        bytes.writeShort(this.sourceFileNameInfo.getIndexInConstantPool());
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public int getTotalAttributeLength() {
        return 8;
    }
}

