/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedClassName
implements Comparable<QualifiedClassName> {
    private final String qualifiedName;
    private String simpleName;
    private boolean familiar = false;
    private final int id;
    private static final Map<String, QualifiedClassName> names = new HashMap<String, QualifiedClassName>(1000);
    private static int nextID = 1;
    public static final QualifiedClassName JAVA_LANG_CLASS = QualifiedClassName.get("java/lang/Class");
    public static final QualifiedClassName JAVA_LANG_OBJECT = QualifiedClassName.get("java/lang/Object");
    public static final QualifiedClassName JAVA_LANG_STRING = QualifiedClassName.get("java/lang/String");
    public static final QualifiedClassName JAVA_LANG_THREAD = QualifiedClassName.get("java/lang/Thread");
    public static final QualifiedClassName JAVA_LANG_RUNNABLE = QualifiedClassName.get("java/lang/Runnable");
    public static final QualifiedClassName NULL = QualifiedClassName.get("null");
    public static final QualifiedClassName JAVA_LANG_THROWABLE = QualifiedClassName.get("java/lang/Throwable");
    public static final QualifiedClassName JAVA_LANG_EXCEPTION = QualifiedClassName.get("java/lang/Exception");
    public static final QualifiedClassName BYTE = QualifiedClassName.get("B");
    public static final QualifiedClassName CHAR = QualifiedClassName.get("C");
    public static final QualifiedClassName DOUBLE = QualifiedClassName.get("D");
    public static final QualifiedClassName FLOAT = QualifiedClassName.get("F");
    public static final QualifiedClassName INT = QualifiedClassName.get("I");
    public static final QualifiedClassName LONG = QualifiedClassName.get("J");
    public static final QualifiedClassName SHORT = QualifiedClassName.get("S");
    public static final QualifiedClassName BOOLEAN = QualifiedClassName.get("Z");
    public static final QualifiedClassName VOID = QualifiedClassName.get("V");
    public static final QualifiedClassName STRING_BUILDER = QualifiedClassName.get("java/lang/StringBuilder");
    public static final QualifiedClassName PRINT_STREAM = QualifiedClassName.get("java/io/PrintStream");
    public static final QualifiedClassName OUTPUT_STREAM = QualifiedClassName.get("java/io/OutputStream");
    public static final QualifiedClassName WRITER = QualifiedClassName.get("java/io/Writer");

    public static QualifiedClassName getFromTypeDescriptor(String typeDescriptor) {
        String arrayPart = "";
        int lastBracketIndex = typeDescriptor.lastIndexOf(91);
        if (lastBracketIndex >= 0) {
            arrayPart = typeDescriptor.substring(0, lastBracketIndex + 1);
            typeDescriptor = typeDescriptor.substring(lastBracketIndex + 1);
        }
        StringBuilder builder = new StringBuilder(arrayPart);
        String rest = "";
        char firstChar = typeDescriptor.charAt(0);
        switch (firstChar) {
            case 'L': {
                rest = typeDescriptor.substring(1, typeDescriptor.length() - 1);
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                rest = Character.toString(firstChar);
                break;
            }
            default: {
                assert (false) : "I must have missed one because I don't know how to handle " + firstChar;
                break;
            }
        }
        builder.append(rest);
        return QualifiedClassName.get(builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QualifiedClassName get(String name) {
        Map<String, QualifiedClassName> map = names;
        synchronized (map) {
            QualifiedClassName cachedName = names.get(name);
            if (cachedName == null && (cachedName = names.get(name = name.replace('.', '/'))) == null) {
                cachedName = new QualifiedClassName(name, nextID++);
                names.put(name, cachedName);
            }
            return cachedName;
        }
    }

    private QualifiedClassName(String name, int id) {
        this.qualifiedName = name;
        this.id = id;
    }

    public String getText() {
        return this.qualifiedName;
    }

    public String getSimpleClassQualifiedName() {
        int lastSlashIndex = this.qualifiedName.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            return this.qualifiedName.substring(lastSlashIndex + 1);
        }
        return this.qualifiedName;
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            if (this.qualifiedName.length() == 1) {
                if (this == BYTE) {
                    return "byte";
                }
                if (this == CHAR) {
                    return "char";
                }
                if (this == DOUBLE) {
                    return "double";
                }
                if (this == FLOAT) {
                    return "float";
                }
                if (this == INT) {
                    return "int";
                }
                if (this == LONG) {
                    return "long";
                }
                if (this == SHORT) {
                    return "short";
                }
                if (this == BOOLEAN) {
                    return "boolean";
                }
                if (this == VOID) {
                    return "void";
                }
            }
            int lastBracket = this.qualifiedName.lastIndexOf(91);
            boolean isAnonymous = this.isAnonymous();
            if (lastBracket >= 0) {
                String brackets = "";
                int i = 0;
                while (i <= lastBracket) {
                    brackets = String.valueOf(brackets) + "[]";
                    ++i;
                }
                String rest = this.qualifiedName.substring(lastBracket + 1);
                this.simpleName = NameAndTypeInfo.getJavafiedPrimitiveTypeDescriptor(rest.charAt(0));
                if (this.simpleName != null) {
                    this.simpleName = String.valueOf(this.simpleName) + brackets;
                } else {
                    String className = rest;
                    int indexOfLast = className.lastIndexOf("/");
                    className = indexOfLast < 0 ? className : className.substring(indexOfLast + 1);
                    this.simpleName = String.valueOf(className) + brackets;
                }
            } else {
                int indexOfLast;
                this.simpleName = isAnonymous ? ((indexOfLast = this.qualifiedName.lastIndexOf(47)) < 0 ? this.qualifiedName : this.qualifiedName.substring(indexOfLast + 1)) : ((indexOfLast = Math.max(this.qualifiedName.lastIndexOf(47), this.qualifiedName.lastIndexOf(36))) < 0 ? this.qualifiedName : this.qualifiedName.substring(indexOfLast + 1, this.qualifiedName.length()));
            }
        }
        return this.simpleName;
    }

    public String getPackageName() {
        int indexOfLastForwardSlash = this.qualifiedName.lastIndexOf(47);
        if (indexOfLastForwardSlash < 0) {
            return "";
        }
        return this.qualifiedName.substring(0, indexOfLastForwardSlash + 1);
    }

    public String getCorrespondingClassfileName() {
        return String.valueOf(this.qualifiedName.replace("/", File.separator)) + ".class";
    }

    public String getNameWithDots() {
        return this.qualifiedName.replace("/", ".");
    }

    public boolean equals(Object classname) {
        return this == classname;
    }

    public boolean isAnonymous() {
        return Character.isDigit(this.qualifiedName.charAt(this.qualifiedName.length() - 1));
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(QualifiedClassName o) {
        return this.qualifiedName.compareTo(o.qualifiedName);
    }

    public boolean isArray() {
        return this.qualifiedName.startsWith("[");
    }

    public boolean isPrimitive() {
        return this == BYTE || this == CHAR || this == DOUBLE || this == FLOAT || this == INT || this == LONG || this == SHORT || this == BOOLEAN;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public void markAsReferencedInFamiliarClass() {
        this.familiar = true;
    }

    public boolean referencedInFamiliarClass() {
        return this.familiar;
    }

    public int getID() {
        return this.id;
    }

    public boolean isInner() {
        return this.qualifiedName.indexOf(36) >= 0;
    }

    public QualifiedClassName getOuterClassName() {
        int lastDollarIndex = this.qualifiedName.lastIndexOf(36);
        if (lastDollarIndex < 0) {
            return null;
        }
        return QualifiedClassName.get(this.qualifiedName.substring(0, lastDollarIndex));
    }

    public QualifiedClassName getArrayElementClassname() {
        int lastBracket = this.qualifiedName.lastIndexOf(91);
        String name = this.qualifiedName.substring(lastBracket + 1);
        return QualifiedClassName.get(name);
    }
}

