/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.MethodDescriptor;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodrefInfo
extends ConstantPoolInfo {
    public static final int tag = 10;
    private int classInfoIndex;
    private int nameAndTypeIndex;
    protected ClassInfo classInfo;
    protected NameAndTypeInfo nameAndTypeInfo;
    private MethodDescriptor descriptor;
    private boolean isStatic = false;
    private String fullName;
    private String methodName;

    public MethodrefInfo(ConstantPool pool, DataInputStream in) throws IOException {
        super(pool);
        this.classInfoIndex = in.readUnsignedShort();
        this.nameAndTypeIndex = in.readUnsignedShort();
    }

    public MethodrefInfo(ConstantPool pool, ClassInfo classInfo, NameAndTypeInfo nameAndType) {
        super(pool);
        this.classInfo = classInfo;
        this.nameAndTypeInfo = nameAndType;
    }

    public void setStatic() {
        this.isStatic = true;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void resolveDependencies() {
        this.classInfo = (ClassInfo)this.pool.get(this.classInfoIndex);
        this.nameAndTypeInfo = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeByte(10);
        bytes.writeShort(this.classInfo.getIndexInConstantPool());
        bytes.writeShort(this.nameAndTypeInfo.getIndexInConstantPool());
    }

    public QualifiedClassName getClassName() {
        return this.classInfo.getName();
    }

    public String getMethodName() {
        if (this.methodName == null) {
            this.methodName = this.nameAndTypeInfo.getName();
        }
        return this.methodName;
    }

    public boolean returnsVoid() {
        String descriptor = this.nameAndTypeInfo.getTypeDescriptor();
        return descriptor.charAt(descriptor.length() - 1) == 'V';
    }

    public String getMethodDescriptor() {
        return this.nameAndTypeInfo.getTypeDescriptor();
    }

    public String getMethodNameAndDescriptor() {
        return this.nameAndTypeInfo.toString();
    }

    public String getQualfiedNameAndDescriptor() {
        if (this.fullName == null) {
            StringBuilder builder = new StringBuilder(this.getClassName().getText());
            builder.append('.');
            builder.append(this.getMethodName());
            builder.append(this.getMethodDescriptor());
            this.fullName = builder.toString().intern();
        }
        return this.fullName;
    }

    public boolean callsInstanceInitializer() {
        return this.getMethodName().equals("<init>");
    }

    public String getShortQualifiedNameAndDescriptor() {
        return String.valueOf(this.getClassName().getSimpleName()) + "." + this.getMethodName() + this.getMethodDescriptor();
    }

    public boolean matchesNameAndDescriptor(String name, String descriptor) {
        return this.nameAndTypeInfo.getName().equals(name) && this.nameAndTypeInfo.getTypeDescriptor().equals(descriptor);
    }

    public boolean matchesClassAndName(QualifiedClassName classname, String methodname) {
        return classname.equals(this.classInfo.getName()) && methodname.equals(this.nameAndTypeInfo.getName());
    }

    public boolean matchesClassNameAndDescriptor(QualifiedClassName classname, String name, String descriptor) {
        return this.getClassName().equals(classname) && this.nameAndTypeInfo.getName().equals(name) && this.nameAndTypeInfo.getTypeDescriptor().equals(descriptor);
    }

    public int getNumberOfParameters() {
        return this.getParsedDescriptor().getNumberOfParameters();
    }

    public QualifiedClassName getReturnType() {
        return this.getParsedDescriptor().getReturnType();
    }

    public MethodDescriptor getParsedDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = MethodDescriptor.get(this.isStatic, this.getMethodDescriptor());
        }
        return this.descriptor;
    }

    public boolean explicitlyReferences(MethodInfo method) {
        return this.getMethodName().equals(method.getInternalName()) && this.getClassName().equals(method.getClassfile().getInternalName()) && this.getMethodDescriptor().equals(method.getDescriptor());
    }

    public String toString() {
        return this.getClassName() + "." + this.getMethodName() + this.getMethodDescriptor();
    }
}

