/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.Cancelable;
import edu.cmu.hcii.whyline.analysis.ValueSource;
import edu.cmu.hcii.whyline.analysis.ValueSourceAnalyzer;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.INVOKEVIRTUAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.tracing.ClassIDs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Invoke
extends Instruction {
    private int numberOfOperandsConsumed = -1;
    protected final MethodrefInfo methodInfo;
    private Set<ValueSource> potentialValuesOfInstance;
    private MethodInfo[] preciseMethodsCalled;
    private HashMap<MethodInfo, ValueSource> valuesByMethod;

    public Invoke(CodeAttribute method, MethodrefInfo ref) {
        super(method);
        this.methodInfo = ref;
    }

    @Override
    public abstract int getOpcode();

    public String getJavaMethodName() {
        return this.methodInfo.getMethodName();
    }

    public MethodrefInfo getMethodInvoked() {
        return this.methodInfo;
    }

    @Override
    public final int getNumberOfOperandsProduced() {
        return this.getMethodInvoked().returnsVoid() ? 0 : 1;
    }

    @Override
    public int getNumberOfOperandsConsumed() {
        if (this.numberOfOperandsConsumed == -1) {
            this.numberOfOperandsConsumed = this.getMethodInvoked().getNumberOfParameters() + 1;
        }
        return this.numberOfOperandsConsumed;
    }

    @Override
    public final int getNumberOfOperandsPeekedAt() {
        return 0;
    }

    @Override
    public EventKind getTypeProduced() {
        QualifiedClassName returnType = this.getMethodInvoked().getReturnType();
        if (returnType.isPrimitive()) {
            return NameAndTypeInfo.typeCharacterToClass(returnType.getText().charAt(0));
        }
        return EventKind.OBJECT_PRODUCED;
    }

    public StackDependencies.Producers getInstanceProducers() {
        if (this instanceof INVOKESTATIC) {
            return new StackDependencies.Producers();
        }
        return this.getProducersOfArgument(0);
    }

    public boolean callsOnThis() {
        Instruction instanceProducer = this.getProducersOfArgument(0).getFirstProducer();
        return instanceProducer instanceof GetLocal && ((GetLocal)instanceProducer).getLocalID() == 0;
    }

    public MethodInfo[] getPreciseMethodsCalled(Trace trace, Cancelable cancelable) {
        if (cancelable != null && cancelable.wasCanceled()) {
            return null;
        }
        if (this.preciseMethodsCalled != null) {
            return this.preciseMethodsCalled;
        }
        this.preciseMethodsCalled = new MethodInfo[0];
        HashSet<MethodInfo> preciseMethodsCalledSet = new HashSet<MethodInfo>();
        preciseMethodsCalledSet = new HashSet();
        this.potentialValuesOfInstance = ValueSourceAnalyzer.getPotentialValues(trace, this, 0, cancelable);
        if (cancelable != null && cancelable.wasCanceled()) {
            this.preciseMethodsCalled = null;
            this.potentialValuesOfInstance = null;
            return null;
        }
        HashMap<MethodInfo, ValueSource> values = new HashMap<MethodInfo, ValueSource>(this.potentialValuesOfInstance.size() / 3);
        for (ValueSource potentialValue : this.potentialValuesOfInstance) {
            MethodInfo method;
            Instruction value = potentialValue.instruction;
            if (potentialValue.type == null || (method = trace.resolveMethodReference(potentialValue.type, this)) == null) continue;
            preciseMethodsCalledSet.add(method);
            values.put(method, potentialValue);
        }
        if (preciseMethodsCalledSet.isEmpty() && this instanceof INVOKEVIRTUAL) {
            MethodInfo[] methodInfoArray = trace.getMethodsFromReference(this);
            int n = methodInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodInfo method = methodInfoArray[n2];
                preciseMethodsCalledSet.add(method);
                ++n2;
            }
        }
        this.preciseMethodsCalled = new MethodInfo[preciseMethodsCalledSet.size()];
        preciseMethodsCalledSet.toArray(this.preciseMethodsCalled);
        return this.preciseMethodsCalled;
    }

    @Override
    @Deprecated
    public final String getTypeDescriptorOfArgument(int argIndex) {
        if (this instanceof INVOKESTATIC) {
            return this.getMethodInvoked().getParsedDescriptor().getTypeOfArgumentNumber(argIndex).getText();
        }
        if (argIndex == 0) {
            StringBuilder builder = new StringBuilder("L");
            builder.append(this.getMethodInvoked().getClassName().getText());
            builder.append(";");
            return builder.toString();
        }
        return this.getMethodInvoked().getParsedDescriptor().getTypeOfArgumentNumber(argIndex - 1).getText();
    }

    public ValueSource getPotentialValueFor(MethodInfo method) {
        if (this.valuesByMethod == null) {
            return null;
        }
        return this.valuesByMethod.get(method);
    }

    public Set<ValueSource> getPotentialValuesOfInstance(Trace trace) {
        return this.potentialValuesOfInstance;
    }

    @Override
    public String getReadableDescription() {
        return String.valueOf(this.getMethodInvoked().getMethodName()) + "()";
    }

    @Override
    public String getAssociatedName() {
        return this.getJavaMethodName();
    }

    public int getFirstArgumentAppearingInSource() {
        if (this.methodInfo.callsInstanceInitializer() && this.methodInfo.getClassName().isInner() && !this.getClassfile().isStatic()) {
            if (this.getClassfile().isInnerClass()) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public boolean couldCallOn(ValueSource typeOfThis, Trace trace) {
        this.getPreciseMethodsCalled(trace, null);
        assert (this.potentialValuesOfInstance != null);
        ClassIDs classids = trace.getClassIDs();
        boolean thisIsEncapsulated = typeOfThis.isEncapsulatedByProducingClass(trace);
        for (ValueSource value : this.potentialValuesOfInstance) {
            Classfile valueClass;
            boolean instanceTypeIsEncapsulated = value.isEncapsulatedByProducingClass(trace);
            if (value.type == null || typeOfThis == null || (valueClass = trace.getClassfileByName(value.type)) != null && !valueClass.isExtendsOrImplements(typeOfThis.type)) continue;
            if (thisIsEncapsulated) {
                Classfile valueProducerClass;
                if (!value.isEncapsulatedByProducingClass(trace) || typeOfThis.typeProducedIn.type == null || value.typeProducedIn.type == null || (valueProducerClass = trace.getClassfileByName(value.typeProducedIn.type)) != null && !valueProducerClass.isExtendsOrImplements(typeOfThis.typeProducedIn.type)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getMethodInvoked().getShortQualifiedNameAndDescriptor();
    }
}

