/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionsAttribute
extends Attribute {
    private UTF8Info attributeName;
    private ConstantPool pool;
    private ClassInfo[] exceptionsThrown;
    private int length;

    public ExceptionsAttribute(UTF8Info attributeName, ConstantPool pool, DataInputStream data, int length) throws IOException {
        this.attributeName = attributeName;
        this.pool = pool;
        this.length = length;
        this.exceptionsThrown = new ClassInfo[data.readUnsignedShort()];
        int i = 0;
        while (i < this.exceptionsThrown.length) {
            this.exceptionsThrown[i] = (ClassInfo)pool.get(data.readUnsignedShort());
            ++i;
        }
    }

    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeShort(this.attributeName.getIndexInConstantPool());
        stream.writeInt(this.getAttributeLengthWithoutNameAndLength());
        stream.writeShort(this.exceptionsThrown.length);
        ClassInfo[] classInfoArray = this.exceptionsThrown;
        int n = this.exceptionsThrown.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo ex = classInfoArray[n2];
            stream.writeShort(ex.getIndexInConstantPool());
            ++n2;
        }
    }

    public int getTotalAttributeLength() {
        return 8 + this.exceptionsThrown.length * 2;
    }
}

