/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolPadding;
import edu.cmu.hcii.whyline.bytecode.DoubleInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefInfo;
import edu.cmu.hcii.whyline.bytecode.FloatInfo;
import edu.cmu.hcii.whyline.bytecode.IntegerInfo;
import edu.cmu.hcii.whyline.bytecode.InterfaceMethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.LongInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StringInfo;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstantPool {
    public static final int MAXIMUM_CONTANT_POOL_ENTRIES = 65535;
    private final Classfile classfile;
    private ConstantPoolInfo[] items;
    private int size;
    private Set<QualifiedClassName> classesReferenced;

    public ConstantPool(Classfile classfile, DataInputStream data) throws IOException, JavaSpecificationViolation {
        ConstantPoolInfo info;
        this.classfile = classfile;
        short constantPoolCount = data.readShort();
        this.items = new ConstantPoolInfo[constantPoolCount];
        this.addItem(null);
        while ((constantPoolCount = (short)(constantPoolCount - 1)) > 0) {
            int tag = data.readUnsignedByte();
            boolean addPadding = false;
            switch (tag) {
                case 1: {
                    info = new UTF8Info(this, data);
                    break;
                }
                case 3: {
                    info = new IntegerInfo(this, data);
                    break;
                }
                case 4: {
                    info = new FloatInfo(this, data);
                    break;
                }
                case 5: {
                    info = new LongInfo(this, data);
                    addPadding = true;
                    break;
                }
                case 6: {
                    info = new DoubleInfo(this, data);
                    addPadding = true;
                    break;
                }
                case 7: {
                    info = new ClassInfo(this, data);
                    break;
                }
                case 8: {
                    info = new StringInfo(this, data);
                    break;
                }
                case 9: {
                    info = new FieldrefInfo(this, data);
                    break;
                }
                case 10: {
                    info = new MethodrefInfo(this, data);
                    break;
                }
                case 11: {
                    info = new InterfaceMethodrefInfo(this, data);
                    break;
                }
                case 12: {
                    info = new NameAndTypeInfo(this, data);
                    break;
                }
                default: {
                    throw new IOException("Invalid constant pool tag: " + tag);
                }
            }
            this.items[this.size++] = info;
            if (!addPadding) continue;
            this.items[this.size++] = new ConstantPoolPadding(this);
            constantPoolCount = (short)(constantPoolCount - 1);
        }
        ConstantPoolInfo[] constantPoolInfoArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            info = constantPoolInfoArray[n2];
            if (info != null) {
                info.resolveDependencies();
            }
            ++n2;
        }
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeShort(this.size);
        int i = 0;
        while (i < this.size) {
            if (this.items[i] != null) {
                this.items[i].toBytes(bytes);
            }
            ++i;
        }
    }

    private void addItem(ConstantPoolInfo info) throws JavaSpecificationViolation {
        if (this.size >= this.items.length) {
            ConstantPoolInfo[] newItems = new ConstantPoolInfo[this.size * 2];
            System.arraycopy(this.items, 0, newItems, 0, this.size);
            this.items = newItems;
        }
        this.items[this.size++] = info;
        if (this.size > 65535) {
            throw new JavaSpecificationViolation("The constant pool of " + this.classfile + " exceeds " + 65535 + " entries, which is a violation of the liimtations of the bytecode spec.");
        }
    }

    public ConstantPoolInfo get(int index) throws ArrayIndexOutOfBoundsException {
        return this.items[index];
    }

    public ConstantPoolInfo[] getItems() {
        if (this.size < this.items.length) {
            ConstantPoolInfo[] newItems = new ConstantPoolInfo[this.size];
            System.arraycopy(this.items, 0, newItems, 0, this.size);
            this.items = newItems;
        }
        return this.items;
    }

    public Set<QualifiedClassName> getClassNamesReferenced() {
        if (this.classesReferenced == null) {
            this.classesReferenced = new HashSet<QualifiedClassName>();
            ConstantPoolInfo[] constantPoolInfoArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                ConstantPoolInfo info = constantPoolInfoArray[n2];
                if (info instanceof ClassInfo) {
                    this.classesReferenced.add(((ClassInfo)info).getName());
                }
                ++n2;
            }
        }
        return this.classesReferenced;
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public int getSize() {
        return this.size;
    }

    public int indexOf(ConstantPoolInfo entry) throws AnalysisException {
        int i = 0;
        while (i < this.size) {
            if (this.items[i] == entry) {
                return i;
            }
            ++i;
        }
        throw new AnalysisException("Fatal error: couldn't find constant pool info " + entry);
    }

    public IntegerInfo addIntegerInfo(int info) throws JavaSpecificationViolation {
        IntegerInfo intinfo = new IntegerInfo(this, info);
        this.addItem(intinfo);
        return intinfo;
    }

    public LongInfo addLongInfo(long value) throws JavaSpecificationViolation {
        LongInfo longinfo = new LongInfo(this, value);
        this.addItem(longinfo);
        this.addItem(new ConstantPoolPadding(this));
        return longinfo;
    }

    public DoubleInfo addDoubleInfo(double value) throws JavaSpecificationViolation {
        DoubleInfo doubleinfo = new DoubleInfo(this, value);
        this.addItem(doubleinfo);
        this.addItem(new ConstantPoolPadding(this));
        return doubleinfo;
    }

    public ClassInfo addClassInfo(Class<?> classToAdd) throws JavaSpecificationViolation {
        return this.addClassInfo(classToAdd.getName().replace('.', '/'));
    }

    public ClassInfo addClassInfo(String fullyQualifiedJVMClassName) throws JavaSpecificationViolation {
        ClassInfo classinfo = new ClassInfo(this, this.addUTF8Info(fullyQualifiedJVMClassName));
        this.addItem(classinfo);
        return classinfo;
    }

    public UTF8Info addUTF8Info(String string) throws JavaSpecificationViolation {
        UTF8Info utf8Info = new UTF8Info(this, string);
        this.addItem(utf8Info);
        return utf8Info;
    }

    public StringInfo addStringInfo(String string) throws JavaSpecificationViolation {
        StringInfo stringInfo = new StringInfo(this, this.addUTF8Info(string));
        this.addItem(stringInfo);
        return stringInfo;
    }

    public MethodrefInfo addMethodrefInfo(ClassInfo classinfo, String methodName, String signature) throws JavaSpecificationViolation {
        MethodrefInfo methodInfo = new MethodrefInfo(this, classinfo, this.addNameAndTypeInfo(this.addUTF8Info(methodName), this.addUTF8Info(signature)));
        this.addItem(methodInfo);
        return methodInfo;
    }

    private NameAndTypeInfo addNameAndTypeInfo(UTF8Info info, UTF8Info info2) throws JavaSpecificationViolation {
        NameAndTypeInfo nameAndType = new NameAndTypeInfo(this, info, info2);
        this.addItem(nameAndType);
        return nameAndType;
    }

    public String toString() {
        String result = "";
        int number = 0;
        ConstantPoolInfo[] constantPoolInfoArray = this.getItems();
        int n = constantPoolInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstantPoolInfo info = constantPoolInfoArray[n2];
            result = String.valueOf(result) + "\n" + number + "\t" + info;
            ++number;
            ++n2;
        }
        return result;
    }
}

