/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.analysis.ControlDependencies;
import edu.cmu.hcii.whyline.analysis.LocalDependencies;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.BytecodeParser;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.LineNumberTableAttribute;
import edu.cmu.hcii.whyline.bytecode.LocalVariableTableAttribute;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.MethodrefInfo;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.tracing.Agent;
import edu.cmu.hcii.whyline.tracing.ClassIDs;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeAttribute
extends Attribute {
    public static final int MAXIMUM_CODE_BYTE_LENGTH = 65536;
    private UTF8Info attributeName;
    private final Classfile classfile;
    private MethodInfo method;
    private ConstantPool pool;
    private int maxStack;
    private int maxLocals;
    private int codeArrayByteLength;
    private Instruction[] instructions;
    private int[] byteIndices;
    private INVOKESPECIAL callToInitializer = null;
    private INVOKESPECIAL callToSuper = null;
    private ExceptionHandler[] exceptionTable;
    private Attribute[] attributes;
    private ArrayList<LineNumberTableAttribute> lineNumbers = new ArrayList(1);
    private ArrayList<LocalVariableTableAttribute> localVariables = new ArrayList(1);
    private final ArrayList<AbstractReturn> returns = new ArrayList(1);
    private boolean isStateAffecting;
    private ControlDependencies controlDependencies;
    private LocalDependencies localDependencies = null;
    private boolean invokesTextualOutput = false;
    private TIntObjectHashMap<SortedSet<Branch>> incomingBranchesByInstructionIndex;

    public CodeAttribute(UTF8Info attributeName, MethodInfo owner, ConstantPool pool, DataInputStream data, int length) throws IOException, JavaSpecificationViolation, AnalysisException {
        this.attributeName = attributeName;
        this.method = owner;
        this.classfile = this.method.getClassfile();
        this.pool = pool;
        this.maxStack = data.readUnsignedShort();
        this.maxLocals = data.readUnsignedShort();
        this.codeArrayByteLength = data.readInt();
        this.instructions = BytecodeParser.parse(data, this.codeArrayByteLength, this);
        Instruction[] instructionsByByteIndex = this.computeCharacteristics();
        this.resolveTargets(instructionsByByteIndex);
        this.exceptionTable = new ExceptionHandler[data.readUnsignedShort()];
        int i = 0;
        while (i < this.exceptionTable.length) {
            this.exceptionTable[i] = new ExceptionHandler(instructionsByByteIndex[data.readUnsignedShort()], instructionsByByteIndex[data.readUnsignedShort()], instructionsByByteIndex[data.readUnsignedShort()], data.readUnsignedShort());
            ++i;
        }
        int numberOfAttributes = data.readUnsignedShort();
        this.attributes = new Attribute[numberOfAttributes];
        int i2 = 0;
        while (i2 < numberOfAttributes) {
            Attribute attr;
            this.attributes[i2] = attr = Attribute.read(this, pool, data);
            if (attr instanceof LineNumberTableAttribute) {
                this.lineNumbers.add((LineNumberTableAttribute)attr);
            } else if (attr instanceof LocalVariableTableAttribute) {
                this.localVariables.add((LocalVariableTableAttribute)attr);
            }
            ++i2;
        }
        instructionsByByteIndex = null;
    }

    private void resolveTargets(Instruction[] instructionsByByteIndex) throws AnalysisException {
        this.incomingBranchesByInstructionIndex = new TIntObjectHashMap((int)((double)this.instructions.length * 0.1));
        Instruction[] instructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction inst = instructionArray[n2];
            if (inst instanceof Branch) {
                ((Branch)inst).resolveTargets(instructionsByByteIndex);
            }
            ++n2;
        }
        this.incomingBranchesByInstructionIndex.trimToSize();
    }

    public SortedSet<Branch> getIncomingBranchesForInstruction(int instructionIndex) {
        return this.incomingBranchesByInstructionIndex.get(instructionIndex);
    }

    public void addIncomingBranchToInstruction(Branch branch, Instruction inst) {
        SortedSet<Branch> branches = this.incomingBranchesByInstructionIndex.get(inst.getIndex());
        if (branches == null) {
            branches = new TreeSet<Branch>();
            this.incomingBranchesByInstructionIndex.put(inst.getIndex(), branches);
        }
        branches.add(branch);
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public INVOKESPECIAL getCallToInitializer() {
        return this.callToInitializer;
    }

    public INVOKESPECIAL getCallToSuper() {
        return this.callToSuper;
    }

    public Iterable<AbstractReturn> getReturns() {
        return this.returns;
    }

    public boolean isStateAffecting() {
        return this.isStateAffecting;
    }

    private Instruction[] computeCharacteristics() throws JavaSpecificationViolation {
        Trace trace = this.getClassfile().getTrace();
        ClassIDs classIDs = trace == null ? Agent.classIDs : trace.getClassIDs();
        this.invokesTextualOutput = false;
        Instruction[] instructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction inst = instructionArray[n2];
            if (inst instanceof INVOKESPECIAL) {
                QualifiedClassName className;
                MethodrefInfo ref = ((INVOKESPECIAL)inst).getMethodInvoked();
                if (ref.callsInstanceInitializer() && this.method.isInstanceInitializer() && ((className = ref.getClassName()).equals(this.getMethod().getClassfile().getSuperclassInfo().getName()) || className.equals(this.getMethod().getClassfile().getInternalName()))) {
                    this.callToInitializer = (INVOKESPECIAL)inst;
                }
                if (ref.getMethodName().equals(this.method.getInternalName()) && ref.getMethodDescriptor().equals(this.method.getDescriptor()) && ref.getClassName() == this.method.getClassfile().getSuperclassInfo().getName()) {
                    this.callToSuper = (INVOKESPECIAL)inst;
                }
            }
            if (classIDs != null && !this.invokesTextualOutput && inst instanceof Invoke) {
                MethodrefInfo methodInvoked = ((Invoke)inst).getMethodInvoked();
                QualifiedClassName classInvokedOn = methodInvoked.getClassName();
                this.invokesTextualOutput = classIDs.isOrIsSubclassOfTextualOutputProducer(classInvokedOn);
            }
            ++n2;
        }
        this.returns.clear();
        this.isStateAffecting = false;
        Instruction[] instructionsByByteIndex = new Instruction[this.instructions.length * 3];
        this.byteIndices = new int[this.instructions.length];
        int byteIndex = 0;
        int instructionIndex = 0;
        while (instructionIndex < this.instructions.length) {
            Instruction inst = this.instructions[instructionIndex];
            if (inst instanceof AbstractReturn) {
                this.returns.add((AbstractReturn)inst);
            } else if (inst instanceof PUTFIELD) {
                this.isStateAffecting = true;
            }
            if (byteIndex >= instructionsByByteIndex.length) {
                Instruction[] newArray = new Instruction[byteIndex * 2];
                System.arraycopy(instructionsByByteIndex, 0, newArray, 0, instructionsByByteIndex.length);
                instructionsByByteIndex = newArray;
            }
            inst.setInstructionIndex(instructionIndex);
            instructionsByByteIndex[byteIndex] = inst;
            this.byteIndices[instructionIndex] = byteIndex;
            byteIndex += inst.byteLength();
            ++instructionIndex;
        }
        this.codeArrayByteLength = byteIndex;
        if (this.codeArrayByteLength > 65536) {
            throw new JavaSpecificationViolation(this.getMethod().getQualifiedNameAndDescriptor() + " is too long! At " + this.codeArrayByteLength + " bytes long, it exceeds the maximum of " + 65536 + " bytes.");
        }
        return instructionsByByteIndex;
    }

    public boolean invokesTextualOutput() {
        return this.invokesTextualOutput;
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        Object attr;
        int totalLength = 8 + this.codeArrayByteLength + 2 + this.exceptionTable.length * 8 + 2;
        Object[] objectArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            attr = objectArray[n2];
            totalLength += ((Attribute)attr).getTotalAttributeLength();
            ++n2;
        }
        stream.writeShort(this.attributeName.getIndexInConstantPool());
        stream.writeInt(totalLength);
        stream.writeShort(this.maxStack + 50);
        stream.writeShort(this.maxLocals);
        stream.writeInt(this.codeArrayByteLength);
        objectArray = this.instructions;
        n = this.instructions.length;
        n2 = 0;
        while (n2 < n) {
            Object inst = objectArray[n2];
            ((Instruction)inst).toBytes(stream);
            ++n2;
        }
        stream.writeShort(this.exceptionTable.length);
        objectArray = this.exceptionTable;
        n = this.exceptionTable.length;
        n2 = 0;
        while (n2 < n) {
            Object info = objectArray[n2];
            stream.writeShort(((ExceptionHandler)info).getStartPC().getByteIndex());
            Instruction endPC = ((ExceptionHandler)info).getEndPC();
            stream.writeShort(endPC == null ? this.codeArrayByteLength : endPC.getByteIndex());
            stream.writeShort(((ExceptionHandler)info).getHandlerPC().getByteIndex());
            stream.writeShort(((ExceptionHandler)info).getCatchTypeIndex());
            ++n2;
        }
        stream.writeShort(this.attributes.length);
        objectArray = this.attributes;
        n = this.attributes.length;
        n2 = 0;
        while (n2 < n) {
            attr = objectArray[n2];
            ((Attribute)attr).toBytes(stream);
            ++n2;
        }
    }

    @Override
    public int getTotalAttributeLength() {
        throw new RuntimeException("We actually only compute the length of a code attribute when writing it to a byte stream.");
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getNumberOfInstructions() {
        return this.instructions.length;
    }

    public int getFirstInstructionID() {
        return this.method.getFirstInstructionID();
    }

    public Instruction getInstruction(int index) {
        return index < 0 || index >= this.instructions.length ? null : this.instructions[index];
    }

    public Instruction getFirstInstruction() {
        return this.instructions[0];
    }

    public Instruction[] getInstructions() {
        return this.instructions;
    }

    public int getByteIndex(int instructionIndex) {
        return this.byteIndices[instructionIndex];
    }

    public void setInstructions(Instruction[] newInstructions) throws JavaSpecificationViolation {
        Instruction[] oldInstructions = this.instructions;
        this.instructions = newInstructions;
        try {
            this.computeCharacteristics();
        }
        catch (JavaSpecificationViolation e) {
            this.instructions = oldInstructions;
            this.computeCharacteristics();
            throw e;
        }
    }

    public List<ExceptionHandler> getExceptionTable() {
        return Collections.unmodifiableList(Arrays.asList(this.exceptionTable));
    }

    public List<ExceptionHandler> getExceptionHandlersThatExecute(Instruction inst) {
        int largestHandlerIndexBeforeOrAtGivenInstruction = 0;
        ExceptionHandler[] exceptionHandlerArray = this.exceptionTable;
        int n = this.exceptionTable.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionHandler handler = exceptionHandlerArray[n2];
            if (handler.getHandlerPC().getIndex() <= inst.getIndex()) {
                largestHandlerIndexBeforeOrAtGivenInstruction = Math.max(largestHandlerIndexBeforeOrAtGivenInstruction, handler.getHandlerPC().getIndex());
            }
            ++n2;
        }
        Vector<ExceptionHandler> handlers = new Vector<ExceptionHandler>(3);
        ExceptionHandler[] exceptionHandlerArray2 = this.exceptionTable;
        int n3 = this.exceptionTable.length;
        n = 0;
        while (n < n3) {
            ExceptionHandler handler = exceptionHandlerArray2[n];
            if (handler.getHandlerPC().getIndex() == largestHandlerIndexBeforeOrAtGivenInstruction) {
                handlers.add(handler);
            }
            ++n;
        }
        return handlers;
    }

    public ExceptionHandler getHandlerStartingWith(Instruction i) {
        for (ExceptionHandler handler : this.getExceptionTable()) {
            if (handler.getHandlerPC() != i) continue;
            return handler;
        }
        return null;
    }

    public boolean isInstructionInTryCatchBlock(Instruction instruction) {
        ExceptionHandler[] exceptionHandlerArray = this.exceptionTable;
        int n = this.exceptionTable.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionHandler handler = exceptionHandlerArray[n2];
            if (handler.handles(instruction)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<ExceptionHandler> getExceptionHandlersProtecting(Instruction instruction) {
        HashSet<ExceptionHandler> handlers = new HashSet<ExceptionHandler>();
        ExceptionHandler[] exceptionHandlerArray = this.exceptionTable;
        int n = this.exceptionTable.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionHandler handler = exceptionHandlerArray[n2];
            if (handler.handles(instruction)) {
                handlers.add(handler);
            }
            ++n2;
        }
        return handlers;
    }

    public LineNumber getLineNumberFor(Instruction instruction) {
        for (LineNumberTableAttribute lines : this.lineNumbers) {
            LineNumber lineNumber = lines.getLineNumberOf(instruction);
            if (lineNumber == null) continue;
            return lineNumber;
        }
        return null;
    }

    public LineNumber getFirstLineNumber() {
        LineNumber lowestLineNumber = null;
        for (LineNumberTableAttribute lines : this.lineNumbers) {
            LineNumber lowestInTable = lines.getFirstLineNumber();
            if (lowestLineNumber == null) {
                lowestLineNumber = lowestInTable;
                continue;
            }
            if (!lowestInTable.isBefore(lowestLineNumber)) continue;
            lowestLineNumber = lowestInTable;
        }
        return lowestLineNumber;
    }

    public LineNumber getLastLineNumber() {
        LineNumber largestLineNumber = null;
        for (LineNumberTableAttribute lines : this.lineNumbers) {
            LineNumber largestInTable = lines.getLastLineNumber();
            if (largestLineNumber == null) {
                largestLineNumber = largestInTable;
                continue;
            }
            if (!largestInTable.isAfter(largestLineNumber)) continue;
            largestLineNumber = largestInTable;
        }
        return largestLineNumber;
    }

    public Instruction getInstructionAtByteIndex(int byteIndex) {
        int instructionIndex = this.getInstructionIndexOfByteIndex(byteIndex);
        return instructionIndex < 0 ? null : this.instructions[instructionIndex];
    }

    private int getInstructionIndexOfByteIndex(int byteIndex) {
        int low = 0;
        int high = this.byteIndices.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int current = this.byteIndices[mid];
            if (current > byteIndex) {
                high = mid - 1;
                continue;
            }
            if (current < byteIndex) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public boolean hasLocalVariableInfo() {
        return this.localVariables.size() > 0;
    }

    public String getLocalIDNameRelativeToInstruction(int localID, Instruction inst) {
        assert (inst.getCode() == this);
        if (this.hasLocalVariableInfo()) {
            boolean isDefined = false;
            for (LocalVariableTableAttribute table : this.localVariables) {
                if (!table.isLocalIDDefinedRelativeToInstruction(localID, inst)) continue;
                isDefined = true;
            }
            if (!isDefined) {
                return null;
            }
        }
        String name = null;
        for (LocalVariableTableAttribute table : this.localVariables) {
            name = table.getNameOfLocalIDRelativeToInstruction(localID, inst);
            if (name == null) continue;
            return name;
        }
        if (!this.method.isStatic() && localID == 0) {
            return "this";
        }
        JavaSourceFile source = this.getClassfile().getSourceFile();
        MethodInfo method = this.getMethod();
        if (source != null) {
            if (localID < method.getLocalIDOfFirstNonArgument()) {
                int argNumber = method.getParsedDescriptor().getArgumentNumberFromLocalID(localID);
                if (argNumber < 0) {
                    return null;
                }
                if (method.isStatic()) {
                    ++argNumber;
                }
                if ((name = source.getNameOfParameterNumber(method, argNumber)) != null) {
                    return name;
                }
            } else {
                name = source.getLocalIDNameRelativeToInstruction(localID, inst);
                if (name != null) {
                    return name;
                }
            }
        }
        int number = localID;
        if (method.isStatic()) {
            ++number;
        }
        return "[" + (localID < method.getNumberOfArguments() ? "arg" : "local") + number + "]";
    }

    public String getDescriptorOfLocalIDRelativeToInstruction(int localID, Instruction inst) {
        assert (inst.getCode() == this);
        for (LocalVariableTableAttribute table : this.localVariables) {
            String name = table.getDescriptorOfLocalIDRelativeToInstruction(localID, inst);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public int getLocalIDOfNameRelativeToInstruction(String name, Instruction inst) {
        assert (inst.getCode() == this);
        int localID = -1;
        for (LocalVariableTableAttribute table : this.localVariables) {
            localID = table.getLocalIDOfNameRelativeToInstruction(name, inst);
            if (localID == -1) continue;
            return localID;
        }
        return -1;
    }

    public boolean localIDIsDefinedAt(int localID, Instruction inst) {
        for (LocalVariableTableAttribute table : this.localVariables) {
            if (!table.localIDIsDefinedAt(localID, inst)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getLocalNames() {
        HashSet<String> names = new HashSet<String>();
        for (LocalVariableTableAttribute table : this.localVariables) {
            names.addAll(table.getLocalNames());
        }
        return names;
    }

    public SortedSet<Instruction> getInstructionsOnLineNumber(LineNumber lineNumber) {
        TreeSet<Instruction> instructions = new TreeSet<Instruction>();
        for (LineNumberTableAttribute lines : this.lineNumbers) {
            lines.getInstructionsOnLineNumber(instructions, lineNumber);
        }
        return instructions;
    }

    public Set<Instruction> getControlDependenciesFor(Instruction inst) {
        if (this.controlDependencies == null) {
            this.controlDependencies = new ControlDependencies(this);
        }
        return this.controlDependencies.getControlDependenciesOf(inst);
    }

    public StackDependencies.Producers getProducersOfArgument(Instruction inst, int arg) {
        try {
            StackDependencies dependencies = this.classfile.getStackDependenciesCache().getStackDependenciesFor(this.method);
            return dependencies.getProducersOfArgument(inst, arg);
        }
        catch (AnalysisException e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public StackDependencies.Consumers getConsumersOf(Instruction inst) {
        try {
            StackDependencies dependencies = this.classfile.getStackDependenciesCache().getStackDependenciesFor(this.method);
            return dependencies.getConsumersOf(inst);
        }
        catch (AnalysisException e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public LocalDependencies getLocalDependencies() {
        if (this.localDependencies == null) {
            this.localDependencies = new LocalDependencies(this);
        }
        return this.localDependencies;
    }

    public void trimToSize() {
        this.returns.trimToSize();
        this.localVariables.trimToSize();
        this.lineNumbers.trimToSize();
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder(this.getNumberOfInstructions() * 50);
            builder.append(this.getMethod().getQualifiedNameAndDescriptor());
            builder.append("\n(1st instruction ID = " + this.method.getFirstInstructionID() + ")");
            builder.append("\n");
            Object[] objectArray = this.instructions;
            int n = this.instructions.length;
            int n2 = 0;
            while (n2 < n) {
                Instruction i = objectArray[n2];
                builder.append("(");
                builder.append(i.getByteIndex());
                builder.append(")\t");
                try {
                    builder.append(i);
                }
                catch (Exception e) {
                    builder.append("(exception during toString())");
                }
                builder.append("\n");
                ++n2;
            }
            objectArray = this.exceptionTable;
            n = this.exceptionTable.length;
            n2 = 0;
            while (n2 < n) {
                Object handler = objectArray[n2];
                builder.append("\n" + handler);
                ++n2;
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "exception in toString()";
        }
    }
}

