/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.INSTANCEOF;
import edu.cmu.hcii.whyline.bytecode.IOAttribute;
import edu.cmu.hcii.whyline.bytecode.InnerClassesAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodDescriptor;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.Opcodes;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.SourceFileAttribute;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.StackDependenciesCache;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.Parameter;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import gnu.trove.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Classfile
implements FileInterface,
Comparable<FileInterface>,
Named {
    private int magic;
    private int majorVersion;
    private int minorVersion;
    private int accessFlag;
    private ConstantPool pool = null;
    private ClassInfo thisClass;
    private ClassInfo superClassInfo;
    private QualifiedClassName classname;
    private Classfile superclass;
    private final ArrayList<Classfile> subclasses = new ArrayList(3);
    private final ArrayList<Classfile> implementors = new ArrayList(3);
    private TIntHashSet superclasses;
    private ClassInfo[] interfaces;
    private final ArrayList<Classfile> interfacesImplemented = new ArrayList(3);
    private ArrayList<Attribute> attributes = new ArrayList(3);
    private ArrayList<MethodInfo> methods;
    private MethodInfo[] nonAbstractMethods;
    private HashMap<String, MethodInfo> methodsBySignature = new HashMap();
    private HashMap<String, FieldInfo> fieldsByName = new HashMap();
    private ArrayList<FieldInfo> fields;
    private SourceFileAttribute sourceFile;
    private JavaSourceFile source = null;
    private MethodInfo main = null;
    private final int originalLength;
    private final WeakReference<Trace> trace;
    private IOAttribute io;
    private InnerClassesAttribute innerClasses;
    private StackDependenciesCache stackDependenciesCache = new StackDependenciesCache(){
        private final HashMap<MethodInfo, StackDependencies> stackDependenciesByMethod = new HashMap(3);

        public StackDependencies getStackDependenciesFor(MethodInfo method) throws AnalysisException {
            StackDependencies dependencies = this.stackDependenciesByMethod.get(method);
            if (dependencies == null && method.getCode() != null) {
                dependencies = new StackDependencies(method.getCode());
                this.stackDependenciesByMethod.put(method, dependencies);
                dependencies.analyze();
            }
            return dependencies;
        }
    };
    private Line[] lines = null;
    private HashMap<Instruction, LineNumber> lineNumbersByInstruction;
    private HashMap<Token, Instruction> instructionsByToken;
    private HashMap<Instruction, SortedSet<Token>> tokensByInstruction;
    private HashMap<MethodInfo, Token> methodNameTokensByMethod;

    public Classfile(byte[] classfileBuffer) throws IOException, JavaSpecificationViolation, AnalysisException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(classfileBuffer));
        this.originalLength = classfileBuffer.length;
        this.read(stream);
        this.trace = null;
    }

    public Classfile(DataInputStream stream, Trace trace) throws IOException, JavaSpecificationViolation, AnalysisException {
        this.trace = new WeakReference<Trace>(trace);
        this.originalLength = 1024;
        this.read(stream);
    }

    public StackDependenciesCache getStackDependenciesCache() {
        return this.stackDependenciesCache;
    }

    public void setStackDependenciesCache(StackDependenciesCache cache) {
        this.stackDependenciesCache = cache;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.accessFlag);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.accessFlag);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlag);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlag);
    }

    public boolean isStatic() {
        if (this.innerClasses == null) {
            return false;
        }
        int flags = this.innerClasses.getFlagsFor(this.getInternalName());
        if (flags >= 0) {
            return Modifier.isStatic(flags);
        }
        return false;
    }

    @Override
    public int compareTo(FileInterface c) {
        return this.getShortFileName().compareTo(c.getShortFileName());
    }

    private void read(DataInputStream in) throws IOException, JavaSpecificationViolation, AnalysisException {
        this.magic = in.readInt();
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        this.pool = new ConstantPool(this, in);
        this.accessFlag = in.readUnsignedShort();
        this.thisClass = (ClassInfo)this.pool.get(in.readUnsignedShort());
        int superClassIndex = in.readUnsignedShort();
        this.superClassInfo = superClassIndex == 0 ? (this.superClassInfo = null) : (ClassInfo)this.pool.get(superClassIndex);
        int interfacesCount = in.readUnsignedShort();
        this.interfaces = new ClassInfo[interfacesCount];
        int i = 0;
        while (i < interfacesCount) {
            this.interfaces[i] = (ClassInfo)this.pool.get(in.readUnsignedShort());
            ++i;
        }
        int fieldCount = in.readUnsignedShort();
        this.fields = new ArrayList(fieldCount);
        int index = 0;
        while (index < fieldCount) {
            this.fields.add(new FieldInfo(this, in, this.pool, index));
            this.fieldsByName.put(this.fields.get(index).getDisplayName(true, -1), this.fields.get(index));
            ++index;
        }
        int totalNumberOfInstructions = 0;
        int methodCount = in.readUnsignedShort();
        this.methods = new ArrayList(methodCount);
        ArrayList<MethodInfo> nonAbstractMethodsTemp = new ArrayList<MethodInfo>(methodCount);
        int i2 = 0;
        while (i2 < methodCount) {
            MethodInfo newMethod;
            totalNumberOfInstructions += (newMethod = new MethodInfo(in, this, totalNumberOfInstructions, i2)).getCode() == null ? 0 : newMethod.getCode().getNumberOfInstructions();
            this.methods.add(newMethod);
            if (newMethod.getCode() != null) {
                nonAbstractMethodsTemp.add(newMethod);
            }
            if (newMethod.getInternalName().equals("main") && newMethod.getDescriptor().equals("([Ljava/lang/String;)V")) {
                this.main = newMethod;
            }
            this.methodsBySignature.put(newMethod.getMethodNameAndDescriptor(), newMethod);
            ++i2;
        }
        this.nonAbstractMethods = new MethodInfo[nonAbstractMethodsTemp.size()];
        nonAbstractMethodsTemp.toArray(this.nonAbstractMethods);
        int attributeCount = in.readUnsignedShort();
        int i3 = 0;
        while (i3 < attributeCount) {
            Attribute attr = Attribute.read(this, this.pool, in);
            this.attributes.add(attr);
            if (attr instanceof SourceFileAttribute) {
                this.sourceFile = (SourceFileAttribute)attr;
            } else if (attr instanceof IOAttribute) {
                this.io = (IOAttribute)attr;
            } else if (attr instanceof InnerClassesAttribute) {
                this.innerClasses = (InnerClassesAttribute)attr;
            }
            ++i3;
        }
        if (this.io == null) {
            this.io = new IOAttribute(this.pool);
            this.attributes.add(this.io);
        }
        in.close();
    }

    public static ClassInfo getSuperclass(byte[] bytes) {
        try {
            ClassInfo superClassInfo;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            int magic = in.readInt();
            int minorVersion = in.readUnsignedShort();
            int majorVersion = in.readUnsignedShort();
            ConstantPool pool = new ConstantPool(null, in);
            int accessFlag = in.readUnsignedShort();
            ClassInfo thisClass = (ClassInfo)pool.get(in.readUnsignedShort());
            int superClassIndex = in.readUnsignedShort();
            superClassInfo = superClassIndex == 0 ? (superClassInfo = null) : (ClassInfo)pool.get(superClassIndex);
            return superClassInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hasMain(DataInputStream in) {
        try {
            ClassInfo superClassInfo;
            int magic = in.readInt();
            int minorVersion = in.readUnsignedShort();
            int majorVersion = in.readUnsignedShort();
            ConstantPool pool = new ConstantPool(null, in);
            int accessFlag = in.readUnsignedShort();
            ClassInfo thisClass = (ClassInfo)pool.get(in.readUnsignedShort());
            int superClassIndex = in.readUnsignedShort();
            superClassInfo = superClassIndex == 0 ? (superClassInfo = null) : (ClassInfo)pool.get(superClassIndex);
            int interfacesCount = in.readUnsignedShort();
            ClassInfo[] interfaces = new ClassInfo[interfacesCount];
            int i = 0;
            while (i < interfacesCount) {
                interfaces[i] = (ClassInfo)pool.get(in.readUnsignedShort());
                ++i;
            }
            int fieldCount = in.readUnsignedShort();
            int i2 = 0;
            while (i2 < fieldCount) {
                in.readUnsignedShort();
                in.readUnsignedShort();
                in.readUnsignedShort();
                int attributeCount = in.readUnsignedShort();
                int j = 0;
                while (j < attributeCount) {
                    in.readUnsignedShort();
                    int length = in.readInt();
                    in.skipBytes(length);
                    ++j;
                }
                ++i2;
            }
            int methodCount = in.readUnsignedShort();
            int i3 = 0;
            while (i3 < methodCount) {
                in.readUnsignedShort();
                UTF8Info nameInfo = (UTF8Info)pool.get(in.readUnsignedShort());
                String name = nameInfo.toString();
                UTF8Info descriptorInfo = (UTF8Info)pool.get(in.readUnsignedShort());
                String descriptor = descriptorInfo.toString();
                if (name.equals("main") && descriptor.equals("([Ljava/lang/String;)V")) {
                    return thisClass.getName().getText();
                }
                int attributeCount = in.readUnsignedShort();
                int j = 0;
                while (j < attributeCount) {
                    in.readUnsignedShort();
                    int length = in.readInt();
                    in.skipBytes(length);
                    ++j;
                }
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public void setSuperclass(Classfile superclass) {
        this.superclass = superclass;
    }

    protected void forgetSuperclasses() {
        this.superclasses = null;
    }

    private void determineSuperclasses() {
        this.superclasses = new TIntHashSet(2);
        Classfile clazz = this;
        while (clazz != null) {
            ClassInfo superInfo = clazz.getSuperclassInfo();
            if (superInfo != null) {
                this.superclasses.add(superInfo.getName().getID());
            }
            clazz = clazz.getSuperclass();
        }
        this.superclasses.trimToSize();
    }

    public boolean isSubclassOf(QualifiedClassName qualifiedClassname) {
        if (qualifiedClassname == null) {
            return false;
        }
        if (this.superclasses == null) {
            this.determineSuperclasses();
        }
        if (this.getInternalName() == qualifiedClassname) {
            return true;
        }
        return this.superclasses.contains(qualifiedClassname.getID());
    }

    public boolean isExtendsOrImplements(QualifiedClassName name) {
        return this.getInternalName() == name || this.isSubclassOf(name) || this.implementsInterface(name);
    }

    public boolean isSuperclassOf(Classfile classfile) {
        Classfile superclass = classfile.getSuperclass();
        while (superclass != null) {
            if (this == superclass) {
                return true;
            }
            superclass = superclass.getSuperclass();
        }
        return false;
    }

    public Classfile getBaseClass() {
        return this.superclass == null ? this : this.superclass.getSuperclass();
    }

    public Classfile getSuperclass() {
        return this.superclass;
    }

    public void addSubclass(Classfile subclass) {
        this.subclasses.add(subclass);
        for (MethodInfo method : subclass.getDeclaredMethods()) {
            MethodInfo overridenMethod = this.getDeclaredMethodByNameAndDescriptor(method.getMethodNameAndDescriptor());
            if (overridenMethod == null) continue;
            overridenMethod.addOverrider(method);
        }
    }

    public MethodInfo getMethodNumber(int number) {
        return this.methods.get(number);
    }

    public int getNumberOfMethod(MethodInfo method) {
        assert (method.getClassfile() == this) : method + " isn't in " + this;
        int number = this.methods.indexOf(method);
        assert (number != -1) : "Couldn't find the method in the list of methods.";
        return number;
    }

    public Iterable<Classfile> getDirectSubclasses() {
        return this.subclasses;
    }

    public Iterable<Classfile> getAllSubclasses() {
        ArrayList<Classfile> allSubclasses = new ArrayList<Classfile>(this.subclasses.size() * 2);
        this.addSubclasses(allSubclasses);
        return allSubclasses;
    }

    private void addSubclasses(List<Classfile> allSubclasses) {
        int i = 0;
        while (i < this.subclasses.size()) {
            Classfile c = this.subclasses.get(i);
            allSubclasses.add(c);
            c.addSubclasses(allSubclasses);
            ++i;
        }
    }

    public void addImplementor(Classfile implementor) {
        this.implementors.add(implementor);
        implementor.interfacesImplemented.add(this);
    }

    public boolean implementsInterface(QualifiedClassName qualifiedInterfaceName) {
        for (Classfile inter : this.interfacesImplemented) {
            if (!inter.getInternalName().equals(qualifiedInterfaceName) && !inter.implementsInterface(qualifiedInterfaceName)) continue;
            return true;
        }
        return false;
    }

    public List<Classfile> getImplementors() {
        return Collections.unmodifiableList(this.implementors);
    }

    public List<ClassInfo> getInterfacesImplemented() {
        return Collections.unmodifiableList(Arrays.asList(this.interfaces));
    }

    public ClassInfo getSuperclassInfo() {
        return this.superClassInfo;
    }

    public MethodInfo getMain() {
        return this.main;
    }

    public Iterable<Attribute> getAttributes() {
        return this.attributes;
    }

    public byte[] toByteArray() {
        return this.fillByteArrayStream().toByteArray();
    }

    public void writeToStream(OutputStream outputStream) {
        try {
            this.fillByteArrayStream().writeTo(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ByteArrayOutputStream fillByteArrayStream() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(this.originalLength * 2);
        DataOutputStream stream = new DataOutputStream(bytes);
        try {
            stream.writeInt(this.magic);
            stream.writeShort(this.minorVersion);
            stream.writeShort(this.majorVersion);
            this.pool.toBytes(stream);
            stream.writeShort(this.accessFlag);
            stream.writeShort(this.thisClass.getIndexInConstantPool());
            if (this.superClassInfo == null) {
                stream.writeShort(0);
            } else {
                stream.writeShort(this.superClassInfo.getIndexInConstantPool());
            }
            stream.writeShort(this.interfaces.length);
            ClassInfo[] classInfoArray = this.interfaces;
            int n = this.interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ClassInfo interfaceInfo = classInfoArray[n2];
                stream.writeShort(interfaceInfo.getIndexInConstantPool());
                ++n2;
            }
            stream.writeShort(this.fields.size());
            for (FieldInfo field : this.fields) {
                field.toBytes(stream);
            }
            stream.writeShort(this.methods.size());
            for (MethodInfo method : this.methods) {
                method.toBytes(stream);
            }
            stream.writeShort(this.attributes.size());
            for (Attribute attr : this.attributes) {
                attr.toBytes(stream);
            }
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return bytes;
        }
    }

    public Instruction getInstructionByID(int id) {
        int low = 0;
        int size = this.nonAbstractMethods.length;
        int high = size - 1;
        MethodInfo method = null;
        while (low <= high) {
            int mid = (low + high) / 2;
            MethodInfo match = this.nonAbstractMethods[mid];
            int current = match.getFirstInstructionID();
            if (current > id) {
                high = mid - 1;
                continue;
            }
            if (current < id && mid < size - 1 && this.nonAbstractMethods[mid + 1].getFirstInstructionID() <= id) {
                low = mid + 1;
                continue;
            }
            method = match;
            break;
        }
        assert (method != null) : "Couldn't find the method of instruction ID " + id;
        return method.getCode().getInstruction(id - method.getFirstInstructionID());
    }

    public QualifiedClassName getInternalName() {
        if (this.classname == null) {
            this.classname = this.thisClass.getName();
        }
        return this.classname;
    }

    public String getJavaDocURL() {
        StringBuilder url = new StringBuilder();
        url.append(this.getInternalName().getText().replace('/', File.separatorChar));
        url.append(".html");
        return url.toString();
    }

    @Override
    public String getDisplayName(boolean html, int lengthLimit) {
        return Util.elide(this.getSimpleName(), lengthLimit);
    }

    public String getPackageName() {
        return this.getInternalName().getPackageName();
    }

    public String getSimpleName() {
        return this.getInternalName().getSimpleName();
    }

    public String getConstructorName() {
        String simple = this.getSimpleName();
        int indexOfDollarSign = simple.lastIndexOf(36);
        if (indexOfDollarSign >= 0) {
            simple = simple.substring(indexOfDollarSign);
        }
        return simple;
    }

    public List<FieldInfo> getDeclaredFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<FieldInfo> getAllFields() {
        Vector<FieldInfo> allFields = new Vector<FieldInfo>();
        Classfile parent = this;
        while (parent != null) {
            allFields.addAll(parent.fields);
            parent = parent.getSuperclass();
        }
        return Collections.unmodifiableList(allFields);
    }

    public List<FieldInfo> getAllInstanceFields() {
        Vector<FieldInfo> allFields = new Vector<FieldInfo>();
        Classfile parent = this;
        while (parent != null) {
            for (FieldInfo field : parent.fields) {
                if (field.isStatic()) continue;
                allFields.add(field);
            }
            parent = parent.getSuperclass();
        }
        return Collections.unmodifiableList(allFields);
    }

    public String getQualifiedSourceFileName() {
        if (this.sourceFile == null) {
            return "";
        }
        return String.valueOf(this.getPackageName()) + this.sourceFile.getSourceFileName();
    }

    public ConstantPool getConstantPool() {
        return this.pool;
    }

    public List<MethodInfo> getDeclaredMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public List<MethodInfo> getAllMethods() {
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        Classfile parent = this;
        while (parent != null) {
            allMethods.addAll(parent.methods);
            parent = parent.getSuperclass();
        }
        return allMethods;
    }

    public List<MethodInfo> getPublicInstanceMethods() {
        ArrayList<MethodInfo> allMethods = new ArrayList<MethodInfo>();
        Classfile parent = this;
        while (parent != null) {
            for (MethodInfo method : parent.methods) {
                if (!method.isPublic() || method.isStatic()) continue;
                allMethods.add(method);
            }
            parent = parent.getSuperclass();
        }
        return allMethods;
    }

    public boolean isInnerClass() {
        return this.getInternalName().isInner();
    }

    public boolean hasSourceFileAttribute() {
        return this.sourceFile != null;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public Trace getTrace() {
        return this.trace == null ? null : (Trace)this.trace.get();
    }

    public JavaSourceFile getSourceFile() {
        Trace t;
        Trace trace = t = this.trace != null ? (Trace)this.trace.get() : null;
        if (this.source == null && t != null) {
            this.source = t.getSourceFor(this);
        }
        if (this.source != null) {
            this.source.linkClassfile(this);
        }
        return this.source;
    }

    public MethodInfo getDeclaredMethodByNameAndDescriptor(String methodNameAndDescriptor) {
        return this.methodsBySignature.get(methodNameAndDescriptor);
    }

    public MethodInfo getDeclaredOrInheritedMethodByNameAndDescriptor(String methodNameAndDescriptor) {
        MethodInfo method = this.getDeclaredMethodByNameAndDescriptor(methodNameAndDescriptor);
        if (method != null) {
            return method;
        }
        if (this.superclass != null) {
            return this.superclass.getDeclaredOrInheritedMethodByNameAndDescriptor(methodNameAndDescriptor);
        }
        return null;
    }

    public FieldInfo getFieldByName(String name) {
        FieldInfo field = this.fieldsByName.get(name);
        if (field != null) {
            return field;
        }
        if (this.superclass != null) {
            return this.superclass.getFieldByName(name);
        }
        return null;
    }

    public FieldInfo getFieldNumber(int declarationIndex) {
        return this.fields.get(declarationIndex);
    }

    public SortedSet<Instruction> getInstructionsOnLineNumber(LineNumber lineNumber) {
        for (MethodInfo method : this.methods) {
            SortedSet<Instruction> instructionsOnLine;
            if (method.getCode() == null || (instructionsOnLine = method.getCode().getInstructionsOnLineNumber(lineNumber)).isEmpty()) continue;
            return instructionsOnLine;
        }
        return new TreeSet<Instruction>();
    }

    public IOAttribute getIOAttribute() {
        return this.io;
    }

    public String toString() {
        return this.thisClass.getName().getText();
    }

    @Override
    public Line[] getLines() {
        Line newLine;
        if (this.lines != null) {
            return this.lines;
        }
        this.lineNumbersByInstruction = new HashMap();
        this.instructionsByToken = new HashMap();
        this.tokensByInstruction = new HashMap();
        this.methodNameTokensByMethod = new HashMap();
        ArrayList<Line> linesTemp = new ArrayList<Line>();
        Line firstLine = new Line(new LineNumber(this, linesTemp.size() + 1), new Token[0]);
        firstLine.addToken(new Token(firstLine, String.valueOf(this.getInternalName().getNameWithDots()) + ".class", 76));
        linesTemp.add(firstLine);
        linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
        for (FieldInfo field : this.fields) {
            newLine = new Line(new LineNumber(this, linesTemp.size() + 1), new Token[0]);
            newLine.addToken(new Token(newLine, String.valueOf(Modifier.toString(field.getAccessFlags())) + " ", 48));
            newLine.addToken(new Token(newLine, String.valueOf(NameAndTypeInfo.getJavafiedTypeDescriptor(field.getTypeDescriptor())) + " ", 16));
            newLine.addToken(new Token(newLine, String.valueOf(field.getDisplayName(true, -1)) + " ", 76));
            linesTemp.add(newLine);
        }
        linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
        for (MethodInfo method : this.methods) {
            newLine = new Line(new LineNumber(this, linesTemp.size() + 1), new Token[0]);
            newLine.addToken(new Token(newLine, String.valueOf(Modifier.toString(method.getAccessFlags())) + " ", 48));
            MethodDescriptor descriptor = method.getParsedDescriptor();
            newLine.addToken(new Token(newLine, String.valueOf(descriptor.getReturnType().getSimpleName()) + " ", 16));
            Token methodNameToken = new Token(newLine, String.valueOf(method.getInternalName()) + " ", 76);
            this.methodNameTokensByMethod.put(method, methodNameToken);
            newLine.addToken(methodNameToken);
            newLine.addToken(new Token(newLine, "(", 79));
            int i = 0;
            while (i < descriptor.getNumberOfParameters()) {
                newLine.addToken(new Token(newLine, String.valueOf(descriptor.getTypeOfArgumentNumber(i).getSimpleName()) + " ", 16));
                newLine.addToken(new Token(newLine, "arg" + (i + 1), 76));
                if (i < descriptor.getNumberOfParameters() - 1) {
                    newLine.addToken(new Token(newLine, ", ", 86));
                }
                ++i;
            }
            newLine.addToken(new Token(newLine, ") ", 80));
            newLine.addToken(new Token(newLine, "{", 81));
            if (method.getCode() == null) {
                newLine.addToken(new Token(newLine, "}", 82));
                linesTemp.add(newLine);
            } else {
                linesTemp.add(newLine);
                linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
                int lineNumber = linesTemp.size() + 1;
                Instruction[] instructionArray = method.getCode().getInstructions();
                int n = instructionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction inst = instructionArray[n2];
                    Line newInstructionLine = new Line(new LineNumber(this, linesTemp.size() + 1), new Token[0]);
                    String line = Util.fillOrTruncateString("" + inst.getIndex(), 5);
                    String type = Util.fillOrTruncateString(Opcodes.NAMES[inst.getOpcode()].toLowerCase(), 18);
                    newInstructionLine.addToken(new Token(newInstructionLine, line, 65));
                    newInstructionLine.addToken(new Token(newInstructionLine, type, 49));
                    if (inst instanceof PushConstant) {
                        newInstructionLine.addToken(new Token(newInstructionLine, "" + ((PushConstant)inst).getConstant(), 65));
                    } else if (inst instanceof Invoke) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((Invoke)inst).getJavaMethodName(), 76));
                    } else if (inst instanceof FieldrefContainer) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((FieldrefContainer)((Object)inst)).getFieldref().getName(), 76));
                    } else if (inst instanceof SetLocal) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((SetLocal)inst).getLocalIDName(), 76));
                    } else if (inst instanceof GetLocal) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((GetLocal)inst).getLocalIDName(), 76));
                    } else if (inst instanceof NEW) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((NEW)inst).getClassInstantiated().getSimpleName(), 76));
                    } else if (inst instanceof INSTANCEOF) {
                        newInstructionLine.addToken(new Token(newInstructionLine, ((INSTANCEOF)inst).getClassInfo().getSimpleName(), 76));
                    } else if (inst instanceof Branch) {
                        newInstructionLine.addToken(new Token(newInstructionLine, "" + ((Branch)inst).getTarget().getIndex(), 65));
                    }
                    linesTemp.add(newInstructionLine);
                    TreeSet<Token> tokenSet = new TreeSet<Token>();
                    for (Token t : newInstructionLine.getTokens()) {
                        this.instructionsByToken.put(t, inst);
                        tokenSet.add(t);
                    }
                    this.tokensByInstruction.put(inst, tokenSet);
                    this.lineNumbersByInstruction.put(inst, newInstructionLine.getLineNumber());
                    if (inst.getNumberOfOperandsProduced() == 0) {
                        linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
                    }
                    ++n2;
                }
                linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
                Line rightBrace = new Line(new LineNumber(this, linesTemp.size() + 1), new Token[0]);
                rightBrace.addToken(new Token(newLine, "}", 82));
                linesTemp.add(rightBrace);
            }
            linesTemp.add(Line.createBlankLine(new LineNumber(this, linesTemp.size() + 1)));
        }
        this.lines = new Line[linesTemp.size()];
        linesTemp.toArray(this.lines);
        return this.lines;
    }

    @Override
    public Line getLine(int lineNumber) {
        this.getLines();
        int zeroIndexedLineNumber = lineNumber - 1;
        if (zeroIndexedLineNumber < 0 || zeroIndexedLineNumber >= this.lines.length) {
            return null;
        }
        return this.lines[lineNumber - 1];
    }

    public Line getLine(Instruction inst) {
        assert (inst.getClassfile() == this);
        this.getLines();
        return this.getLine(this.lineNumbersByInstruction.get(inst).getNumber());
    }

    @Override
    public int getNumberOfLines() {
        this.getLines();
        return this.lines.length;
    }

    @Override
    public String getFileName() {
        return String.valueOf(this.getInternalName().getText().replace('/', '.')) + ".class";
    }

    @Override
    public String getShortFileName() {
        return String.valueOf(this.getSimpleName()) + ".class";
    }

    @Override
    public TokenRange getTokenRangeFor(Instruction i) {
        this.getLines();
        SortedSet<Token> tokens = this.tokensByInstruction.get(i);
        if (tokens != null) {
            return new TokenRange(tokens.first(), tokens.last());
        }
        return null;
    }

    @Override
    public TokenRange getTokenRangeForParameter(MethodInfo method, int parameter) {
        this.getLines();
        Token name = this.methodNameTokensByMethod.get(method);
        return new TokenRange(name, name);
    }

    @Override
    public TokenRange getTokenRangeForMethod(MethodInfo method) {
        this.getLines();
        Token name = this.methodNameTokensByMethod.get(method);
        return new TokenRange(name, name);
    }

    @Override
    public TokenRange getTokenRangeFor(Classfile c) {
        return this.getLines()[0].getRange();
    }

    @Override
    public Instruction getInstructionFor(Token t) {
        return this.instructionsByToken.get(t);
    }

    @Override
    public QualifiedClassName getClassnameFor(Token token) {
        return null;
    }

    @Override
    public Parameter getMethodParameterFor(Token token) {
        return null;
    }

    @Override
    public SortedSet<Instruction> getInstructionsOnLine(Line l) {
        return new TreeSet<Instruction>();
    }

    private int getIndexOf(Line line) {
        this.getLines();
        int lineIndex = -1;
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i] == line) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Token getCodeTokenAfter(Token t) {
        line = t.getLine();
        lineIndex = this.getIndexOf(line);
        if (lineIndex >= 0) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            next = line.getTokenAfter(t);
            if (next != null) {
                return next;
            }
            if (lineIndex + 1 >= this.lines.length) {
                return null;
            }
            line = this.lines[++lineIndex];
lbl11:
            // 2 sources

            ** while (line != null)
        }
lbl12:
        // 1 sources

        return null;
    }

    @Override
    public Token getCodeTokenBefore(Token t) {
        return null;
    }

    @Override
    public Token getTokenForMethodName(MethodInfo method) {
        this.getLines();
        return this.methodNameTokensByMethod.get(method);
    }

    @Override
    public boolean isFamiliar() {
        return false;
    }

    public void trim() {
        this.attributes.trimToSize();
        this.fields.trimToSize();
        this.methods.trimToSize();
        for (MethodInfo method : this.methods) {
            method.trimToSize();
        }
    }
}

