/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.Cancelable;
import edu.cmu.hcii.whyline.analysis.ValueSource;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.CHECKCAST;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Computation;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.bytecode.FieldrefInfo;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetArrayValue;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetArrayValue;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.StackManipulation;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.trace.Trace;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueSourceAnalyzer {
    private static int DEBUG = 0;
    private Cancelable cancelable;
    private final Trace trace;
    private final Instruction firstInstruction;
    private final int argumentNumber;
    private final Stack<Instruction> path = new Stack();
    private int loops = 0;
    private int depth = 0;
    private static final HashMap<InstructionTypesPair, Set<ValueSource>> cache = new HashMap();
    private static HashMap<Instruction, Set<SetArrayValue>> elementAssignmentsCache = new HashMap(1000);

    private static void debug(int tabs, String message) {
        if (DEBUG == 0) {
            return;
        }
        int depth = Thread.currentThread().getStackTrace().length - 14;
        int i = 0;
        while (i < depth) {
            System.out.print("   ");
            ++i;
        }
        System.out.print("|");
        i = 0;
        while (i < tabs) {
            System.out.print("   ");
            ++i;
        }
        System.out.println(message);
    }

    public static Set<ValueSource> getPotentialValues(Trace trace, Instruction instruction, int argumentNumber, Cancelable cancelable) {
        return new ValueSourceAnalyzer(trace, instruction, argumentNumber, cancelable).getPotentialValues();
    }

    public static Map<String, Set<ValueSource>> getSourcesByValue(Trace trace, Instruction instruction, int argumentNumber, Cancelable cancelable) {
        Set<ValueSource> vals = new ValueSourceAnalyzer(trace, instruction, argumentNumber, cancelable).getPotentialValues();
        if (cancelable != null && cancelable.wasCanceled()) {
            return null;
        }
        return ValueSourceAnalyzer.sortSources(vals);
    }

    private ValueSourceAnalyzer(Trace trace, Instruction instruction, int argumentNumber, Cancelable cancelable) {
        this.trace = trace;
        this.cancelable = cancelable;
        this.firstInstruction = instruction;
        this.argumentNumber = argumentNumber;
    }

    private boolean wasCanceled(InstructionTypesPair pair) {
        if (this.cancelable != null && this.cancelable.wasCanceled()) {
            if (pair != null) {
                cache.remove(pair);
            }
            return true;
        }
        return false;
    }

    private static void addValueSourceSet(IdentityHashMap<Set<ValueSource>, Object> setsAdded, Set<ValueSource> values, Set<ValueSource> newValues) {
        if (!setsAdded.containsKey(newValues)) {
            setsAdded.put(newValues, null);
            values.addAll(newValues);
        }
    }

    private Set<ValueSource> getPotentialValues() {
        HashSet<ValueSource> all = new HashSet<ValueSource>();
        StackDependencies.Producers producers = this.firstInstruction.getProducersOfArgument(this.argumentNumber);
        int i = 0;
        while (i < producers.getNumberOfProducers()) {
            Instruction producer = producers.getProducer(i);
            if (producer != null) {
                Set<ValueSource> values = this.findValuesProducedBy(producer, new ValueSource(producer.getMethod().isStatic() ? null : producer.getClassfile().getInternalName()));
                if (this.wasCanceled(null)) {
                    return null;
                }
                all.addAll(values);
            }
            ++i;
        }
        return all;
    }

    private Set<ValueSource> findValuesProducedBy(Instruction producer, ValueSource typeOfThis) {
        Object prod;
        if (this.wasCanceled(null)) {
            return null;
        }
        InstructionTypesPair pair = new InstructionTypesPair(producer, typeOfThis);
        if (cache.containsKey(pair)) {
            return cache.get(pair);
        }
        HashSet<ValueSource> values = new HashSet<ValueSource>(3);
        IdentityHashMap<Set<ValueSource>, Object> valueSetsAdded = new IdentityHashMap<Set<ValueSource>, Object>(3);
        cache.put(pair, values);
        if (!(producer instanceof GetLocal)) {
            this.path.push(producer);
        }
        if (producer instanceof PushConstant || producer instanceof Instantiation) {
            values.add(new ValueSource(producer, typeOfThis, this.path));
        } else if (producer instanceof GETFIELD || producer instanceof GETSTATIC) {
            FieldInfo field = this.trace.resolveFieldReference(((FieldrefContainer)((Object)producer)).getFieldref());
            if (field != null) {
                if (producer instanceof GETSTATIC && field.isFinal()) {
                    values.add(new ValueSource(producer, typeOfThis, this.path));
                } else {
                    int arg = producer instanceof GETFIELD ? 1 : 0;
                    for (Definition put : field.getDefinitions()) {
                        this.path.push(put);
                        StackDependencies.Producers producers = put.getProducersOfArgument(arg);
                        int i = 0;
                        while (i < producers.getNumberOfProducers()) {
                            prod = producers.getProducer(i);
                            if (prod != null) {
                                Set<ValueSource> vals = this.findValuesProducedBy((Instruction)prod, typeOfThis);
                                if (this.wasCanceled(pair)) {
                                    return null;
                                }
                                ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                            }
                            ++i;
                        }
                        this.path.pop();
                    }
                }
            }
        } else if (producer instanceof GetLocal) {
            List<SetLocal> assignments = producer.getCode().getLocalDependencies().getPotentialDefinitionsOfGetLocal((GetLocal)producer);
            int localID = ((GetLocal)producer).getLocalID();
            if (producer.getMethod().isVirtual() && localID == 0) {
                values.add(new ValueSource(producer, typeOfThis, this.path));
            } else if (assignments.isEmpty() && localID < producer.getMethod().getLocalIDOfFirstNonArgument()) {
                int argumentNumber = producer.getMethod().getArgumentNumberOfLocalID(((GetLocal)producer).getLocalID());
                Set<Invoke> callers = producer.getMethod().getPreciseCallers(this.trace, this.cancelable);
                if (this.wasCanceled(pair)) {
                    return null;
                }
                Classfile classfile = typeOfThis.type == null ? null : this.trace.getClassfileByName(typeOfThis.type);
                for (Invoke caller : callers) {
                    if (!caller.couldCallOn(typeOfThis, this.trace)) continue;
                    StackDependencies.Producers producers2 = caller.getProducersOfArgument(argumentNumber);
                    int i = 0;
                    while (i < producers2.getNumberOfProducers()) {
                        Instruction prod2 = producers2.getProducer(i);
                        if (prod2 != null) {
                            Set<ValueSource> vals = this.findValuesProducedBy(prod2, new ValueSource(caller.getClassfile().getInternalName()));
                            if (this.wasCanceled(pair)) {
                                return null;
                            }
                            ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                        }
                        ++i;
                    }
                }
                if (values.isEmpty()) {
                    values.add(new ValueSource(producer, typeOfThis, this.path));
                }
            } else {
                for (SetLocal assignment2 : assignments) {
                    this.path.push(assignment2);
                    StackDependencies.Producers producers = assignment2.getProducersOfArgument(0);
                    int i = 0;
                    while (i < producers.getNumberOfProducers()) {
                        prod = producers.getProducer(i);
                        if (prod != null) {
                            Set<ValueSource> vals = this.findValuesProducedBy((Instruction)prod, typeOfThis);
                            if (this.wasCanceled(pair)) {
                                return null;
                            }
                            ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                        }
                        ++i;
                    }
                    this.path.pop();
                }
            }
        } else if (producer instanceof GetArrayValue) {
            Set<ValueSource> arrayValues = new ValueSourceAnalyzer(this.trace, producer, 0, this.cancelable).getPotentialValues();
            if (this.wasCanceled(pair)) {
                return null;
            }
            for (ValueSource arrayValue : arrayValues) {
                Set<SetArrayValue> assignments = this.gatherElementAssignments(arrayValue.instruction);
                if (this.wasCanceled(pair)) {
                    return null;
                }
                if (assignments == null) continue;
                for (SetArrayValue setArrayValue : assignments) {
                    StackDependencies.Producers producers3 = setArrayValue.getProducersOfArgument(2);
                    int i = 0;
                    while (i < producers3.getNumberOfProducers()) {
                        Instruction prod3 = producers3.getProducer(i);
                        if (prod3 != null) {
                            Set<ValueSource> vals = this.findValuesProducedBy(prod3, arrayValue.typeProducedIn);
                            if (this.wasCanceled(pair)) {
                                return null;
                            }
                            ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                        }
                        ++i;
                    }
                }
            }
        } else if (producer instanceof Invoke) {
            MethodInfo[] methods = ((Invoke)producer).getPreciseMethodsCalled(this.trace, this.cancelable);
            if (this.wasCanceled(pair)) {
                return null;
            }
            if (methods.length == 0) {
                values.add(new ValueSource(producer, typeOfThis, this.path));
            } else {
                MethodInfo[] methodInfoArray = methods;
                int assignments = methods.length;
                int assignment2 = 0;
                while (assignment2 < assignments) {
                    MethodInfo method = methodInfoArray[assignment2];
                    ValueSource value = ((Invoke)producer).getPotentialValueFor(method);
                    if (value == null) {
                        value = method.isStatic() ? new ValueSource(QualifiedClassName.NULL) : new ValueSource(method.getClassfile().getInternalName());
                    }
                    for (AbstractReturn ret : method.getReturns()) {
                        this.path.push(ret);
                        StackDependencies.Producers producers4 = ret.getProducersOfArgument(0);
                        int i = 0;
                        while (i < producers4.getNumberOfProducers()) {
                            Instruction prod4 = producers4.getProducer(i);
                            if (prod4 != null) {
                                Set<ValueSource> vals = this.findValuesProducedBy(prod4, value);
                                if (this.wasCanceled(pair)) {
                                    return null;
                                }
                                ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                            }
                            ++i;
                        }
                        this.path.pop();
                    }
                    ++assignment2;
                }
            }
        } else if (producer instanceof StackManipulation) {
            StackDependencies.Producers producers5 = producer.getProducersOfArgument(0);
            int i = 0;
            while (i < producers5.getNumberOfProducers()) {
                Instruction prod5 = producers5.getProducer(i);
                if (prod5 != null) {
                    Set<ValueSource> vals = this.findValuesProducedBy(prod5, typeOfThis);
                    if (this.wasCanceled(pair)) {
                        return null;
                    }
                    ValueSourceAnalyzer.addValueSourceSet(valueSetsAdded, values, vals);
                }
                ++i;
            }
        } else if (producer instanceof Computation) {
            values.add(new ValueSource(producer, typeOfThis, this.path));
        } else assert (false) : "We should have never made it here with " + producer;
        if (producer.getNext() instanceof CHECKCAST) {
            QualifiedClassName cast = ((CHECKCAST)producer.getNext()).getTypeCast();
            Classfile castClassfile = this.trace.getClassfileByName(cast);
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                ValueSource value = (ValueSource)iterator.next();
                boolean bl2 = false;
                boolean castOkay = false;
                if (value.type != null) {
                    if (value.type == cast) {
                        castOkay = true;
                    } else {
                        Classfile typeClassfile = this.trace.getClassfileByName(value.type);
                        if (castClassfile == null) {
                            castOkay = true;
                        } else if (castClassfile.isExtendsOrImplements(value.type)) {
                            castOkay = true;
                            bl = true;
                        }
                        if (typeClassfile == null) {
                            castOkay = true;
                        } else if (typeClassfile.isExtendsOrImplements(cast)) {
                            castOkay = true;
                        }
                    }
                }
                if (bl) {
                    value.type = cast;
                }
                if (castOkay) continue;
                iterator.remove();
            }
        }
        if (!(producer instanceof GetLocal)) {
            this.path.pop();
        }
        return values;
    }

    private Set<SetArrayValue> gatherElementAssignments(Instruction arrayProducer) {
        Set<SetArrayValue> assignments = elementAssignmentsCache.get(arrayProducer);
        if (assignments != null) {
            return assignments;
        }
        assignments = new HashSet<SetArrayValue>(2);
        elementAssignmentsCache.put(arrayProducer, assignments);
        if (arrayProducer instanceof PushConstant) {
            return null;
        }
        TLongHashSet visited = new TLongHashSet();
        ArrayList<Instruction> instructionsToVisit = new ArrayList<Instruction>();
        ArrayList<Instruction> newInstructionsToVisit = new ArrayList<Instruction>();
        instructionsToVisit.add(arrayProducer);
        while (instructionsToVisit.size() > 0) {
            for (Instruction instructionToVisit : instructionsToVisit) {
                if (this.wasCanceled(null)) {
                    elementAssignmentsCache.remove(arrayProducer);
                    return null;
                }
                long id = System.identityHashCode(instructionToVisit);
                if (visited.contains(id)) continue;
                visited.add(id);
                for (Instruction consumer : instructionToVisit.getConsumers()) {
                    if (consumer instanceof SetArrayValue) {
                        if (consumer.getArgumentNumberOfProducer(instructionToVisit) != 0) continue;
                        assignments.add((SetArrayValue)consumer);
                        continue;
                    }
                    if (consumer instanceof SetLocal) {
                        for (Use use : consumer.getCode().getLocalDependencies().getPotentialUsesOfLocalIDAtOrAfter(consumer, ((SetLocal)consumer).getLocalID())) {
                            newInstructionsToVisit.add(use);
                        }
                        continue;
                    }
                    if (consumer instanceof PUTFIELD || consumer instanceof PUTSTATIC) {
                        FieldInfo fieldInfo = this.trace.resolveFieldReference(((FieldrefContainer)((Object)consumer)).getFieldref());
                        if (fieldInfo == null) continue;
                        for (Use use : fieldInfo.getUses()) {
                            newInstructionsToVisit.add(use);
                        }
                        continue;
                    }
                    if (consumer instanceof Invoke) {
                        MethodInfo[] methodInfoArray = ((Invoke)consumer).getPreciseMethodsCalled(this.trace, this.cancelable);
                        if (this.wasCanceled(null)) {
                            elementAssignmentsCache.remove(arrayProducer);
                            return null;
                        }
                        MethodInfo[] methodInfoArray2 = methodInfoArray;
                        int n = methodInfoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MethodInfo method = methodInfoArray2[n2];
                            if (method.getCode() != null) {
                                for (Use use : method.getCode().getLocalDependencies().getPotentialUsesOfArgument(consumer.getArgumentNumberOfProducer(instructionToVisit))) {
                                    newInstructionsToVisit.add(use);
                                }
                            }
                            ++n2;
                        }
                        continue;
                    }
                    if (!(consumer instanceof AbstractReturn)) continue;
                    Set<Invoke> set = consumer.getMethod().getPreciseCallers(this.trace, this.cancelable);
                    if (this.wasCanceled(null)) {
                        elementAssignmentsCache.remove(arrayProducer);
                        return null;
                    }
                    for (Invoke caller : set) {
                        newInstructionsToVisit.add(caller);
                    }
                }
            }
            instructionsToVisit.clear();
            ArrayList<Instruction> temp = newInstructionsToVisit;
            newInstructionsToVisit = instructionsToVisit;
            instructionsToVisit = temp;
        }
        return assignments;
    }

    private static Map<String, Set<ValueSource>> sortSources(Set<ValueSource> values) {
        Hashtable<String, Set<ValueSource>> sourcesByValue = new Hashtable<String, Set<ValueSource>>(values.size());
        for (ValueSource value : values) {
            Instruction source = value.instruction;
            if (source instanceof PushConstant) {
                String valueLabel = "" + ((PushConstant)source).getConstant();
                ValueSourceAnalyzer.getSortSet(valueLabel, sourcesByValue).add(value);
                continue;
            }
            if (source instanceof GETSTATIC) {
                FieldrefInfo field = ((GETSTATIC)source).getFieldref();
                String valueLabel = field.getClassname().getSimpleName() + "." + field.getName();
                ValueSourceAnalyzer.getSortSet(valueLabel, sourcesByValue).add(value);
                continue;
            }
            ValueSourceAnalyzer.getSortSet("", sourcesByValue).add(value);
        }
        return sourcesByValue;
    }

    private static Set<ValueSource> getSortSet(String value, Map<String, Set<ValueSource>> table) {
        Set<ValueSource> set = table.get(value);
        if (set == null) {
            set = new HashSet<ValueSource>();
            table.put(value, set);
        }
        return set;
    }

    private static class InstructionTypesPair {
        private final Instruction inst;
        private final ValueSource potentialValue;

        public InstructionTypesPair(Instruction inst, ValueSource potentialValue) {
            this.inst = inst;
            this.potentialValue = potentialValue;
            assert (inst != null);
        }

        public int hashCode() {
            return this.inst.hashCode() + (this.potentialValue.type == null ? 0 : this.potentialValue.type.hashCode());
        }

        public boolean equals(Object o) {
            return o instanceof InstructionTypesPair && ((InstructionTypesPair)o).inst == this.inst && ((InstructionTypesPair)o).potentialValue.equals(this.potentialValue);
        }
    }
}

