/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.ALOAD_0;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Computation;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetArrayValue;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.trace.Trace;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueSource {
    public final Instruction instruction;
    public final ValueSource typeProducedIn;
    public QualifiedClassName type;
    public final ArrayList<Instruction> path;
    private int isEncapsulatedbyProducingClass = -1;

    public ValueSource(QualifiedClassName type) {
        if (type != null) {
            this.type = type;
        }
        this.instruction = null;
        this.typeProducedIn = null;
        this.path = new ArrayList(0);
    }

    public ValueSource(Instruction inst, ValueSource typeProducedIn, Iterable<Instruction> path) {
        this.instruction = inst;
        this.typeProducedIn = typeProducedIn;
        this.path = new ArrayList();
        for (Instruction i : path) {
            this.path.add(i);
        }
        this.path.trimToSize();
        if (this.instruction instanceof PushConstant) {
            Object constant = ((PushConstant)this.instruction).getConstant();
            if (constant == null) {
                this.type = QualifiedClassName.NULL;
            } else if (constant instanceof QualifiedClassName) {
                this.type = QualifiedClassName.JAVA_LANG_CLASS;
            } else if (constant instanceof String) {
                this.type = QualifiedClassName.JAVA_LANG_STRING;
            }
        } else if (this.instruction instanceof Instantiation) {
            this.type = ((Instantiation)this.instruction).getClassnameOfTypeProduced();
        } else if (this.instruction instanceof GETSTATIC) {
            String typeDescriptor = ((GETSTATIC)this.instruction).getFieldref().getTypeDescriptor();
            if (typeDescriptor.charAt(0) == 'L') {
                typeDescriptor = typeDescriptor.substring(1, typeDescriptor.length() - 1);
            }
            this.type = QualifiedClassName.get(typeDescriptor);
        } else if (this.instruction instanceof GetLocal) {
            if (this.instruction instanceof ALOAD_0 && !this.instruction.getMethod().isStatic()) {
                this.type = this.instruction.getClassfile().getInternalName();
            } else if (((GetLocal)this.instruction).getLocalID() < this.instruction.getMethod().getLocalIDOfFirstNonArgument()) {
                QualifiedClassName typeName;
                MethodInfo methodOfValue = this.instruction.getMethod();
                int argumentNumber = methodOfValue.getParsedDescriptor().getArgumentNumberFromLocalID(((GetLocal)this.instruction).getLocalID());
                this.type = typeName = methodOfValue.getParsedDescriptor().getTypeOfArgumentNumber(methodOfValue.isStatic() ? argumentNumber : argumentNumber - 1);
            } else {
                List<ExceptionHandler> handlers = this.instruction.getCode().getExceptionHandlersThatExecute(this.instruction);
                for (ExceptionHandler handler : handlers) {
                    QualifiedClassName qualifiedClassName = this.type = handler.getCatchType() == null ? QualifiedClassName.JAVA_LANG_THROWABLE : handler.getCatchType().getName();
                }
            }
        } else if (!(this.instruction instanceof Computation)) {
            if (this.instruction instanceof Invoke) {
                this.type = ((Invoke)this.instruction).getMethodInvoked().getParsedDescriptor().getReturnType();
            } else assert (false) : "How did " + this.instruction + " end up producing a potential value for something?";
        }
    }

    public boolean isEncapsulatedByProducingClass(Trace trace) {
        if (this.instruction == null) {
            return false;
        }
        if (this.instruction instanceof ALOAD_0) {
            return false;
        }
        if (this.isEncapsulatedbyProducingClass == -1) {
            int n = this.isEncapsulatedbyProducingClass = this.isEncapsulatedHelper(new HashSet<Instruction>(), null, this.instruction, trace) ? 1 : 0;
        }
        return this.isEncapsulatedbyProducingClass == 1;
    }

    private boolean isEncapsulatedHelper(Set<Instruction> visited, Instruction producer, Instruction consumer, Trace trace) {
        block16: {
            block15: {
                if (visited.contains(consumer)) {
                    return false;
                }
                visited.add(consumer);
                if (!(consumer instanceof PUTFIELD)) break block15;
                FieldInfo fieldInfo = trace.resolveFieldReference(((PUTFIELD)consumer).getFieldref());
                if (fieldInfo == null) break block16;
                for (Use fieldUser : fieldInfo.getUses()) {
                    for (Instruction fieldUserConsumer : fieldUser.getConsumers()) {
                        if (this.isEncapsulatedHelper(visited, fieldUser, fieldUserConsumer, trace)) continue;
                        return false;
                    }
                }
                break block16;
            }
            if (consumer instanceof SetLocal) {
                for (Use use : consumer.getCode().getLocalDependencies().getPotentialUsesOfLocalIDAtOrAfter(consumer, ((SetLocal)consumer).getLocalID())) {
                    for (Instruction useConsumer : use.getConsumers()) {
                        if (this.isEncapsulatedHelper(visited, use, useConsumer, trace)) continue;
                        return false;
                    }
                }
            } else if (consumer instanceof Invoke) {
                int n = consumer.getArgumentNumberOfProducer(producer);
                if (((Invoke)consumer).getMethodInvoked().isStatic()) {
                    return false;
                }
                if (n != 0) {
                    return false;
                }
            } else {
                if (consumer instanceof AbstractReturn) {
                    return false;
                }
                if (consumer instanceof SetArrayValue) {
                    return false;
                }
                if (consumer instanceof PUTSTATIC) {
                    return false;
                }
                for (Instruction instruction : consumer.getConsumers()) {
                    if (this.isEncapsulatedHelper(visited, consumer, instruction, trace)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ValueSource)) {
            return false;
        }
        ValueSource other = (ValueSource)o;
        if (other.instruction != this.instruction) {
            return false;
        }
        if (other.type != this.type) {
            return false;
        }
        if (other.typeProducedIn == null && this.typeProducedIn == null) {
            return true;
        }
        if (other.typeProducedIn != null && this.typeProducedIn == null) {
            return false;
        }
        if (other.typeProducedIn == null && this.typeProducedIn != null) {
            return false;
        }
        return other.typeProducedIn.equals(this.typeProducedIn);
    }

    public String toString() {
        return this.type + (this.typeProducedIn == null ? "" : " produced in " + this.typeProducedIn) + " by " + this.instruction;
    }
}

