/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.MethodDependencyGraph;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.PersistentState;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.LineHover;
import edu.cmu.hcii.whyline.ui.events.NoLineHover;
import edu.cmu.hcii.whyline.ui.events.UIEventKind;
import edu.cmu.hcii.whyline.util.IntegerVector;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Usage {
    private final Trace trace;
    private final ArrayList<AbstractUIEvent<?>> events = new ArrayList(100);
    private SortedMap<String, TObjectIntHashMap<String>> methodTimes = new TreeMap<String, TObjectIntHashMap<String>>();
    private SortedSet<String> methodNames = new TreeSet<String>();
    private Map<String, List<Visit>> visitsByKey = new HashMap<String, List<Visit>>();
    private final TObjectIntHashMap<String> distances;

    public Usage(Trace trace, File folder, MethodInfo buggyMethod) throws IOException {
        this.trace = trace;
        MethodDependencyGraph graph = new MethodDependencyGraph(trace);
        this.distances = graph.getMethodDistancesToMethod(buggyMethod);
        this.generateUsageStatistics(folder);
    }

    private int median(IntegerVector distances) {
        distances.sortInAscendingOrder();
        int size = distances.size();
        int median = size % 2 == 0 ? (distances.get((size - 1) / 2) + distances.get((size - 1) / 2 + 1)) / 2 : distances.get(size / 2);
        return median;
    }

    private void generateUsageStatistics(File folder) throws IOException {
        File[] logs = folder.listFiles();
        try {
            File[] fileArray = logs;
            int n = logs.length;
            int n2 = 0;
            while (n2 < n) {
                File log = fileArray[n2];
                if (log.isFile()) {
                    this.analyzeUsageLog(log);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileWriter series = new FileWriter(new File(folder, "series.csv"));
        series.write("id");
        int i = 0;
        while (i < 30) {
            series.write("," + String.valueOf(i));
            ++i;
        }
        series.write(10);
        for (String key : this.methodTimes.keySet()) {
            series.write(key);
            List<Visit> visits = this.visitsByKey.get(key);
            double[] averageDistanceEachMinute = this.computeAggregateDistanceByMinute(visits);
            int i2 = 0;
            while (i2 < averageDistanceEachMinute.length) {
                double averageDistanceInMinute = averageDistanceEachMinute[i2];
                series.write("," + (averageDistanceInMinute < 0.0 ? "" : Double.valueOf(averageDistanceInMinute)));
                ++i2;
            }
            series.write(10);
        }
        series.close();
        FileWriter writer = new FileWriter(new File(folder, "results.csv"));
        writer.write("id");
        writer.write(",min");
        writer.write(",median");
        writer.write(",median10");
        for (String method : this.methodNames) {
            String distance = this.distances.containsKey(method) ? String.valueOf(this.distances.get(method)) : "?";
            writer.write("," + method + "(" + distance + ")");
        }
        writer.write(10);
        for (String key : this.methodTimes.keySet()) {
            writer.write(key);
            List<Visit> visits = this.visitsByKey.get(key);
            long lastTime = -1L;
            for (Visit visit : visits) {
                if (visit.events.size() <= 0) continue;
                lastTime = ((AbstractUIEvent)visit.events.get(visit.events.size() - 1)).getTime();
            }
            long endThreshold = 300000L;
            HashSet<String> methodsVisitedInLastTenMinutes = new HashSet<String>();
            for (Visit visit : visits) {
                if (visit.events.size() <= 0 || lastTime - ((AbstractUIEvent)visit.events.get(0)).getTime() >= endThreshold) continue;
                methodsVisitedInLastTenMinutes.add(visit.method.getQualifiedNameAndDescriptor());
            }
            TObjectIntHashMap times = (TObjectIntHashMap)this.methodTimes.get(key);
            int min = Integer.MAX_VALUE;
            IntegerVector orderedDistances = new IntegerVector(this.methodNames.size());
            IntegerVector orderedDistancesInLastTenMinutes = new IntegerVector(this.methodNames.size());
            for (String method : this.methodNames) {
                if (!this.distances.containsKey(method) || times.get(method) <= 0) continue;
                int distance = this.distances.get(method);
                min = Math.min(min, distance);
                orderedDistances.append(distance);
                if (!methodsVisitedInLastTenMinutes.contains(method)) continue;
                orderedDistancesInLastTenMinutes.append(distance);
            }
            int median = orderedDistances.size() == 0 ? -1 : this.median(orderedDistances);
            int median10 = orderedDistancesInLastTenMinutes.size() == 0 ? -1 : this.median(orderedDistancesInLastTenMinutes);
            writer.write("," + min + "," + median + "," + median10);
            for (String method : this.methodNames) {
                writer.write(",");
                writer.write(String.valueOf(times.get(method)));
            }
            writer.write(10);
        }
        writer.close();
    }

    private double[] computeAggregateDistanceByMinute(List<Visit> visits) {
        long firstTime = -1L;
        long lastTime = -1L;
        for (Visit visit : visits) {
            if (visit.events.size() <= 0) continue;
            if (firstTime < 0L) {
                firstTime = ((AbstractUIEvent)visit.events.get(0)).getTime();
            }
            lastTime = ((AbstractUIEvent)visit.events.get(visit.events.size() - 1)).getTime();
        }
        int minutes = Math.min(30, (int)(lastTime - firstTime) / 60000 + 1);
        double[] averageDistances = new double[Math.max(minutes, 30)];
        Arrays.fill(averageDistances, -1.0);
        double lastAverage = -1.0;
        double lastMin = -1.0;
        double minDistance = -1.0;
        int index = 0;
        while (index < minutes) {
            double totalDistance = 0.0;
            double totalVisits = 0.0;
            for (Visit visit : visits) {
                if (!visit.contains((long)(index * 1000 * 60) + firstTime) || !this.distances.containsKey(visit.method.getQualifiedNameAndDescriptor())) continue;
                int distance = this.distances.get(visit.method.getQualifiedNameAndDescriptor());
                totalDistance += (double)distance;
                totalVisits += 1.0;
                minDistance = minDistance < 0.0 ? (double)distance : Math.min(minDistance, (double)distance);
            }
            lastMin = minDistance;
            if (totalVisits > 0.0) {
                lastAverage = totalDistance / totalVisits;
            }
            averageDistances[index] = lastMin;
            ++index;
        }
        return averageDistances;
    }

    private void analyzeUsageLog(File log) throws IOException {
        String key = log.getName();
        if (!log.getName().endsWith(".log")) {
            System.err.println("Skipping " + log.getName());
            return;
        }
        System.err.println("Reading  " + log.getName() + "\n");
        PersistentState state = new PersistentState(null, this.trace, log);
        ArrayList events = new ArrayList();
        int count = 0;
        for (String entry : state.getLog()) {
            UIEventKind kind;
            String[] args = entry.split(":");
            if (args.length > 0 && (kind = UIEventKind.fromType(args[0])) != null) {
                AbstractUIEvent<?> event = kind.create(this.trace, args);
                events.add(event);
            }
            ++count;
        }
        TObjectIntHashMap<String> times = new TObjectIntHashMap<String>();
        long lastTime = ((AbstractUIEvent)events.get(events.size() - 1)).getTime();
        IntegerVector distanceHistory = new IntegerVector(events.size());
        MethodInfo lastMethodVisited = null;
        boolean distanceSumInLastMinute = false;
        boolean visitCountInLastMinute = false;
        long lastMinute = ((AbstractUIEvent)events.get(0)).getTime();
        int distanceAggregationPeriod = 3000;
        Visit visit = null;
        ArrayList<Visit> visits = new ArrayList<Visit>();
        AbstractUIEvent lastLineEvent = null;
        for (AbstractUIEvent abstractUIEvent : events) {
            if (!(abstractUIEvent instanceof LineHover) && !(abstractUIEvent instanceof NoLineHover)) continue;
            if (lastLineEvent != null) {
                MethodInfo method;
                int time = (int)(abstractUIEvent.getTime() - lastLineEvent.getTime());
                Line line = (Line)lastLineEvent.getEntity();
                if (line != null && line.getFile() instanceof JavaSourceFile && (method = ((JavaSourceFile)line.getFile()).getMethodOfLine(line)) != null) {
                    if (visit != null) {
                        visit.include(abstractUIEvent);
                    }
                    if (visit == null || method != lastMethodVisited) {
                        visit = new Visit(method);
                        visits.add(visit);
                    }
                    lastMethodVisited = method;
                    String name = method.getQualifiedNameAndDescriptor();
                    this.methodNames.add(name);
                    int total = times.containsKey(key) ? times.get(key) : 0;
                    times.put(name, total + time);
                }
            }
            AbstractUIEvent abstractUIEvent2 = lastLineEvent = abstractUIEvent instanceof LineHover ? (LineHover)abstractUIEvent : null;
        }
        this.visitsByKey.put(key, visits);
        this.methodTimes.put(key, times);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Visit {
        private final MethodInfo method;
        private final ArrayList<AbstractUIEvent<?>> events = new ArrayList();

        public Visit(MethodInfo method) {
            this.method = method;
        }

        public void include(AbstractUIEvent<?> event) {
            this.events.add(event);
        }

        public boolean contains(long l) {
            if (this.events.isEmpty()) {
                return false;
            }
            long min = this.events.get(0).getTime();
            long max = this.events.get(this.events.size() - 1).getTime();
            return min <= l && max >= l;
        }

        public String toString() {
            return "visited " + this.method.getQualifiedNameAndDescriptor();
        }
    }
}

