/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reachability {
    public static boolean canClassReachInstruction(Classfile classfile, Instruction instruction) {
        return Reachability.canClassReachInstruction(classfile, instruction, new HashSet<Instruction>());
    }

    private static boolean canClassReachInstruction(Classfile classfile, Instruction instruction, Set<Instruction> instructionsInspected) {
        if (instructionsInspected.contains(instruction)) {
            return false;
        }
        instructionsInspected.add(instruction);
        if (instruction.getClassfile() == classfile || instruction.getClassfile().isSuperclassOf(classfile)) {
            return true;
        }
        for (Invoke invoke : instruction.getMethod().getPotentialCallers()) {
            if (!Reachability.canClassReachInstruction(classfile, invoke, instructionsInspected)) continue;
            return true;
        }
        return false;
    }
}

