/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.Decision;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.trace.Trace;
import java.util.Vector;

public final class LoopPath {
    private final Vector<Decision> decisions = new Vector();

    public LoopPath() {
    }

    public LoopPath(LoopPath path, Branch branch, Instruction target) {
        for (Decision dec : path.decisions) {
            this.decisions.add(dec);
        }
        this.addDecision(branch, target);
    }

    public void addDecision(Branch branch, Instruction target) {
        this.decisions.add(new Decision(branch, target));
    }

    public boolean matches(Trace trace, int eventID) {
        int nextEvent = eventID;
        for (Decision dec : this.decisions) {
            Instruction target = dec.target;
            int targetEvent = trace.findEventInMethodInThreadAfter(nextEvent, target);
            if (targetEvent < 0) {
                return false;
            }
            nextEvent = targetEvent;
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (Decision dec : this.decisions) {
            s = String.valueOf(s) + dec + "\n";
        }
        return s;
    }
}

