/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOverriders
implements SearchResultsInterface {
    private final MethodInfo method;
    private final WhylineUI whylineUI;
    private final SortedSet<Token> overriders = new TreeSet<Token>();

    public FindOverriders(WhylineUI whylineUI, MethodInfo method) {
        this.whylineUI = whylineUI;
        this.method = method;
        for (MethodInfo m : method.getOverriders()) {
            JavaSourceFile source = m.getClassfile().getSourceFile();
            if (source == null) continue;
            Line line = source.getTokenForMethodName(m).getLine();
            this.overriders.addAll(line.getTokensAfterFirstNonWhitespaceToken());
        }
    }

    @Override
    public String getResultsDescription() {
        return "overriders of " + this.method.getInternalName();
    }

    @Override
    public String getCurrentStatus() {
        return "Done.";
    }

    @Override
    public SortedSet<Token> getResults() {
        return this.overriders;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

