/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUsesSearch
implements SearchResultsInterface {
    private final WhylineUI whylineUI;
    private final Classfile classfile;

    public ClassUsesSearch(WhylineUI whylineUI, Classfile classfile) {
        this.whylineUI = whylineUI;
        this.classfile = classfile;
    }

    @Override
    public String getCurrentStatus() {
        return "Done.";
    }

    @Override
    public SortedSet<Token> getResults() {
        TreeSet<Token> tokens = new TreeSet<Token>();
        Trace trace = this.whylineUI.getTrace();
        List<Instantiation> instantiations = trace.getInstantiationsOf(this.classfile.getInternalName());
        for (Instantiation inst : instantiations) {
            tokens.addAll(inst.getLine().getTokens());
        }
        for (Invoke invoke : trace.getInvocations()) {
            Line line;
            if (!(invoke instanceof INVOKESTATIC) || invoke.getMethodInvoked().getClassName() != this.classfile.getInternalName() || (line = invoke.getLine()) == null) continue;
            tokens.addAll(line.getTokens());
        }
        for (Classfile c : trace.getClasses()) {
            JavaSourceFile source = c.getSourceFile();
            if (source == null) continue;
            for (MethodInfo m : c.getDeclaredMethods()) {
                TokenRange returnTokens;
                if (m.getParsedDescriptor().getReturnType() != this.classfile.getInternalName() || (returnTokens = source.getTokenRangeForReturnType(m)) == null) continue;
                tokens.add(returnTokens.first);
            }
            for (FieldInfo f : c.getDeclaredFields()) {
                TokenRange fieldTypeRange;
                if (f.getTypeName() != this.classfile.getInternalName() || (fieldTypeRange = source.getTokenRangeForField(f)) == null) continue;
                tokens.add(fieldTypeRange.first);
            }
        }
        return tokens;
    }

    @Override
    public String getResultsDescription() {
        return "uses of " + this.classfile.getSimpleName();
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

