format compact;

tic; %start timer

%inputs

reordering %can only be false for pure STTK
pharaoh %0 (pure STTK), 1 (pure pharaoh), or 2 (STTK with pharaoh phrase table)
maptraining %0 (MBR), 1 (SUM-MAP), or 2 (MAX-MAP)
if pharaoh ~= 0 && ~reordering
    error('reordering must be on for using pharaoh or STTK with pharaoh phrases');
end

%[a b] = theta_range(dimension,:) defines range [a-gridsize/2,b+gridsize/2) of respective parameter space dimension

if pharaoh == 1 %real pharaoh
  disp('constant parameter: PTMScale1=1');
  theta_names = {'PDLScale','PLMScale','PTMScale2','PTMScale3','PTMScale4','PTMScale5','PWLScale'}
  theta_range = [-2 2; 0 2; -2 2 ; -2 2 ; -2 2; -2 2; -2 2]
  gridsize = .5
elseif pharaoh == 2 %pharaoh and STTK
  disp('no constant parameter');
  theta_names = {  'TMScale','LMScale','ALScale','SLScale','PTMScale1', 'PTMScale2','PTMScale3','PTMScale4'  }
  theta_range = [-2 2         ; 0 2    ; -2 2     ; -4.5 2.5    ; 0 2; 0 2; 0 2; 0 2]
  gridsize = .5
elseif reordering %standard STTK with reordering
  theta_names = {'LMScale','ALScale','SLScale'}
  theta_range = [1 6 ; 0 1 ; -2 2]
  gridsize = .1
else %standard STTK without reordering
  theta_names = {'LMScale','SLScale'}
  theta_range = [1 5  ; -2 2]
  gridsize = .1
end

  %theta_range = [-5 5  ; -5 5] %!!
  %gridsize = .5; %!!


theta_dim = length(theta_names);
Sigma = diag(gridsize^2*ones(1, theta_dim)); %covariance matrix for multivariate-normal proximity determination


%theta_start = [2.5,1];
n_o_iterations = 150;
spread_factor = 1;
%gridsizes = [.2 .2 .2];



%start of prog

commandstr = 'rm *.lossfile *.global';
disp(commandstr);
[exit_code,mbr_output] = unix(commandstr, '-echo');
%    if (exit_code > 0)
%        error('Exit code >0 when running MBR');
%    end

    
best_score = -inf;
best_theta = zeros(1,theta_dim);
best_commandstr = '???';
best_thetastr = '???';
commandstr = '';
thetastr = '';
score = zeros(0,1); %row vector of scores of each iterations
mapscore = zeros(0,1); %row vector of scores of each iterations
mapmaxscore = zeros(0,1); %row vector of scores of each iterations
mbrscore = zeros(0,1); %row vector of scores of each iterations
theta = zeros(0,theta_dim); %each row is a parameter vector

%create pivot grid


%theta = [0.2 10.2; 1.2 10.8; 1.2 10; 0.4 10.9];
%score = (theta(:,1) .* theta(:,2))';

%XI = meshgridn(pivots{1}(1):.1:pivots{1}(end),pivots{2}(1):.1:pivots{2}(end));

XI_cell = cell(1,theta_dim);
theta_steps = cell(1,theta_dim);
for i = 1:theta_dim
    theta_steps{i} = theta_range(i,1):gridsize:theta_range(i,2);
end
[XI_cell{1:end}] = ndgrid(theta_steps{:});

X = zeros(prod(size(XI_cell{1})),theta_dim);
for i = 1:theta_dim
    X(:,i) = reshape(XI_cell{i},prod(size(XI_cell{1})),1);
end

%starting pdf
pdf = ones(1,size(X,1)) / size(X,1);
score_estimates = zeros(2,size(X,1)); % first row contains the sum of score-values for the grid points, 
                                      % the second row the (pseudo) number of score evaluations in the respective grid points
%score_estimates(2,:) = score_estimates(2,:) + realmin; % just in order to avoid division by zero later





for it=1:min(n_o_iterations,size(X,1))
  disp(    sprintf('     (starting iteration %g)',it )); 

    %    if it==1
    %        %starting parameters
    %        theta(1,:) = theta_start;
    %    else
    %         sample_ranges = zeros(2,theta_dim);
    %         for i = 1:theta_dim
    %             sample_pivot_index = multinomialrand(pdf{i});
    %             sample_ranges(:,i) = [ pivots{i}(sample_pivot_index) ; pivots{i}(sample_pivot_index)+2 ];
    %         end
    %         theta(end+1,:) = sample_ranges(1,:) + rand(1,theta_dim) .* (sample_ranges(2,:)-sample_ranges(1,:));
    %   end

    draw = X(multinomialrand(pdf),:);
    %while length(find(sum(abs(ones(size(theta,1),1)*draw-theta),2)==0)) > 0  %if we have drawn this point before, draw again
    %   draw = X(multinomialrand(pdf),:);
    %end
    theta(end+1,:) = draw - gridsize/2 + rand(1,theta_dim) * gridsize;
    
     
     
     
     
    %now call MBR rescoring with parameter vector theta(end)
    if pharaoh == 1 %pure pharaoh
        commandstr = sprintf(['/nfs/dish2/ashishv/FromProgress/Latest/' ...
            'STTK2K4/bin/MBRFast --System=Pharaoh --GlobalScoring=1' ...
            ' --DuplicateMode=2 --NBestFile=%s --NBestCands=%s' ...
            ' --NumModelScores=8 --ScoringMetric=IBMBLEU' ... %!!! NumModelScores was set to 4 till May 11 2005!! (hopefully didn't matter...)
            ' --EndianSwap=0 --PDLScale=%g --PLMScale=%g' ...
            ' --PTMScale1=1 --PTMScale2=%g --PTMScale3=%g' ...
            ' --PTMScale4=%g --PTMScale5=%g --PWLScale=%g --DrawSize=20 | grep ''TransScore'''],feats_file,cands_file,theta(end,1),theta(end,2),theta(end,3),theta(end,4),theta(end,5),theta(end,6),theta(end,7));
        thetastr = '???';
    elseif pharaoh == 2 %STTK with pharaoh phrases
        commandstr = sprintf(['/nfs/dish2/ashishv/FromProgress/Latest/' ...
            'STTK2K4/bin/MBRFast --System=STTK --GlobalScoring=1' ...
            ' --DuplicateMode=2 --NBestFile=%s --NBestCands=%s' ...
            ' --NumModelScores=8 --ScoringMetric=IBMBLEU' ...
            ' --EndianSwap=0 --DrawSize=20'],feats_file,cands_file);
        thetastr = '';
        for itmp = 1:theta_dim
               commandstr = [commandstr ' --' theta_names{itmp} '=' sprintf('%g',theta(end,itmp)) ];
               thetastr = [thetastr theta_names{itmp} ' ' sprintf('%g',theta(end,itmp)) '\n'];
        end
        commandstr = [commandstr ' | grep ''TransScore'''];
    else %pure STTK
        if reordering
            alscale = theta(end,2);
        else
            alscale = 0;
        end
        lmscale = theta(end,1);
        slscale = theta(end,end);
    
        %commandstr = sprintf('../../FromProgress/Latest/STTK2K4/bin/MBR-bak --NBestFile=Lr1.0-Rw0.0-ScWSR.dev.feats --NBestCands=Lr1.0-Rw0.0-ScWSR.dev.cands --NumModelScores=4 --ScoringMetric=WSR --EndianSwap=0 --TMScale=1 --LMScale=%g --ALScale=%g --SLScale=%g --DrawSize=20 | grep ''TransScore: ''',theta(end,1),theta(end,2),theta(end,3));
        commandstr = sprintf('/nfs/dish2/ashishv/FromProgress/Latest/STTK2K4/bin/MBRFast --GlobalScoring=1 --DuplicateMode=2 --NBestFile=%s --NBestCands=%s --NumModelScores=4 --ScoringMetric=IBMBLEU --EndianSwap=0 --TMScale=1 --LMScale=%g --ALScale=%g --SLScale=%g --DrawSize=20 | grep ''TransScore''',feats_file,cands_file,lmscale,alscale,slscale);
        %commandstr = sprintf('/nfs/dish2/ashishv/FromProgress/Latest/STTK2K4/bin/MBR --DuplicateMode=2 --NBestFile=feats.opt --NBestCands=cands.opt --NumModelScores=4 --ScoringMetric=WSR --EndianSwap=0 --TMScale=1 --LMScale=%g --ALScale=0 --SLScale=%g --DrawSize=20 | grep ''TransScore''',theta(end,1),theta(end,2));

        thetastr = '';
        for itmp = 1:theta_dim
               thetastr = [thetastr theta_names{itmp} ' ' sprintf('%g',theta(end,itmp)) '\n'];
        end
        
    end
    disp(commandstr);
    [exit_code,mbr_output] = unix(commandstr, '-echo');
    if (exit_code > 0)
        error('Exit code >0 when running MBR');
    end
    tmpvar = regexp(mbr_output,'.*TransScoreMBR: (.*)\n.*TransScoreSumMAP: (.*)\n.*TransScoreMaxMAP: (.*)\n', 'tokens', 'once');
    mbrscore(end+1) = sscanf(tmpvar{1},'%g');
    mapscore(end+1) = sscanf(tmpvar{2},'%g');
    mapmaxscore(end+1) =  sscanf(tmpvar{3},'%g');
    if maptraining == 1
      score(end+1) = mapscore(end);
    elseif maptraining == 0
      score(end+1) = mbrscore(end);
    elseif maptraining == 2 %mapmax training
      score(end+1) = mapmaxscore(end);
    else
        error('bloody hell...');
    end
    disp(score(end));
    
    
    %x=theta(end,1);
    %y=theta(end,2);
    %score(end+1) = mvnpdf(theta(end,:),[0,0]);
    %score(end+1) = theta(end,1)*theta(end,2);    
    %score(end+1) = sin(x*y)/(x*y);
    %score(end+1) = sin(max(abs(x),.0000000000001))/max(abs(x),.0000000000001)+sin(max(abs(y),.0000000000001))/max(abs(y),.0000000000001);
    
    
    
    
    %updating the score estimates
    effect_on_grid_values = mvnpdf(X,theta(end,:),Sigma)';
    sampling_bias_correction = 1 ./ (pdf); % accounting for the fact that grid cells with high pdf value are sampled from more often
    pseudocounts = 10*realmin + effect_on_grid_values .* sampling_bias_correction; %10*minreal to avoid zero-values
    score_estimates(2,:) = score_estimates(2,:) + pseudocounts;
    score_estimates(1,:) = score_estimates(1,:) + pseudocounts * score(end);

    %now do the pdf update
    disp('       (calculating pdf for next iteration...)');
    Y = score_estimates(1,:) ./ score_estimates(2,:); % get score estimates for each grid cell
    Y_I_scaled = spread_factor * (Y - min(Y)) + realmin; % +realmin in order to avoid division by zero when normalizing
    almost_pdf = Y_I_scaled / (sum(Y_I_scaled));
    pdfbak = pdf; %just for diagnostics purposes
    pdf = (almost_pdf + .2 / length(almost_pdf) ) / ( sum(almost_pdf) + .2 );


    %     if it ~= 1
    %         for i = 1:theta_dim
    %             current_pivot_points = pivots{i}(2:end-1); %we're not modelling the border pivot points
    %             invlogsigpdf = invlogsig(pdf{i});
    %             invlogsigpdf = invlogsigpdf + alpha * (score(end)-mean(score)) * normpdf(current_pivot_points, theta(end,i),1) ;
    %             newpdf = logsig(invlogsigpdf);
    %             pdf{i} = newpdf / sum(newpdf);
    %         end
    %     end

    %finally, update the best_score
    if score(end)>best_score
        best_score = score(end);
        best_theta = theta(end,:);
        best_commandstr = commandstr;
        best_thetastr = thetastr;
    end

    if mod(it,1) == 0
        it
        disp(sprintf('score: %g, best score: %g', score(end), best_score));
        disp('theta: ');
        disp(theta(end,:));
        disp('best theta: ');
        disp(best_theta);
        best_thetastr
        best_commandstr
        %disp('Y:');
        %disp(Y);
        %disp('Y_I_scaled');
        %disp(Y_I_scaled);
        %disp('pdf:');
        %disp(pdf);

        if it >= 3 && theta_dim <= 2	  
            disp('Visualizing...');
            %[XI,YI] = meshgrid(pivots{1}(1):.1:pivots{1}(end),pivots{2}(1):.1:pivots{2}(end));
           x = theta(:,1)';
           y = theta(:,2)';
           z = score;
           XItmp = XI_cell{1};
           YItmp = XI_cell{2};
            ZItmp = griddata(x,y,z,XItmp,YItmp);
            %Plot the gridded data along with the nonuniform data points used to generate it:
            mesh(XItmp,YItmp,ZItmp), hold
            plot3(best_theta(1),best_theta(2),best_score,'x');
            plot3(x,y,z,'o'), hold off
            disp('press key for pdf');            
            pause
            ZItmp = griddata(X(:,1)',X(:,2)',pdf,XItmp,YItmp);
            meshc(XItmp,YItmp,ZItmp), hold on
            plot3(X(:,1)',X(:,2)',pdf,'o'), hold off
            disp('press key to continue');            
            pause
            
            %meshc(theta(:,1)',theta(:,2)',score);
        end
    end

    toc

end


