/**CFile***********************************************************************

  FileName    [io.c]

  PackageName [utils]

  Synopsis    [Simple pretty printing]

  Description [Routines that provides some simple pretty printing routines.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "util.h"
#include "node.h"
#include "assoc.h"
#include "dd.h"
#include "grammar.h"
#include "io.h"
#include "error.h"
#include "opt.h"
#include "compile.h"

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern options_ptr options;
extern FILE *nusmv_stderr;

/**Variable********************************************************************

  Synopsis    [Number of spaces to be printed at the beginning of the line.]

  Description [Number of spaces to be printed at the beginning of the
  line. It is used to represent recursive calls to the evaluator. Each
  time the evaluator recursively call itself, than this variable is
  incremented and after the call decremented.]

  SeeAlso     []

******************************************************************************/
static int indent_size = 0;
void inc_indent_size(void) { indent_size++;}
void dec_indent_size(void) { indent_size--;}
int get_indent_size(void) { return(indent_size);}

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

void indent(FILE *stream)
{
  int i;

  for(i=0; i < get_indent_size(); i++) fprintf(stream, "  ");
}

void indent_node(FILE *stream, char *s1, node_ptr n, char *s2)
{
  indent(stream);
  fprintf(stream, "%s", s1);
  print_node(stream, n);
  fprintf(stream, "%s", s2);
}

/*
  This function prints out string "s" followed by the process
  name. This function is only used if verbose mode is greter than zero.
*/
void print_in_process(char *s, node_ptr context)
{
  fprintf(nusmv_stderr, "%s", s);
  if(context != Nil) indent_node(nusmv_stderr, " in process ", context, "");
  fprintf(nusmv_stderr, "...\n");
}

