/**CHeaderFile*****************************************************************

  FileName    [error.h]

  PackageName [utils]

  Synopsis    [header for the error.c file]

  Description [header for the error.c file.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _ERROR_H
#define _ERROR_H

#include "node.h"
/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

void init_the_node ARGS((void));
void set_the_node ARGS((node_ptr));
node_ptr get_the_node ARGS((void));
void io_atom_pop ARGS((void));
void io_atom_push ARGS((node_ptr));
void start_parsing_err ARGS((void));
void finish_parsing_err ARGS((void));
void nusmv_exit ARGS((int));
int util_setjmp ARGS((void));
void rpterr ARGS((const char *, ...));
void internal_error ARGS((const char *, ...));
void error_multiple_substitution ARGS((node_ptr));
void division_by_zero ARGS((void));
void range_error ARGS((node_ptr, node_ptr));
void type_error ARGS((node_ptr));
void error_redefining ARGS((node_ptr));
void error_undefined ARGS((node_ptr));
void error_circular ARGS((node_ptr));
void error_too_many_vars ARGS((void));
void error_not_a_number ARGS((node_ptr));
void error_multiple_assignment ARGS((node_ptr));
void error_empty_range ARGS((node_ptr, int, int));
void error_assign_both ARGS((node_ptr, node_ptr, int, int));
void error_multiple_substitution ARGS((node_ptr));
void error_unknown_var_in_order_file ARGS((node_ptr));
void error_var_appear_twice_in_order_file ARGS((node_ptr));
void warning_var_appear_twice_in_order_file ARGS((node_ptr));
void warning_variable_not_declared ARGS((node_ptr));
void warning_missing_variable ARGS((node_ptr));
void error_var_not_in_order_file ARGS((node_ptr));
void cancel_util_setjmp ARGS((void));
void set_longjmp_on_err ARGS((void));
#endif /* _ERROR_H */
