/**CHeaderFile*****************************************************************

  FileName    [assoc.h]

  PackageName [util]

  Synopsis    [Simple assscoiative list]

  Description [Provides the user with a data structure that
  implemnts an associative list. If there is already an entry with
  the same ky in the table, than the value associated is replaced with
  the new one.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _ASSOC_H
#define _ASSOC_H

#include "st.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define ASSOC_DELETE ST_DELETE

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct st_table * hash_ptr;
typedef enum st_retval assoc_retval;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
hash_ptr new_assoc ARGS((void));
node_ptr find_assoc ARGS((hash_ptr, node_ptr));
void insert_assoc ARGS((hash_ptr, node_ptr, node_ptr));
void clear_assoc_and_free_entries ARGS((hash_ptr, ST_PFSR));
void clear_assoc ARGS((hash_ptr hash));

#endif /* _ASSOC_H */
