/**CFile***********************************************************************

  FileName    [smVers.c]

  PackageName [sm]

  Synopsis    [Supplies the compile date and version information.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "smInt.h"

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#ifndef CUR_DATE
#define CUR_DATE	"<compile date not supplied>"
#endif

#ifndef CUR_VER
#define CUR_VER         "NuSMV Release 1.0"
#endif

#ifndef LIBRARY
#define LIBRARY		"/projects/NuSMV/NuSMV/common/nusmv_lib"
#endif


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

static char * DateReadFromDateString(char * datestr);

/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Returns the current NuSMV version.]

  Description [Returns a static string giving the NuSMV version and compilation
  timestamp.  The user should not free this string.]
  
  SideEffects []

  SeeAlso     [Sm_NuSMVObtainLibrary]

******************************************************************************/
char *
Sm_NuSMVReadVersion(
   )
{
  static char version[1024];

  (void) sprintf(version, "%s (compiled %s)", CUR_VER, DateReadFromDateString(CUR_DATE));
  return version;
}


/**Function********************************************************************

  Synopsis    [Returns the NuSMV library path.]

  Description [Returns a string giving the directory which contains the
  standard NuSMV library.  Used to find things like the default .nusmvrc, the
  on-line help files, etc. It is the responsibility of the user to free the
  returned string.]

  SideEffects []

  SeeAlso     [Sm_NuSMVReadVersion]

******************************************************************************/
char *
Sm_NuSMVObtainLibrary(
   )
{
  char * nusmv_lib_path;

  nusmv_lib_path = getenv("NuSMV_LIBRARY_PATH");
  if (nusmv_lib_path) {
    return util_tilde_expand(nusmv_lib_path);
  } else {
    return util_tilde_expand(LIBRARY);
  }
}

/**Function********************************************************************

  Synopsis           [Start piping stdout through the "more" command]

  Description        [This function is  called to initialize piping
  stdout through "more". It is important to call Sm_NuSMVEndPrintMore before
  returning from your function and after
  calling Sm_NuSMVInitPrintMore (preferably at the end of your printing;
  failing to do so will cause the stdin lines not to appear).]

  SideEffects        []

  SeeAlso            [ Sm_NuSMVEndPrintMore]

******************************************************************************/
void
Sm_NuSMVInitPrintMore(
  )
{
    fflush(nusmv_stdout);
    nusmv_stdpipe = popen("more","w"); 
}
/**Function********************************************************************

  Synopsis           [Stop piping stdout through the "more" command]

  Description        [This function is  called to terminate piping
  stdout through "more". It is important to call Sm_NuSMVEndPrintMore  before exiting
  your function (preferably at the end of your printing; failing to do so will cause
  the stdin lines not to appear). The function returns a 0 if it fails.]

  SideEffects        []

  SeeAlso            [ Sm_NuSMVInitPrintMore]

******************************************************************************/
int
Sm_NuSMVEndPrintMore(
  )
{
    if (nusmv_stdpipe != NIL(FILE)) {  
    (void) pclose(nusmv_stdpipe);
    return 1;
    }
    return 0;
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis    [Returns the date in a brief format assuming its coming from
  the program `date'.]

  Description [optional]

  SideEffects []

******************************************************************************/
static char *
DateReadFromDateString(
  char * datestr)
{
  static char result[25];
  char        day[10];
  char        month[10];
  char        zone[10];
  char       *at;
  int         date;
  int         hour;
  int         minute;
  int         second;
  int         year;

  if (sscanf(datestr, "%s %s %2d %2d:%2d:%2d %s %4d",
             day, month, &date, &hour, &minute, &second, zone, &year) == 8) {
    if (hour >= 12) {
      if (hour >= 13) hour -= 12;
      at = "PM";
    }
    else {
      if (hour == 0) hour = 12;
      at = "AM";
    }
    (void) sprintf(result, "%d-%3s-%02d at %d:%02d %s", 
                   date, month, year % 100, hour, minute, at);
    return result;
  }
  else {
    return datestr;
  }
}





