/**CHeaderFile*****************************************************************

  FileName    [smInt.h]

  PackageName [sm]

  Synopsis    [Internal declarations for the main package.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: smInt.h,v 1.3 1997/02/18 17:42:18 hsv Exp $]

******************************************************************************/

#ifndef _SMINT
#define _SMINT

#if STDC_HEADERS
#  include <stdlib.h>
#else
   char * getenv();
#endif

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "grammar.h"
#include "parser.h"
#include "compile.h"
#include "img.h"
#include "mc.h"
#include "ltl.h"
#include "cmd.h"
#include "opt.h"

/* Yuan Lu */
#include "abs.h"


/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN void smBatchMain ARGS((void));
EXTERN void SmInit ARGS((void));
EXTERN void SmEnd ARGS((void));
EXTERN int main ARGS((int argc, char ** argv));
EXTERN void print_usage ARGS((void));
EXTERN void sm_AddCmd ARGS((void));

/*---------------------------------------------------------------------------*/
/* Variable declaration                                                      */
/*---------------------------------------------------------------------------*/
EXTERN options_ptr options;
EXTERN int longjmp_on_err;
EXTERN avl_tree *cmdFlagTable;
EXTERN options_ptr options;
EXTERN DdManager * dd_manager;
EXTERN FILE * nusmv_stderr;
EXTERN FILE * nusmv_stdout;
EXTERN node_ptr state_variables;
EXTERN node_ptr input_variables;
EXTERN node_ptr all_variables;
EXTERN node_ptr all_symbols;
EXTERN add_ptr state_variables_add;
EXTERN bdd_ptr state_variables_bdd;
EXTERN add_ptr next_state_variables_add;
EXTERN bdd_ptr next_state_variables_bdd;
EXTERN add_ptr next_input_variables_add;
EXTERN bdd_ptr next_input_variables_bdd;
EXTERN node_ptr real_state_variables;


EXTERN cmp_struct_ptr cmps;

EXTERN add_ptr input_variables_add;
EXTERN bdd_ptr input_variables_bdd;
EXTERN add_ptr init_add;
EXTERN bdd_ptr init_bdd;
EXTERN add_ptr trans_add;
EXTERN bdd_ptr trans_bdd;
EXTERN add_ptr invar_add;
EXTERN bdd_ptr invar_bdd;
EXTERN node_ptr cp_trans_add;
EXTERN node_ptr cp_trans_bdd;
EXTERN node_ptr dp_trans_add;
EXTERN node_ptr dp_trans_bdd;
EXTERN node_ptr Iwls95_Fwd_trans;
EXTERN node_ptr Iwls95_Bwd_trans;
EXTERN add_ptr frame_add;
EXTERN bdd_ptr reachable_states_bdd;
EXTERN node_ptr fairness_constraints_bdd;
EXTERN bdd_ptr fair_states_bdd;
EXTERN node_ptr forward_quantifiers_add;
EXTERN node_ptr forward_quantifiers_bdd;
EXTERN node_ptr reverse_quantifiers_add;
EXTERN node_ptr reverse_quantifiers_bdd;
EXTERN node_ptr parse_tree;

/* Yuan Lu */
EXTERN node_ptr abs_expr_pre;
EXTERN node_ptr abs_expr;
EXTERN FILE *err_out;

#endif /* _SMINT */
