/**CFile***********************************************************************

  FileName    [smInit.c]

  PackageName [sm]

  Synopsis    [Initializes and ends NuSMV.]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

  Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "smInt.h"

static char rcsid[] UTIL_UNUSED = "$Id: $";

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [Calls the initialization routines of all the packages.]

  SideEffects [Sets the global variables nusmv_stdout, nusmv_stderr,
  nusmv_historyFile.]

  SeeAlso     [SmEnd]

******************************************************************************/
void
SmInit(
   )
{
  cmdFlagTable = avl_init_table(strcmp);
  nusmv_stdout     = stdout;
  nusmv_stderr     = stderr;
  nusmv_historyFile = NIL(FILE);

  init_string();
  node_init();

  init_symbol_hash();
  init_param_hash();
  init_constant_hash();
  init_print_hash();
  init_frame_hash();
  init_value_hash();
  init_traces_hash();
  init_check_constant_hash();

  dd_manager = init_dd_package();
  init_the_node();

  Cmd_Init();
  options = init_options();

  /* Other init here */
  sm_AddCmd();
  dd_AddCmd();
  Parser_Init();
  Compile_Init();
  Mc_Init();
  Ltl_Init();
}


/**Function********************************************************************

  Synopsis    [Calls the end routines of all the packages.]

  SideEffects [Closes the output files if not the standard ones.]

  SeeAlso     [SmInit]

******************************************************************************/
void
SmEnd(
   )
{
  Cmd_End();
  Compile_End();
  Mc_End();
  
  if (nusmv_stdout != stdout) {  
    (void) fclose(nusmv_stdout);
  } 
  if (nusmv_stderr != stderr) {
    (void) fclose(nusmv_stderr);
  }
  if (nusmv_historyFile != NIL(FILE)) {
    (void) fclose(nusmv_historyFile);
  }

  clear_symbol_hash();
  clear_param_hash();
  clear_constant_hash();
  clear_print_hash();
  clear_frame_hash();
  clear_value_hash();
  clear_traces_hash();
  clear_check_constant_hash();

  if (opt_verbose_level_gt(options, 4)) {
    int result = dd_checkzeroref(dd_manager);
    if (result != 0) {
      fprintf(stderr,"%d non-zero DD reference counts after dereferencing\n", result);
    }
  }

  quit_dd_package(dd_manager);  
  nusmv_stdout     = stdout;
  nusmv_stderr   = stderr;
  nusmv_historyFile = NIL(FILE);


}
