/**CFile***********************************************************************

  FileName    [smCmd.c]

  PackageName [sm]

  Synopsis    [Interface of the sm package with the shell.]

  Description [Interface of the sm package with the shell.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/
#include "smInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

int CommandCmdReset(int argc, char **argv);
int CommandPrintUsage(int argc, char **argv);
/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/
static int UsageCmdReset ARGS((void));
static int UsagePrintUsage ARGS((void));
/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
void sm_AddCmd(void){
  Cmd_CommandAdd("reset", CommandCmdReset, 0);
  Cmd_CommandAdd("print_usage", CommandPrintUsage, 0);
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Implements the reset command.]

  CommandName        [reset] 	   

  CommandSynopsis    [Reset the whole system.]  

  CommandArguments   [\[-h\]]  

  CommandDescription [Resets the whole system, in order to read in
  another model and to perform verification on it.
  <p>
  Command options:<p>
  <dl>
    <dt> -h
       <dd> Print the command usage.
  </dl>]  

  SideEffects        []

******************************************************************************/
int CommandCmdReset(int argc, char ** argv)
{
  int c;

  util_getopt_reset();
  while((c = util_getopt(argc,argv,"h")) != EOF){
    switch(c){
    case 'h': return(UsageCmdReset());
    default:  return(UsageCmdReset());
    }
  }
  if (argc != util_optind) return(UsageCmdReset());

  if (opt_verbose_level_gt(options, 2))
    fprintf(nusmv_stderr, "Clearing all the hashes used by the compiler....");
  clear_symbol_hash();
  clear_param_hash();
  clear_constant_hash();
  clear_print_hash();
  clear_frame_hash();
  clear_value_hash();
  clear_traces_hash();
  clear_check_constant_hash();
  /* Clear the module hash */
  clear_module_hash();

  { /* Frees the list of state variables */
    node_ptr l = state_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of input variables */
    node_ptr l = input_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of variables */
    node_ptr l = all_variables;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }
  { /* Frees the list of variables */
    node_ptr l = all_symbols;

    while(l != Nil) {
      node_ptr m = l;

      l = cdr(l);
      free_node(m);
    }
  }

  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n");
    fprintf(nusmv_stderr, "Clearing the DD package....");
  }
  walk_dd(dd_manager, add_free, real_state_variables);
  if (frame_add != (add_ptr)NULL) add_free(dd_manager, frame_add);
  if (init_bdd != (bdd_ptr)NULL) bdd_free(dd_manager, init_bdd);
  if (trans_bdd != (bdd_ptr)NULL) bdd_free(dd_manager, trans_bdd);
  if (invar_bdd != (bdd_ptr)NULL) bdd_free(dd_manager, invar_bdd);
  walk_dd(dd_manager, bdd_free, dp_trans_bdd);
  walk_dd(dd_manager, bdd_free, cp_trans_bdd);
  walk_dd(dd_manager, bdd_free, forward_quantifiers_bdd);
  walk_dd(dd_manager, bdd_free, reverse_quantifiers_bdd);
  Iwls95FreeClustersList(dd_manager, Iwls95_Fwd_trans);
  Iwls95FreeClustersList(dd_manager, Iwls95_Bwd_trans);
  if (state_variables_bdd  != (bdd_ptr)NULL)
    bdd_free(dd_manager, state_variables_bdd);
  if (input_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, input_variables_bdd);
  if (next_state_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, next_state_variables_bdd);
  if (next_input_variables_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, next_input_variables_bdd);
  free_state_vars();
  walk_dd(dd_manager, bdd_free, fairness_constraints_bdd);
  if (fair_states_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, fair_states_bdd);
  if (reachable_states_bdd != (bdd_ptr)NULL)
    bdd_free(dd_manager, reachable_states_bdd);
  
  quit_dd_package(dd_manager);
  node_quit();

  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n\n");
    fprintf(nusmv_stderr, "Restarting the DD manager....");
  }

  node_init();
  dd_manager = init_dd_package();
  init_the_node();

  if (opt_verbose_level_gt(options, 2)) {
    fprintf(nusmv_stderr, "Done!!\n");
    fprintf(nusmv_stderr, "Resetting the compiler....");
  }
  cmps = cmp_struct_init();  /* reset all the flags */
  reset_input_order_file(options);
  reset_output_order_file(options);
  reset_encode();
  reset_interactive_mode();
  reset_trace_number();
  state_variables = Nil;
  all_symbols = Nil;
  all_variables = Nil;
  input_variables = Nil;
  real_state_variables = Nil;
  dp_trans_bdd = Nil;
  cp_trans_bdd = Nil;
  Iwls95_Fwd_trans = Nil;
  Iwls95_Bwd_trans = Nil;
  init_state_vars();
  init_add  = (add_ptr)NULL;
  init_bdd  = (bdd_ptr)NULL;
  trans_add = (add_ptr)NULL;
  trans_bdd = (bdd_ptr)NULL;
  frame_add = (add_ptr)NULL;
  invar_bdd = (bdd_ptr)NULL;
  forward_quantifiers_bdd = Nil;
  reverse_quantifiers_bdd = Nil;
  state_variables_add  = (add_ptr)NULL;
  state_variables_bdd  = (bdd_ptr)NULL;
  next_state_variables_add = (add_ptr)NULL;
  next_state_variables_bdd = (bdd_ptr)NULL;
  input_variables_add = (add_ptr)NULL;
  input_variables_bdd = (bdd_ptr)NULL;
  next_input_variables_add = (add_ptr)NULL;
  next_input_variables_bdd = (bdd_ptr)NULL;
  fairness_constraints_bdd = Nil;
  fair_states_bdd = (bdd_ptr)NULL;
  reachable_states_bdd = (bdd_ptr)NULL;

  if (opt_verbose_level_gt(options, 2)) fprintf(nusmv_stderr, "Done!!\n");
  return(0);
}

static int UsageCmdReset()
{
  (void) fprintf(nusmv_stderr, "usage: reset [-h]\n");
  (void) fprintf(nusmv_stderr, "   -h \t\tprint the command usage\n");
  return 1;
}


/**Function********************************************************************

  Synopsis           [Implements the print_usage command.]

  CommandName        [print_usage] 	   

  CommandSynopsis    [Prints processor and BDD statistics.]  

  CommandArguments   [\[-h\]]  

  CommandDescription [Prints a formatted dump of processor-specific
  usage statistics, and BDD usage statistics. For Berkeley Unix, this
  includes all of the information in the <tt>getrusage()</tt> structure.
  <p>
  Command options:<p>
  <dl>
    <dt> -h
       <dd> Print the command usage.
  </dl>]  

  SideEffects        [required]

******************************************************************************/
int CommandPrintUsage(int argc, char **argv)
{
  int c;

  util_getopt_reset();
  while((c = util_getopt(argc,argv,"h")) != EOF){
    switch(c) {
    case 'h': return(UsagePrintUsage());
    default:  return(UsagePrintUsage());
    }
  }
  /* Reporting of statistical information. */
  print_usage();
  return 0;
}

static int UsagePrintUsage()
{
  (void) fprintf(nusmv_stderr, "usage: print_usage [-h]\n");
  (void) fprintf(nusmv_stderr, "   -h \t\tprint the command usage\n");
  return 1;
}
