/**CFile***********************************************************************

  FileName    [parserUtil.c]

  PackageName [parser]

  Synopsis    [Parser utilities]

  Description [This file contains some parser utilities that allows
  for example to parse from a string, instead that from a file.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "parserInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Open a file and inform the parser to read from it]

  Description        [Open a file and inform the parser to start
  reading tokens from this file. If no input file is provided, then it
  inform the parser to start reading tokens from the standard input.]

  SideEffects        []

  SeeAlso            []

******************************************************************************/
void Parser_OpenInput(const char *filename)
{
  
  if (filename != (char *)NULL) {
    if(!(yyin = fopen(filename,"r")))
      rpterr("cannot open %s for input",filename);
    yylineno = 1;
  }
  if (yyin == NULL) yyin = stdin;
  /* Flushes the current input buffer */
  (void) yy_switch_to_buffer(yy_create_buffer(yyin, 16348));
  /*                                                ^^^^^ */
  /* Taken from the input.c flex generated file.          */
  (void) yyrestart(yyin);
}

/**Function********************************************************************

  Synopsis           [Close the input file]

  Description        [Closes the input file used from parser to read tokens.]

  SideEffects        []

  SeeAlso            []

******************************************************************************/
void Parser_CloseInput(void)
{
  /* (void) reset_input_file(options); */
  (void) fclose(yyin);
  yylineno = 0;
}

/**Function********************************************************************

  Synopsis           [Parses from a given string.]

  Description        [Creates a string, and then call <tt>yyparse</tt>
  to read from the created string. If a parsing error occurs than
  return 1, else return 0. The result of parsing is stored in
  <tt>pc</tt> to be used from the caller.]

  SideEffects        []

  SeeAlso            []

*****************************************************************************/
int Parser_ReadFromString(int argc, char **argv, char * head, char *tail, node_ptr *pc)
{
  int i;
  char * old_input_file;
  int l = strlen(head);
  int status = 0;
  char * cmd = NIL(char);
  
  for (i = 1; i < argc; i++) l += strlen(argv[i]) + 1;
  l += strlen(tail) +1;
  cmd = ALLOC(char, l);
  if (cmd == NIL(char)) {
    (void) fprintf(nusmv_stderr, "Parser_ReadFromString: unamble to allocate \"cmd\"\n");
    nusmv_exit(1);
  }
  sprintf(cmd, "%s", head);
  for (i = 1; i < argc; i++) sprintf(cmd, "%s%s ", cmd, argv[i]);
  sprintf(cmd, "%s%s", cmd, tail);
  if (opt_verbose_level_gt(options, 3)) (void)fprintf(nusmv_stderr, "%s\n", cmd);

  old_input_file = get_input_file(options);
  set_input_file(options, "<command-line>");

  parse_tree_int = Nil;
  yy_scan_string(cmd);
  if (yyparse() == 0) {
    status = 0;
  } else {
    status = 1;
  }
  /* We need to reset the input buffer */
  yyrestart(yyin);
  set_input_file(options, old_input_file);
  *pc = parse_tree_int;
  return(status);
}
