/**CFile***********************************************************************

  FileName    [parserCmd.c]

  PackageName [parser]

  Synopsis    [Interface of the parser package with the shell.]

  Description [Provides command for reading the NuSMV input file and
  build an internal representation of it.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "parserInt.h" 

static char rcsid[] UTIL_UNUSED = "$Id: $";

int CommandReadModel(int argc, char **argv);

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/
static int UsageReadModel ARGS((void));

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Initializes the parser]

  Description        [Initializes the parser]

  SideEffects        []

  SeeAlso            []

******************************************************************************/
void Parser_Init(void)
{
  Cmd_CommandAdd("read_model", CommandReadModel, 0);
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis           [Reads a NuSMV file into NuSMV.]

  CommandName        [read_model] 	   

  CommandSynopsis    [Reads a NuSMV file into NuSMV.]  

  CommandArguments   [\[-h\] \[-i model-file\]]  

  CommandDescription [Reads a NuSMV file. If the <tt>-i</tt> option is
  not specified, it reads from the file specified in the environment
  variable <tt>input_file</tt>.<p>
  Command options:<p>
  <dl>
    <dt> <tt>-i model-file</tt>
       <dd> Sets the environment variable <tt>input_file</tt> to
           <tt>model-file</tt>, and reads the model from it.
  </dl>]  

  SideEffects        []

******************************************************************************/
int CommandReadModel(int argc, char ** argv)
{
  int c;

  if (cmp_struct_get_read_model(cmps)) {
    fprintf(nusmv_stderr, "A model appear to be already read from file: %s.\n",
            get_input_file(options));
    return 1;
  }

  util_getopt_reset();
  while((c = util_getopt(argc,argv,"i:h")) != EOF){
    switch(c){
    case 'i': {
      set_input_file(options, util_optarg);
      break;
    }
    case 'h': return(UsageReadModel());
    default:  return(UsageReadModel());
    }
  }
  if (argc != util_optind) return(UsageReadModel());

  if (get_input_file(options) == (char *)NULL) {
    fprintf(nusmv_stderr, "Input file is (null). You must set the input file before.\n");
    return 1;
  }

  Parser_OpenInput(get_input_file(options));

  /* Parse the input file */
  if (opt_verbose_level_gt(options, 0)) {
    fprintf(nusmv_stderr, "Parsing file \"%s\" ..... ", get_input_file(options));
    fflush(nusmv_stderr);
  }
  if (yyparse()) nusmv_exit(1);
  if (opt_verbose_level_gt(options, 0)) {
    fprintf(nusmv_stderr, "done.\n");
    fflush(nusmv_stderr);
  }
  
  Parser_CloseInput();
  parse_tree = reverse(parse_tree);
  cmp_struct_set_read_model(cmps);
  return 0;
}

static int UsageReadModel()
{
  (void) fprintf(nusmv_stderr, "usage: read_model [-h] [-i ifile]\n");
  (void) fprintf(nusmv_stderr, "   -h \t\tprint the command usage\n");
  return 1;
}
