%{
/**CFile***********************************************************************

  FileName    [input.l]

  PackageName [parser]

  Synopsis    [Lexical analyzer for the NuSMV input language]

  SeeAlso     [grammar.y]

  Author      [Marco Roveri]

  Copyright   [Copyright (c) 1998 by ITC-IRST and Carnegie Mellon University.
  All Rights Reserved.  This software is for educational purposes only.
  Permission is given to use, copy, modify, and distribute this software
  and its documentation provided that this introductory message is not
  removed and no monies are exchanged. No guarantee is expressed or
  implied by the distribution of this code. 
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/

#include "util.h"
#include "utils.h"
#include "node.h"
#include "grammar.h"

static char rcsid[] UTIL_UNUSED = "$Id: $";

%}
%a	15000
%o	25000
%%
[ \n\t]                 ;
"--".*\n                ;
"#".*\n                 sscanf(yytext,"# %d",&yylineno);
"ASYNC"                 return(ASYNC);
"MODULE"                return(MODULE);
"process"               return(PROCESS);
"DEFINE"                return(DEFINE);
"VAR"                   return(VAR);
"IVAR"                  return(IVAR);
"CONSTANT"              return(CONSTANT);
"INIT"                  return(INIT);
"TRANS"                 return(TRANS);
"INVAR"                 return(INVAR);
"FORMAT"                return(FORMAT);
"SPEC"                  return(SPEC);
"LTLSPEC"               return(LTLSPEC);
"ABSTRACT"              return(ABSTRACT);
"GROUP"                 return(GROUP);
"COMPUTE"               return(COMPUTE);
"INVARSPEC"             return(INVARSPEC);
"CHECKINVARIANTFB"      return(CHECKINVARIANTFB);
"CHECKINVARIANTSTRONG"  return(CHECKINVARIANTSTRONG);
"AFTER"                 return(AFTER);
"FAIRNESS"              return(FAIRNESS);
"ISA"                   return(ISA);
"ASSIGN"                return(ASSIGN);
"INPUT"                 return(INPUT);
"OUTPUT"                return(OUTPUT);
"IMPLEMENTS"            return(IMPLEMENTS);
"GOTO"                  return(GOTO);
"LET"                   return(LET);
"STEP"                  return(STEP);
"EVAL"                  return(EVAL);
"RESET"                 return(RESET);
"array"                 return(ARRAY);
"of"                    return(OF);
"boolean"               return(BOOLEAN);
"EX"                    return(EX);
"AX"                    return(AX);
"EF"                    return(EF);
"AF"                    return(AF);
"EG"                    return(EG);
"AG"                    return(AG);
"E"                     return(EE);
"F"                     return(OP_FUTURE);
"G"                     return(OP_GLOBAL);
"X"                     return(OP_NEXT);
"A"                     return(AA);
"U"                     return(UNTIL);
"BU"                    return(BUNTIL);
"EBF"                   return(EBF);
"ABF"                   return(ABF);
"EBG"                   return(EBG);
"ABG"                   return(ABG);
"MIN"                   return(MMIN);
"MAX"                   return(MMAX);
"("                     return(LP);
")"                     return(RP);
"["                     return(LB);
"]"                     return(RB);
"{{"                    return(LLCB);
"}}"                    return(RRCB);
"{"                     return(LCB);
"}"                     return(RCB);
"FALSE"                 {
				yylval.node = new_node(FALSEEXP,Nil,Nil);
				return(FALSEEXP);
			}
"TRUE"                  {
				yylval.node = new_node(TRUEEXP,Nil,Nil);
				return(TRUEEXP);
			}
"apropos"               return(APROPOS);
"case"                  return(CASE);
"esac"                  return(ESAC);
"if"                    return(IF);
"then"                  return(THEN);
"else"                  return(ELSE);
":="                    return(EQDEF);
"+"                     return(PLUS);
"-"                     return(MINUS);
"**"                    return(STAR);
"*"                     return(TIMES);
"/"                     return(DIVIDE);
"mod"                   return(MOD);
"="                     return(EQUAL);
"<="                    return(LE);
">="                    return(GE);
"<"                     return(LT);
">"                     return(GT);
"next"                  return(NEXT);
"init"                  return(SMALLINIT);
"sigma"                 return(SIGMA);
"self"                  return(SELF);
"union"                 return(UNION);
"in"                    return(SETIN);
".."                    return(TWODOTS);
"."                     return(DOT);
"->"                    return(IMPLIES);
"<->"                   return(IFF);
"|"                     return(OR);
"UU"                    return(UU);
"&"                     return(AND);
"!"                     return(NOT);
[A-Za-z_][A-Za-z0-9_\$#-]*  { 
                             yylval.node = new_node(ATOM,(node_ptr)find_string(yytext),Nil);
                             return(ATOM);
                           }
[0-9]+                  {
                          int i;
                          sscanf(yytext,"%d",&i);
                          yylval.node = new_node(NUMBER,(node_ptr)i,Nil);
                          return(NUMBER);
                        }
\"[^\"]*\"              {
                          yylval.node = new_node(QUOTE,(node_ptr)find_string(yytext),Nil);
                          return(QUOTE);
                        } /* Unused token */
","                     return(COMMA);
":"                     return(COLON);
";"                     return(SEMI);
.			rpterr("illegal character");
%%

