/**CHeaderFile*****************************************************************

  FileName    [opt.h]

  PackageName [opt]

  Synopsis    [The option header file.]

  Description [This file conatins a data structure to manage all the
  command line options of the NuSMV system.]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _OPTH
#define _OPTH

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define DEFAULT_PGM_NAME   (char *)NULL
#define DEFAULT_INPUT_FILE (char *)NULL
#define DEFAULT_INPUT_ORDER_FILE (char *)NULL
#define DEFAULT_OUTPUT_ORDER_FILE "temp.ord"
#define DEFAULT_CONJ_PART_THRESHOLD 0;
#define DEFAULT_IMAGE_CLUSTER_SIZE 1000;
#define DEFAULT_ABS_LEVEL_THRESHOLD 1000;

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef enum {false, true} boolean;
typedef enum {Monolithic, Disjunctive, Conjunctive, Iwls95CP} Partition_Method;

/**Struct**********************************************************************

  Synopsis    [The option data structure.]

  Description [The option data structure conatins the following fields:
  <ul>
  <li><b>pgm_name</b></li>
  <li><b>input_file</b></li>
  <li><b>input_order_file</b></li>
  <li><b>output_order_file</b></li>
  <li><b>verbose</b></li>
  <li><b>check_trans</li>
  <li><b>ignore_spec</b></li>
  <li><b>ignore_ltlspec</b></li>
  <li><b>ignore_invar</b></li>
  <li><b>ignore_invar_fb</b></li>
  <li><b>ignore_invar_strong</b></li>
  <li><b>ignore_after</b></li>
  <li><b>forward_search</b></li>
  <li><b>print_reachable</b></li>
  <li><b>enable_reorder</b></li>
  <li><b>partition_method</b></li>
  <li><b>conj_part_threshold</b></li>
  <li><b>image_cluster_size</b></li>
  <li><b>ignore_init_file</b></li>
  <li><b>ag_only</b></li>
  <li><b>gui_behavior</b></li>
  </ul>]

  SeeAlso     [optional]

******************************************************************************/
typedef struct options {
  char * pgm_name;
#define PROGRAM_NAME      "program_name"
  char * input_file;
#define INPUT_FILE        "input_file"
  char * input_order_file;
#define INPUT_ORDER_FILE  "input_order_file"
  char * output_order_file;
#define OUTPUT_ORDER_FILE "output_order_file"
  int verbose;
#define VERBOSE_LEVEL     "verbose_level"
  boolean ignore_spec;
#define IGNORE_SPEC       "ignore_spec"
  boolean ignore_ltlspec;
#define IGNORE_LTLSPEC    "ignore_ltlspec"
#ifdef OPT_QUANTIFY_INPUT
#define QUANTIFY_INPUT    "quantify_input"
  boolean quantify_input;
#endif
  boolean check_trans;
#define OPT_CHECK_TRANS   "check_trans"
  boolean ignore_invar;
#define IGNORE_INVAR      "ignore_invar"
  boolean ignore_invar_fb;
#define IGNORE_INVAR_FB   "ignore_invar_fb"
  boolean ignore_invar_strong;
#define IGNORE_INVAR_STRONG "ignore_invar_strong"
  boolean ignore_after;
#define IGNORE_AFTER      "ignore_after"
  boolean forward_search;
#define FORWARD_SEARCH    "forward_search"
  boolean print_reachable;
#define PRINT_REACHABLE   "print_reachable"
  boolean reorder;
#define ENABLE_REORDER    "enable_reorder"
  unsigned int reorder_method;
#define REORDER_METHOD    "reorder_method"
  boolean dynamic_reorder;
#define DYNAMIC_REORDER   "dynamic_reorder"
  boolean batch;
  Partition_Method partition_method;
#define PARTITION_METHOD  "partition_method"
  int conj_part_threshold;
#define CONJ_PART_THRESHOLD "conj_part_threshold"
  int image_cluster_size;
#define IMAGE_CLUSTER_SIZE "image_cluster_size"
  boolean ignore_init_file;
#define IGNORE_INIT_FILE  "ignore_init_file"
  boolean ag_only;
#define AG_ONLY_SEARCH    "ag_only_search"
  boolean gui_behavior;
#define GUI_BEHAVIOR    "gui_behavior"

/* Yuan Lu */
  int abs_level;
#define ABS_LEVEL	"abs_level"
  char *simulate_file;
#define SIMULATE_FILE	"simulate_file"
  int coi;
#define COI		"coi"

} options_rec, * options_ptr;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
options_ptr init_options ARGS((void));
void init_options_cmd ARGS((void));

void    set_pgm_name ARGS((options_ptr, char *));
void    reset_pgm_name ARGS((options_ptr));
char *  get_pgm_name ARGS((options_ptr));

void    set_input_file ARGS((options_ptr, char *));
void    reset_input_file ARGS((options_ptr));
char *  get_input_file ARGS((options_ptr));

void    set_input_order_file ARGS((options_ptr, char *));
void    reset_input_order_file ARGS((options_ptr));
char *  get_input_order_file ARGS((options_ptr));

void    set_output_order_file ARGS((options_ptr, char *));
void    reset_output_order_file ARGS((options_ptr));
char *  get_output_order_file ARGS((options_ptr));
boolean is_default_order_file ARGS((options_ptr opt));

/* Yuan Lu */
void    set_simulate_file ARGS((options_ptr, char *));
void    reset_simulate_file ARGS((options_ptr));
char *  get_simulate_file ARGS((options_ptr));

void    set_verbose_level ARGS((options_ptr, int));
boolean opt_verbose_level_eq ARGS((options_ptr, int));
boolean opt_verbose_level_gt ARGS((options_ptr, int));
boolean opt_verbose_level_ge ARGS((options_ptr, int));
boolean opt_verbose_level_lt ARGS((options_ptr, int));
boolean opt_verbose_level_le ARGS((options_ptr, int));

#ifdef OPT_QUANTIFY_INPUT
void    set_quantify_input ARGS((options_ptr));
void    unset_quantify_input ARGS((options_ptr));
void    reset_quantify_input ARGS((options_ptr));
boolean opt_quantify_input ARGS((options_ptr));
#endif

void    set_ignore_spec ARGS((options_ptr));
void    unset_ignore_spec ARGS((options_ptr));
boolean opt_ignore_spec ARGS((options_ptr));

void    set_ignore_ltlspec ARGS((options_ptr));
void    unset_ignore_ltlspec ARGS((options_ptr));
boolean opt_ignore_ltlspec ARGS((options_ptr));

void    set_check_trans ARGS((options_ptr));
void    unset_check_trans ARGS((options_ptr));
boolean opt_check_trans ARGS((options_ptr));

void    set_ignore_invar ARGS((options_ptr));
void    unset_ignore_invar ARGS((options_ptr));
boolean opt_ignore_invar ARGS((options_ptr));

void    set_ignore_invar_fb ARGS((options_ptr));
void    unset_ignore_invar_fb ARGS((options_ptr));
boolean opt_ignore_invar_fb ARGS((options_ptr));

void    set_ignore_invar_strong ARGS((options_ptr));
void    unset_ignore_invar_strong ARGS((options_ptr));
boolean opt_ignore_invar_strong ARGS((options_ptr));

void    set_ignore_after ARGS((options_ptr));
void    unset_ignore_after ARGS((options_ptr));
boolean opt_ignore_after ARGS((options_ptr));

void    set_forward_search ARGS((options_ptr));
void    unset_forward_search ARGS((options_ptr));
boolean opt_forward_search ARGS((options_ptr));

void    set_print_reachable ARGS((options_ptr));
void    unset_print_reachable ARGS((options_ptr));
boolean opt_print_reachable ARGS((options_ptr));

void    set_reorder ARGS((options_ptr));
void    unset_reorder ARGS((options_ptr));
boolean opt_reorder ARGS((options_ptr));

void    set_reorder_method ARGS((options_ptr, unsigned int));
void    unset_reorder_method ARGS((options_ptr));
unsigned int get_reorder_method ARGS((options_ptr));

void    set_dynamic_reorder ARGS((options_ptr));
void    unset_dynamic_reorder ARGS((options_ptr));
boolean opt_dynamic_reorder ARGS((options_ptr));

void    set_batch ARGS((options_ptr));
void    unset_batch ARGS((options_ptr));
boolean opt_batch ARGS((options_ptr));

void    set_partition_method ARGS((options_ptr, Partition_Method)); 
Partition_Method get_partition_method ARGS((options_ptr opt));
void    reset_partitioning_method ARGS((options_ptr));
void    set_monolithic ARGS((options_ptr));
void    set_conj_partitioning ARGS((options_ptr));
void    set_disj_partitioning ARGS((options_ptr));
void    set_iwls95cp_partitioning ARGS((options_ptr));
boolean opt_monolithic ARGS((options_ptr));
boolean opt_conj_partitioning ARGS((options_ptr));
boolean opt_disj_partitioning ARGS((options_ptr));
boolean opt_iwls95cp_partitioning ARGS((options_ptr));
                                 
void    set_conj_part_threshold ARGS((options_ptr, int));
void    reset_conj_part_threshold ARGS((options_ptr));
int     get_conj_part_threshold ARGS((options_ptr));

void set_image_cluster_size ARGS((options_ptr, int));
void reset_image_cluster_size ARGS((options_ptr));
int get_image_cluster_size ARGS((options_ptr));

void    set_ignore_init_file ARGS((options_ptr));
void    unset_ignore_init_file ARGS((options_ptr));
boolean opt_ignore_init_file ARGS((options_ptr));

void    set_ag_only ARGS((options_ptr));
void    unset_ag_only ARGS((options_ptr));
boolean opt_ag_only ARGS((options_ptr));

void    set_gui_behavior ARGS((options_ptr));
void    unset_gui_behavior ARGS((options_ptr));
boolean opt_gui_behavior ARGS((options_ptr));

/* Yuan Lu */
void    set_abs_level_threshold ARGS((options_ptr, int));
void    reset_abs_level_threshold ARGS((options_ptr));
int     get_abs_level_threshold ARGS((options_ptr));

Partition_Method str2method ARGS((char *));
char * method2str ARGS((Partition_Method m));
void print_partition_method  ARGS((FILE *));

#endif /* _OPTH */
