/**CFile***********************************************************************

  FileName    [nodePrint.c]

  PackageName [node]

  Synopsis    [Pretty prints a node struct.]

  Description [This function pretty print a node struct, in a way
  similar to a s-expression in LISP.]

  SeeAlso     []

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

******************************************************************************/
#include "nodeInt.h"

static char UTIL_UNUSED rcsid[] = "$Id: $";

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
void print_sexp(FILE *file, node_ptr node)
{
  /*  if(!node)return; */
  if(node == (node_ptr)(-1)) {
    fprintf(file,"No value");
    return;
  }
  if (node == Nil) {
    fprintf(file," Nil ");
    return;
  }
  switch(node_get_type(node)){
  case MODULE:
    fprintf(file,"\n(MODULE ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,") ");
    break;
  case MODTYPE:
    fprintf(file,"\n(MODTYPE ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case CASE:
    fprintf(file,"\n(CASE "); 
    print_sexp(file,car(node)); 
    print_sexp(file,cdr(node)); 
    fprintf(file,")"); 
    break;
  case CONS:
    fprintf(file,"\n(CONS ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    /*
    print_sexp_list(file,node);
    */
    break;
  case VAR:
    fprintf(file,"\n(VAR ");
    if ((car(node) != Nil) && (cdr(node) != Nil)) {
      fprintf(file,"(CAR ");
      fprintf(file,"(BDD TO BE PRINTED)");
      fprintf(file,")(CDR ");
      print_sexp(file,cdr(node));
      fprintf(file,")");
    } else if (cdr(node) != Nil) {
      fprintf(file,"(CDR ");
      print_sexp(file,cdr(node));
      fprintf(file,")");
      } else print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case ASSIGN:
    fprintf(file,"\n(ASSIGN ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case INVAR:
    fprintf(file,"\n(INVAR ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case TRANS:
    fprintf(file,"\n(TRANS ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case INIT:
    fprintf(file,"\n(INIT ");
    print_sexp(file,car(node));
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case COMPUTE:
    fprintf(file,"\n(COMPUTE ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case SPEC:
    fprintf(file,"\n(SPEC ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case ATOM:
    {
      string_ptr tmp_strp = (string_ptr) car(node);
      char * str = (char *) tmp_strp->text;
      fprintf(file,"(ATOM %s)",str);
      break;
    }
  case NUMBER:
    {
      int num = (int)car(node);
      fprintf(file,"\n(NUMBER %d)",num);
      break;
    }
  case TRUEEXP:
    {
      fprintf(file,"(TRUE)");
      break;
    }
  case FALSEEXP:
    {
      fprintf(file,"(FALSE)");
      break;
    }
  case BOOLEAN:
    fprintf(file,"(BOOLEAN)");
    break;
  case SELF:
    fprintf(file,"(SELF)");
    break;
  case SCALAR:
    fprintf(file,"(SCALAR ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case ARRAY:
    fprintf(file,"\n(ARRAY ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,") ");
    break;
  case DOT:
    fprintf(file,"(DOT ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case TWODOTS:
    fprintf(file,"\n(TWODOTS ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case COLON:
    fprintf(file,"\n(COLON ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EQDEF:
    fprintf(file,"\n\t(EQDEF ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case NEXT:
    fprintf(file,"\n(NEXT (");
    print_sexp(file,car(node));
    fprintf(file,")) ");
    break;
  case SMALLINIT:
    fprintf(file,"\n(SMALLINIT ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case AND:
    fprintf(file,"\n(AND ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case OR:
    fprintf(file,"\n(OR ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case IMPLIES:
    fprintf(file,"\n(IMPLIES ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case IFF:
    fprintf(file,"\n(IFF ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case NOT:
    fprintf(file,"\n(NOT ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case EX:
    fprintf(file,"\n(EX ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case AX:
    fprintf(file,"\n(AX ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case EF:
    fprintf(file,"\n(EF ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case AF:
    fprintf(file,"\n(AF ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case EG:
    fprintf(file,"\n(EG ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case AG:
    fprintf(file,"\n(AG ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case OP_GLOBAL:
    fprintf(file,"\n(G ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case OP_NEXT:
    fprintf(file,"\n(X ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case OP_FUTURE:
    fprintf(file,"\n(F ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case AU:
    fprintf(file,"\n(AU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EU:
    fprintf(file,"\n(EU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EBF:
    fprintf(file,"\n(EBF ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case ABF:
    fprintf(file,"\n(ABF ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EBG:
    fprintf(file,"\n(EBG ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case ABG:
    fprintf(file,"\n(ABG ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case ABU:
    fprintf(file,"\n(ABU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EBU:
    fprintf(file,"\n(EBU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case PLUS:
    fprintf(file,"\n(PLUS ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case MINUS:
    fprintf(file,"\n(MINUS ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case TIMES:
    fprintf(file,"\n(TIMES ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case DIVIDE:
    fprintf(file,"\n(DIVIDE ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case MOD:
    fprintf(file,"\n(MOD ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case EQUAL:
    fprintf(file,"\n(EQUAL ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case LT:
    fprintf(file,"\n(LT ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case GT:
    fprintf(file,"\n(GT ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case LE:
    fprintf(file,"\n(LE ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case GE:
    fprintf(file,"\n(GE ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case UNION:
    fprintf(file,"\n(UNION ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case SETIN:
    fprintf(file,"\n(SETIN ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case SIGMA:
    fprintf(file,"\n(SIGMA ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case MINU:
    fprintf(file,"\n(MINU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case MAXU:
    fprintf(file,"\n(MAXU ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case PROCESS:
    fprintf(file,"\n(PROCESS ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case FAIRNESS:
    fprintf(file,"\n(FAIRNESS ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case ISA:
    fprintf(file,"\n(ISA ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case DEFINE:
    fprintf(file,"\n(DEFINE ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case INPUT:
    fprintf(file,"\n(INPUT ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case OUTPUT:
    fprintf(file,"\n(OUTPUT ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case IMPLEMENTS:
    fprintf(file,"\n(FAIRNESS ");
    print_sexp(file,car(node));
    fprintf(file,")");
    break;
  case CONTEXT:
    fprintf(file,"\n(CONTEXT ");
    print_sexp(file,car(node));
    print_sexp(file,cdr(node));
    fprintf(file,")");
    break;
  case BDD:
    /* print_bdd(file,(bdd_ptr)car(node)); */
    fprintf(file,"(BDD TO BE PRINTED)");
    break;
  case SEMI:
    fprintf(file, "\n(SEMI ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case AFTER:
    fprintf(file, "\n (AFTER ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case UU:
    fprintf(file, "\n (AFTER ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case IFTHENELSE:
    fprintf(file, "\n (IFTHENELSE ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case STAR:
    fprintf(file, "\n (STAR ");
    print_sexp(file, car(node));
    fprintf(file, ")\n");
    break;
  case DL_ATOM:
    fprintf(file, "\n (DL_ATOM ");
    print_sexp(file, car(node));
    fprintf(file, ")\n");
    break;
#ifdef MBP
  case DOMAIN:
    fprintf(file, "(DOMAIN ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case FLUENTS:
    fprintf(file, "(FLUENTS ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case INERTIAL:
    fprintf(file, "(INERTIAL ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case ACTIONS:
    fprintf(file, "(ACTIONS ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case CAUSES:
    fprintf(file, "(CAUSES ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case PRECONDITIONS:
    fprintf(file, "(PRECONDITIONS ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case POSSIBLY:
    fprintf(file, "(POSSIBLY ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case INITIALLY:
    fprintf(file, "(INITIALLY ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case ALWAYS:
    fprintf(file, "(ALWAYS ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
  case GOAL:
    fprintf(file, "(GOAL ");
    print_sexp(file, car(node));
    print_sexp(file, cdr(node));
    fprintf(file, ")\n");
    break;
#endif
  default:
    fprintf(file,"\n\n ********* No Match \n");
    fprintf(file,"********** Descriptor: %d \n", node_get_type(node));
    break;
  }
  fprintf(file, "\n");
}
