/**CHeaderFile*****************************************************************

  FileName    [nodeInt.h]

  PackageName [node]

  Synopsis    [The internal header of the <tt>node</tt> package.]

  Description [None]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _node_int_h
#define _node_int_h

#include <stdio.h>
#include "util.h"
#include "utils.h"
#include "node.h"
#include "error.h"
#include "grammar.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define NODE_MEM_CHUNK 1022
#define NODE_HASH_SIZE 16381

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct node_mgr_ node_mgr_;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/
/**Struct**********************************************************************

  Synopsis    [The data structure of the <tt>node</tt> manager.]

  Description [The <tt>node</tt> manager. It provides memory
  management, and hashing.]

  SeeAlso     [DdManager]

******************************************************************************/
struct node_mgr_ {
  long allocated;            /* Number of nodes allocated till now */
  long memused;              /* Total memory allocated by the node manager */
  node_ptr * nodelist;       /* The node hash table */
  node_ptr * memoryList;     /* Memory manager for symbol table */
  node_ptr nextFree;         /* List of free nodes */
  hash_ptr subst_hash;       /* The substitution hash */
};

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
node_ptr insert_node ARGS((node_ptr node));

#endif /* _node_int_h */
