/**CHeaderFile*****************************************************************

  FileName    [mcInt.h]

  PackageName [mc]

  Synopsis    [Internal header file of the mc package.]

  Description [Internal header file of the mc package.]

  SeeAlso     [ mcMc.c mcExplain.c]

  Author      [Marco Roveri]

  Copyright   [ Copyright (c) 1998 by ITC-IRST and Carnegie Mellon
  University.  All Rights Reserved.  This software is for educational
  purposes only.  Permission is given to use, copy, modify, and
  distribute this software and its documentation provided that this
  introductory message is not removed and no monies are exchanged. No
  guarantee is expressed or implied by the distribution of this code.
  Send bug-reports and/or questions to: nusmv@irst.itc.it ]

  Revision    [$Id: $]

******************************************************************************/

#ifndef _MCINT
#define _MCINT

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>

#include "sm.h"
#include "util.h"
#include "utils.h"
#include "node.h"
#include "dd.h"
#include "grammar.h"
#include "parser.h"
#include "img.h"
#include "compile.h"
#include "opt.h"
#include "mc.h"
/* Yuan Lu */
#include "abs.h"

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

EXTERN FILE * nusmv_stderr;
EXTERN FILE * nusmv_stdout;
EXTERN DdManager * dd_manager;
EXTERN int yylineno;
EXTERN options_ptr options;
EXTERN cmp_struct_ptr cmps;

EXTERN node_ptr one_number;
EXTERN node_ptr zero_number;

EXTERN bdd_ptr invar_bdd;
EXTERN bdd_ptr init_bdd;
EXTERN bdd_ptr reachable_states_bdd;
EXTERN node_ptr reachable_states_layers;
EXTERN node_ptr fairness_constraints_bdd;
EXTERN bdd_ptr fair_states_bdd;

EXTERN node_ptr real_state_variables;
EXTERN add_ptr process_selector_add;
EXTERN bdd_ptr input_variables_bdd;

/* Yuan Lu */
EXTERN node_ptr abs_expr_pre;
EXTERN node_ptr abs_expr;

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/
EXTERN node_ptr ex_explain       ARGS((node_ptr p, bdd_ptr f));
EXTERN node_ptr eu_explain       ARGS((node_ptr p, bdd_ptr f, bdd_ptr g));
EXTERN node_ptr ebu_explain      ARGS((node_ptr p, bdd_ptr f, bdd_ptr g, int inf, int sup));
EXTERN node_ptr eg_explain       ARGS((node_ptr p, bdd_ptr g));
EXTERN node_ptr ebg_explain      ARGS((node_ptr p, bdd_ptr g, int inf, int sup));

#endif /* _MCINT */
